' compile with FreeBASIC win32
'
' see below for hints on setting up bitmasks for custom color depth

' atari128.pal has colors in the wrong order; use ctia.pal instead

' palette combining is hit or miss... shou ga nai deshou

' (7.2 dumps indexs, and has a bugfix)

' batch mode
' if first argument = "batch"
' then a pile of junk will follow containing all parameters
' eg. 15 c64.pal 2 y 8 8 0 0 2 infile outfile y
' depth [palfile] dlevel multipals [secw sech commoncolors [maxchanges] [maxpals]] palsize infile outfile [8bit]

' to do:
' better UI, output preview in a window?, with brightness/contrast adj ?

dim as integer l,ll,cl,yy,zz,dif,diff,rdiff,gdiff,bdiff,maxcolors
dim as integer maxcolors2
dim as integer h,v,ff1,ff2,ff3,x,y,z,xx,c,zzz,pa
dim as ushort s,linel,numpals,secwidth,secheight,pn,hpals,po,lcolors,vpo
dim as ushort maxchanges,maxpals,numpals2,po2,pa2,numpals3,numpals4
dim as ushort comcolors,stcolors
dim as short r2,g2,b2,i2,r,g,b,i
dim as ubyte a,minunit,outform,cmode,dlevel,r3,g3,b3,bmode,savei
dim as ubyte maskr1,maskr2,argh
dim as ubyte maskg1,maskg2
dim as ubyte maskb1,maskb2
dim as ubyte maski1,maski2
dim palmap(0 to 6143) as short
dim rerr(0 to 2) as short
dim colors(0 to 6143) as ushort
dim colors2(0 to 6143) as ushort
dim sums(0 to 6143,0 to 3) as integer
DIM clist1(0 TO 65535, 0 TO 2) as ubyte
DIM clist2(0 TO 32767, 0 TO 2) as ubyte
DIM comlist(0 TO 255, 0 TO 3) as ushort
DIM plist1(0 TO 65535) as integer
dim pallist(0 to 6143) as ushort
dim ifn as string
dim ofn as string
dim aa as string*1
dim whatevz as string

dim shared clist3(0 to 65535,0 to 2) as ubyte
dim shared plist3(0 to 65535) as integer

PRINT
PRINT "DamageX 24bit BMP -> 8/24bit palettized color reducer tensai"
PRINT "V7.2"
PRINT

bmode=0
if command$(1)="batch" then bmode=1
if command$(1)="BATCH" then bmode=1
argh=2

if bmode=0 then
print "select color depth"
print
print "1) RGB 777       2,097,152       (VBXE)"
print "2) RGB 666       262,144         (VGA)"
print "3) RGB 565       65,536"
print "4) RGBi 5551     65,536          (X68000)"
print "5) RGB 555       32,768          (SNES)"
print "6) RGB 444       4,096           (Amiga OCS)"
print "7) RGBi 3331     1,024"
print "8) RGB 333       512             (PCE)"
print "9) RGB 332       256             (MSX screen 8)"
print "10) RGBi 2221    128"
print "11) RGB 222      64              (SMS)"
print "12) RGBi 1111    16              (EGA)"
print "13) RGB 111      8               (PC-88)"
print "14) custom RGBi"
print "15) predefined palette from file (max 32K colors)"
end if

if bmode=1 then x=valint(command$(argh)):argh+=1:goto a110
a15:
? "option";:input x
a110:
maski1=0:maski2=0:maskr1=1:cmode=0

if x=1 then maskr1=254:maskg1=254:maskb1=254:maskr2=0:maskg2=0:maskb2=0
if x=2 then maskr1=252:maskg1=252:maskb1=252:maskr2=2:maskg2=2:maskb2=2
if x=3 then maskr1=248:maskg1=252:maskb1=248:maskr2=4:maskg2=2:maskb2=4
if x=4 then
maskr1=248:maskg1=248:maskb1=248:maskr2=4:maskg2=4:maskb2=4
maski1=7:maski2=4
end if
if x=5 then maskr1=248:maskg1=248:maskb1=248:maskr2=4:maskg2=4:maskb2=4
if x=6 then maskr1=240:maskg1=240:maskb1=240:maskr2=8:maskg2=8:maskb2=8
if x=7 then
maskr1=224:maskg1=224:maskb1=224:maskr2=16:maskg2=16:maskb2=16
maski1=31:maski2=16
end if
if x=8 then maskr1=224:maskg1=224:maskb1=224:maskr2=16:maskg2=16:maskb2=16
if x=9 then maskr1=224:maskg1=224:maskb1=192:maskr2=16:maskg2=16:maskb2=32
if x=10 then
maskr1=192:maskg1=192:maskb1=192:maskr2=32:maskg2=32:maskb2=32
maski1=63:maski2=32
end if
if x=11 then maskr1=192:maskg1=192:maskb1=192:maskr2=32:maskg2=32:maskb2=32
if x=12 then
maskr1=128:maskg1=128:maskb1=128:maskr2=64:maskg2=64:maskb2=64
maski1=127:maski2=64
end if
if x=13 then maskr1=128:maskg1=128:maskb1=128:maskr2=64:maskg2=64:maskb2=64

if x=14 then 
if bmode=1 then
maskr1=valint(command$(argh)):argh+=1
maskg2=valint(command$(argh)):argh+=1
maskb1=valint(command$(argh)):argh+=1
maskr2=valint(command$(argh)):argh+=1
maskg1=valint(command$(argh)):argh+=1
maskb2=valint(command$(argh)):argh+=1
maski1=valint(command$(argh)):argh+=1
maski2=valint(command$(argh)):argh+=1
goto a112
end if
PRINT "bitmask1 red"; : INPUT maskr1
PRINT "bitmask1 green"; : INPUT maskg1
PRINT "bitmask1 blue"; : INPUT maskb1
PRINT "bitmask2 red"; : INPUT maskr2
PRINT "bitmask2 green"; : INPUT maskg2
PRINT "bitmask2 blue"; : INPUT maskb2
PRINT "bitmask1 intensity"; : INPUT maski1
PRINT "bitmask2 intensity"; : INPUT maski2
a112:
end if

if x=15 then
if bmode=1 then ifn=command$(argh):argh+=1:goto a111
PRINT "load from what file"; : INPUT ifn
a111:
ff1=freefile
OPEN ifn FOR BINARY AS #ff1
for y=0 to 32767
get #ff1,,clist2(y,2)
get #ff1,,clist2(y,1)
get #ff1,,clist2(y,0)
if eof(ff1) then lcolors=y+1:goto a14
next y
lcolors=32768
a14:
close #ff1
if lcolors<2 then end
maskr1=2:cmode=1
end if

if maskr1=1 then goto a15

minunit = 1
a18:
IF (maskr1 AND minunit) THEN GOTO a19
IF (maskg1 AND minunit) THEN GOTO a19
IF (maskb1 AND minunit) THEN GOTO a19
IF (maski2 AND minunit) THEN GOTO a19
minunit = minunit + minunit: GOTO a18
a19:


if bmode=1 then dlevel=valint(command$(argh)):argh+=1:goto a113
a21:
PRINT "dithering level for palette color matching (0...2)"; : INPUT dlevel
a113:
IF dlevel < 0 THEN GOTO a21
IF dlevel > 2 THEN GOTO a21
if dlevel<>1 then maskr2=0:maskg2=0:maskb2=0


secwidth=0:secheight=0:maxchanges=0:maxpals=0
if bmode=1 then whatevz=command$(argh):argh+=1:goto a114
? "divide image area into multiple palettes (y/n)";:input whatevz
a114:
if ((whatevz="y") or (whatevz="Y")) then
if bmode=1 then
secwidth=valint(command$(argh)):argh+=1
secheight=valint(command$(argh)):argh+=1
comcolors=valint(command$(argh)):argh+=1
if secwidth=0 then maxchanges=valint(command$(argh)):argh+=1
if maxchanges=0 then maxpals=valint(command$(argh)):argh+=1
goto a115
end if
? "section width";:input secwidth
? "section height";:input secheight
? "colors shared among all palettes";:input comcolors
if secwidth=0 then ? "max color changes per row";:input maxchanges
if maxchanges=0 then PRINT "max number of palettes"; : INPUT maxpals
a115:
end if


if bmode=1 then maxcolors=valint(command$(argh)):argh+=1:goto a116
a17:
PRINT "palette size (2...65536)"; : INPUT maxcolors
IF maxcolors < 2 THEN GOTO a17
IF maxcolors > 65536 THEN GOTO a17
a116:

if maxchanges=0 then maxchanges=maxcolors


if bmode=1 then
ifn=command$(argh):argh+=1
ofn=command$(argh):argh+=1
goto a117
end if
PRINT "infile "; : INPUT ifn
PRINT "outfile "; : INPUT ofn
a117:

ff1=freefile
OPEN ifn FOR BINARY AS #ff1

GET #ff1, , s
IF s <> &H4D42 THEN PRINT "infile is not a 'BM'": END

l = 19
GET #ff1, l, h
l = 23
GET #ff1, l, v

PRINT "input file width = "; h; " height = "; v

if secwidth=0 then secwidth=h
if secheight=0 then secheight=v
numpals=(v+(secheight-1))\secheight
hpals=((h+(secwidth-1))\secwidth):numpals=numpals*hpals
if numpals>6144 then ? "too many palettes!":end

pa=65536\numpals

IF maxpals > numpals then maxpals=numpals
IF maxpals < 2 THEN maxpals=numpals

if maxpals<numpals then
for y=0 to 6143
sums(y,0)=0
sums(y,1)=0
sums(y,2)=0
sums(y,3)=0
next y
end if

outform=24
if maxcolors*maxpals<257 then
if bmode=1 then whatevz=command$(argh):argh+=1:goto a118
? "save as 8bpp instead of 24bpp (y/n)";:input whatevz
a118:
if whatevz="y" then outform=8
if whatevz="Y" then outform=8
end if


FOR x = 0 TO 65535: plist1(x) = 0: NEXT x

for x=0 to 6143:colors(x)=0:next x

yy = 55
linel=(((h*3)+3) and 32764)

dim shared lbuf(0 to linel-1) as ubyte
dim shared obuf(0 to h-1) as ubyte
dim shared ibuf(0 to h-1) as ushort
dim shared rawbm(0 to h-1,0 to v-1,0 to 2) as ubyte
dim shared workbm(0 to h-1,0 to v-1,0 to 2) as ubyte

? "loading image..."

FOR y = v - 1 TO 0 STEP -1
GET #ff1, yy, lbuf()
yy = yy + linel
xx=0

FOR x = 0 TO h - 1
b=lbuf(xx):xx=xx+1
g=lbuf(xx):xx=xx+1
r=lbuf(xx):xx=xx+1

if minunit>63 then r=((r*7) shr 3):g=((g*7) shr 3):b=((b*7) shr 3)

rawbm(x,y,0)=r
rawbm(x,y,1)=g
rawbm(x,y,2)=b
workbm(x,y,0)=r
workbm(x,y,1)=g
workbm(x,y,2)=b

NEXT x
NEXT y



PRINT "analyzing image..."

po=0:pn=0

FOR y = v - 1 TO 0 STEP -1

rerr(0)=0
rerr(1)=0
rerr(2)=0

if numpals>1 then vpo=(y\secheight)*hpals

FOR x = 0 TO h - 1
r=workbm(x,y,0)
g=workbm(x,y,1)
b=workbm(x,y,2)

if dlevel=2 then
if r<0 then r=0
if g<0 then g=0
if b<0 then b=0
if r>255 then r=255
if g>255 then g=255
if b>255 then b=255
end if

if numpals>1 then pn=vpo+(x\secwidth):po=pn*pa

if cmode=0 then
IF ((y + x) AND 1) THEN
IF (r and maskr2) THEN r = r + maskr2:if r>255 then r=255
IF (g and maskg2) THEN g = g + maskg2:if g>255 then g=255
IF (b and maskb2) THEN b = b + maskb2:if b>255 then b=255
END IF
i = ((r AND maski1) + (g AND maski1) + (b AND maski1)) \ 3
i2 = (i AND maski2)
r2 = (r AND maskr1)+i2:rerr(0)=r-r2
g2 = (g AND maskg1)+i2:rerr(1)=g-g2
b2 = (b AND maskb1)+i2:rerr(2)=b-b2
end if

if cmode=1 then
zz=((y+x) and 1)
a45:
diff = 200000: c = 0
FOR z = 0 TO lcolors - 1
rdiff = clist2(z, 0) - r
gdiff = clist2(z, 1) - g
bdiff = clist2(z, 2) - b
dif = rdiff * rdiff + gdiff * gdiff + bdiff * bdiff
IF dif = 0 THEN c = z: GOTO a24
IF dif < diff THEN diff = dif: c = z
NEXT z
a24:
r2=clist2(c,0):rerr(0)=r-r2
g2=clist2(c,1):rerr(1)=g-g2
b2=clist2(c,2):rerr(2)=b-b2
if dlevel=1 then
r+=(rerr(0) shr 1)
g+=(rerr(1) shr 1)
b+=(rerr(2) shr 1)
if r<0 then r=0
if g<0 then g=0
if b<0 then b=0
if r>255 then r=255
if g>255 then g=255
if b>255 then b=255
if zz=1 then zz=0:goto a45
end if
end if

if dlevel=2 then
for z=0 to 2
if x<h-1 then
i=workbm(x+1,y,z):i+=((7*rerr(z)) shr 4)
if i<0 then i=0
if i>255 then i=255
workbm(x+1,y,z)=i
end if
if y>0 then
if x>0 then
i=workbm(x-1,y-1,z):i+=((3*rerr(z)) shr 4)
if i<0 then i=0
if i>255 then i=255
workbm(x-1,y-1,z)=i
end if
i=workbm(x,y-1,z):i+=((5*rerr(z)) shr 4)
if i<0 then i=0
if i>255 then i=255
workbm(x,y-1,z)=i
if x<h-1 then
i=workbm(x+1,y-1,z):i+=(rerr(z) shr 4)
if i<0 then i=0
if i>255 then i=255
workbm(x+1,y-1,z)=i
end if
end if
next z
end if

if maxpals<numpals then
sums(pn,3)+=1
sums(pn,0)+=r2
sums(pn,1)+=g2
sums(pn,2)+=b2
end if

IF colors(pn) = 0 THEN palmap(pn)=pn:GOTO a130

FOR z = po TO po+(colors(pn) - 1)
IF r2 <> clist1(z, 0) THEN GOTO a131
IF g2 <> clist1(z, 1) THEN GOTO a131
IF b2 <> clist1(z, 2) THEN GOTO a131
plist1(z) = plist1(z) + 1
'keep the list sorted as we go along
a133:
IF z = po THEN GOTO a132
IF plist1(z) <= plist1(z - 1) THEN GOTO a132
c = clist1(z - 1, 0): clist1(z - 1, 0) = clist1(z, 0): clist1(z, 0) = c
c = clist1(z - 1, 1): clist1(z - 1, 1) = clist1(z, 1): clist1(z, 1) = c
c = clist1(z - 1, 2): clist1(z - 1, 2) = clist1(z, 2): clist1(z, 2) = c
cl = plist1(z - 1): plist1(z - 1) = plist1(z): plist1(z) = cl
z = z - 1
GOTO a133
a131:
NEXT z

a130:       'add color to list
IF colors(pn)>pa THEN PRINT "too many colors, try lower depth or fewer palettes":END
clist1(po+colors(pn), 0) = r2
clist1(po+colors(pn), 1) = g2
clist1(po+colors(pn), 2) = b2
plist1(po+colors(pn)) = 1
colors(pn) = colors(pn) + 1

a132:
NEXT x
NEXT y


a13:
CLOSE #ff1


PRINT "building optimal palette..."


if maxpals<numpals then
for y=0 to numpals-1
sums(y,0)=sums(y,0)\sums(y,3)
sums(y,1)=sums(y,1)\sums(y,3)
sums(y,2)=sums(y,2)\sums(y,3)
next y
numpals2=numpals
diff=1
' initialize colors2
for y=0 to numpals-1
colors2(y)=1
next y

' reduce the list of region average colors to a quantity equal maxpals
' and track the reassignments in palmap
a22:
FOR z = numpals2-1 TO 1 STEP -1
r = sums(z, 0)
g = sums(z, 1)
b = sums(z, 2)
FOR zz = 0 TO z - 1
rdiff = sums(zz, 0) - r
gdiff = sums(zz, 1) - g
bdiff = sums(zz, 2) - b
IF rdiff * rdiff + gdiff * gdiff + bdiff * bdiff < diff THEN GOTO a100
NEXT zz
GOTO a101
a100:
colors2(zz) = colors2(zz) + colors2(z)
for x=0 to numpals-1
if palmap(x)=z then palmap(x)=zz
next x
a103:
IF zz = 0 THEN GOTO a102
IF colors2(zz) <= colors2(zz - 1) THEN GOTO a102
zzz = zz - 1
c = sums(zzz, 0): sums(zzz, 0) = sums(zz, 0): sums(zz, 0) = c
c = sums(zzz, 1): sums(zzz, 1) = sums(zz, 1): sums(zz, 1) = c
c = sums(zzz, 2): sums(zzz, 2) = sums(zz, 2): sums(zz, 2) = c
cl = colors2(zzz): colors2(zzz) = colors2(zz): colors2(zz) = cl
for x=0 to numpals-1
if palmap(x)=zz then palmap(x)=zzz:goto a94
if palmap(x)=zzz then palmap(x)=zz
a94:
next x
zz = zzz
GOTO a103
a102:
numpals2=numpals2-1
if z<numpals2 then
FOR zz = z TO numpals2-1
sums(zz, 0) = sums(zz + 1, 0)
sums(zz, 1) = sums(zz + 1, 1)
sums(zz, 2) = sums(zz + 1, 2)
colors2(zz) = colors2(zz + 1)
for x=0 to numpals-1
if palmap(x)=zz+1 then palmap(x)=zz
next x
NEXT zz
end if
IF numpals2=maxpals THEN GOTO a104
a101:
NEXT z
diff = diff+1: GOTO a22
a104:

'for x=0 to maxpals-1
'? sums(x,0),sums(x,1),sums(x,2)
'next x

' re-number the palettes that are remaining
numpals3=1
pallist(0)=palmap(0)
palmap(0)=0
for x=1 to numpals-1
c=palmap(x)
for y=0 to numpals3-1
if pallist(y)=c then palmap(x)=y:goto a93
next y
pallist(numpals3)=c
palmap(x)=numpals3
numpals3+=1
a93:
next x


a99:
' rebuild clist

pa2=65536\maxpals

for x=0 to maxpals-1
colors2(x)=0
next x

for x=0 to numpals-1
y=palmap(x)
po=pa*x
po2=pa2*y
for z=po to po+colors(x)-1
r=clist1(z,0):g=clist1(z,1):b=clist1(z,2)
if colors2(y)>0 then 
for zz=po2 to po2+colors2(y)-1
if clist3(zz,0)<>r then goto a95
if clist3(zz,1)<>g then goto a95
if clist3(zz,2)<>b then goto a95
plist3(zz)+=plist1(z)
goto a96
a95:
next zz
end if
' add color from x/po to y/po2
zz=po2+colors2(y)
clist3(zz,0)=r:clist3(zz,1)=g:clist3(zz,2)=b
plist3(zz)=plist1(z)
a97:
IF zz = po2 THEN GOTO a98
IF plist3(zz) <= plist3(zz - 1) THEN GOTO a98
zzz = zz - 1
c = clist3(zzz, 0): clist3(zzz, 0) = clist3(zz, 0): clist3(zz, 0) = c
c = clist3(zzz, 1): clist3(zzz, 1) = clist3(zz, 1): clist3(zz, 1) = c
c = clist3(zzz, 2): clist3(zzz, 2) = clist3(zz, 2): clist3(zz, 2) = c
cl = plist3(zzz): plist3(zzz) = plist3(zz): plist3(zz) = cl
zz = zzz
GOTO a97
a98:
colors2(y)=colors2(y)+1
if colors2(y)>pa2 then ? "uh oh :) too many colors/palettes":end
a96:
next z
a106:
next x

' put results back in clist1/plist1 so we can continue as usual
numpals4=numpals
numpals=maxpals
pa=pa2
for pn=0 to numpals-1
po=pn*pa
for x=po to po+colors2(pn)-1
clist1(x,0)=clist3(x,0)
clist1(x,1)=clist3(x,1)
clist1(x,2)=clist3(x,2)
plist1(x)=plist3(x)
next x
colors(pn)=colors2(pn)
next pn
end if


stcolors=0

a34:
for pn=0 to numpals-1

po=pn*pa
maxcolors2=maxcolors

' check whether there is a limit on color changes between palettes
' and modify the colors limit for this palette if needed
' (but if we are doing two passes then only affect the 2nd pass)
if pn=0 then goto a90
if comcolors>0 then if stcolors=0 then goto a90
if maxchanges<maxcolors then
c=0
for z=(po-pa)+stcolors to (po-pa)+colors(pn-1)-1
r = clist1(z, 0)
g = clist1(z, 1)
b = clist1(z, 2)
for zz=po+stcolors to po+colors(pn)-1
if clist1(zz,0)<>r then goto a91
if clist1(zz,1)<>g then goto a91
if clist1(zz,2)<>b then goto a91
c=c+1:goto a92
a91:
next zz
a92:
next z
maxcolors2=maxchanges+c+stcolors
if maxcolors2>maxcolors then maxcolors2=maxcolors
end if
a90:


IF colors(pn) > maxcolors2 THEN
diff = 1
if stcolors=0 then diff=diff+minunit
a60:
FOR z = po+(colors(pn) - 1) TO stcolors+po STEP -1
if z=po then goto a51
r = clist1(z, 0)
g = clist1(z, 1)
b = clist1(z, 2)
FOR zz = po TO z - 1
rdiff = clist1(zz, 0) - r
gdiff = clist1(zz, 1) - g
bdiff = clist1(zz, 2) - b
IF rdiff * rdiff + gdiff * gdiff + bdiff * bdiff < diff THEN GOTO a10
NEXT zz
GOTO a20
a10:
plist1(zz) = plist1(zz) + plist1(z)
a40:
IF zz <= po+stcolors THEN GOTO a30
IF plist1(zz) <= plist1(zz - 1) THEN GOTO a30
zzz = zz - 1
c = clist1(zzz, 0): clist1(zzz, 0) = clist1(zz, 0): clist1(zz, 0) = c
c = clist1(zzz, 1): clist1(zzz, 1) = clist1(zz, 1): clist1(zz, 1) = c
c = clist1(zzz, 2): clist1(zzz, 2) = clist1(zz, 2): clist1(zz, 2) = c
cl = plist1(zzz): plist1(zzz) = plist1(zz): plist1(zz) = cl
zz = zzz
GOTO a40
a30:
colors(pn) = colors(pn) - 1
if z<po+colors(pn) then 
FOR zz = z TO po+(colors(pn) - 1)
clist1(zz, 0) = clist1(zz + 1, 0)
clist1(zz, 1) = clist1(zz + 1, 1)
clist1(zz, 2) = clist1(zz + 1, 2)
plist1(zz) = plist1(zz + 1)
NEXT zz
end if
IF colors(pn) = maxcolors2 THEN GOTO a50
a20:
NEXT z
a51:
diff = diff + minunit: GOTO a60
END IF
a50:     'done...

if pn>0 then
if colors(pn)<colors(pn-1) then
' if there is unused space in this palette, keep some old colors around
po=pa*pn
for x=po+colors(pn) to po+colors(pn-1)-1
clist1(x,0)=clist1(x-pa,0)
clist1(x,1)=clist1(x-pa,1)
clist1(x,2)=clist1(x-pa,2)
plist1(x)=0
next x
colors(pn)=colors(pn-1)
end if
end if

next pn


if stcolors>0 then goto a88


if comcolors>0 then
' choose static colors and prepare for 2nd pass palette optimization
c=0
for x=0 to maxcolors-1
for pn=0 to numpals-1
if x>colors(pn)-1 then goto a36
po=pn*pa
r=clist1(po+x,0)
g=clist1(po+x,1)
b=clist1(po+x,2)
if stcolors=0 then goto a37
for z=0 to stcolors-1
if r<>comlist(z,0) then goto a38
if g<>comlist(z,1) then goto a38
if b<>comlist(z,2) then goto a38
comlist(z,3)=comlist(z,3)+1
if comlist(z,3)=numpals then c=c+1:if c=comcolors then goto a39
a41:
if z=0 then goto a36
' keep comlist sorted by color frequency (among palettes)
if comlist(z,3) <= comlist(z-1,3) then goto a36
zz=z-1
r=comlist(zz,0):comlist(zz,0)=comlist(z,0):comlist(z,0)=r
r=comlist(zz,1):comlist(zz,1)=comlist(z,1):comlist(z,1)=r
r=comlist(zz,2):comlist(zz,2)=comlist(z,2):comlist(z,2)=r
r=comlist(zz,3):comlist(zz,3)=comlist(z,3):comlist(z,3)=r
z=z-1:goto a41
a38:
next z
a37:
' add color to comlist
if stcolors=256 then goto a39
comlist(stcolors,0)=r
comlist(stcolors,1)=g
comlist(stcolors,2)=b
comlist(stcolors,3)=1
stcolors=stcolors+1
a36:
next pn
next x
a39:
' OK now take comcolors from comlist and shove them in
' the front of each palette
for pn=0 to numpals-1
po=pn*pa
if colors(pn)+comcolors>pa then ? "uh oh. too many colors/palettes":end
for x=po+(colors(pn)-1)+comcolors to po+comcolors step -1
y=x-comcolors
clist1(x,0)=clist1(y,0)
clist1(x,1)=clist1(y,1)
clist1(x,2)=clist1(y,2)
plist1(x)=plist1(y)
next x
colors(pn)=colors(pn)+comcolors
for x=0 to comcolors-1
clist1(x+po,0)=comlist(x,0)
clist1(x+po,1)=comlist(x,1)
clist1(x+po,2)=comlist(x,2)
plist1(x+po)=1000000000
next x
next pn
stcolors=comcolors
goto a34
end if

a88:


' dump palette map
ff3=freefile
open "tpalmap.bin" for binary as #ff3
if lof(ff3)>0 then close #ff3:kill "tpalmap.bin":open "tpalmap.bin" for binary as #ff3
for x=0 to numpals4-1
a=palmap(x)
put #ff3,,a
next x
close #ff3

' dump palettes as text and binary

ff3=freefile
open "tpalette.txt" for binary as #ff3
if lof(ff3)>0 then close #ff3:kill "tpalette.txt":open "tpalette.txt" for binary as #ff3

ff2=freefile
open "tpalette.pal" for binary as #ff2
if lof(ff2)>0 then close #ff2:kill "tpalette.pal":open "tpalette.pal" for binary as #ff2

for pn=0 to numpals-1
po=pn*pa
x=po+(maxcolors-1)
if numpals=1 then x=colors(0)-1
whatevz=chr$(13)+chr$(10)+"palette "+str$(pn)+chr$(13)+chr$(10)
put #ff3,,whatevz
FOR z = po TO x
r3 = clist1(z, 0)
g3 = clist1(z, 1)
b3 = clist1(z, 2)
if minunit>63 then r3=((r3*9) shr 3):g3=((g3*9) shr 3):b3=((b3*9) shr 3)
whatevz=str$(r3)+","+str$(g3)+","+str$(b3)+chr$(13)+chr$(10)
PUT #ff3,,whatevz
put #ff2,,b3
put #ff2,,g3
put #ff2,,r3
NEXT z
next pn
whatevz="end"+chr$(13)+chr$(10)
put #ff3,,whatevz
close #ff3
close #ff2


PRINT "converting image..."

ff2=freefile

OPEN ofn FOR BINARY AS #ff2

' write BMP header
aa = "B": PUT #ff2, , aa
aa = "M": PUT #ff2, , aa
l = h * v + 1078: if outform=24 then l=linel*v+54
PUT #ff2, , l         ' file length
l = 0: PUT #ff2, , l                      ' reserved
l = 1078: if outform=24 then l=54
PUT #ff2, , l                   ' offset where bitmap starts in file
l = 40: PUT #ff2, , l                     ' subheader length
l = h: PUT #ff2, , l
l = v: PUT #ff2, , l
s = 1: PUT #ff2, , s                      ' "color planes" set to 1
s = 8: if outform=24 then s=24
PUT #ff2, , s                      ' bits per pixel
l = 0: PUT #ff2, , l                      ' compression method (none)
l = h * v: if outform=24 then l=v*linel
PUT #ff2, , l                ' size of naked bitmap
l = &HEC4: PUT #ff2, , l: PUT #ff2, , l     ' pixels per meter H/V
l = 0: PUT #ff2, , l                      ' colors in palette (0=determined by bitdepth)
l = 0: PUT #ff2, , l                      ' number of "important" colors

'write palette
if outform=8 then 
x=0

for pn=0 to numpals-1
po=pn*pa
FOR z = po TO po+(maxcolors-1)
r = clist1(z, 0)
g = clist1(z, 1)
b = clist1(z, 2)
if minunit>63 then r=((r*9) shr 3):g=((g*9) shr 3):b=((b*9) shr 3)
cl = b + (g shl 8) + (r shl 16)
PUT #ff2, , cl
x=x+1
NEXT z
next pn

if x<256 then
for y=x to 256
PUT #ff2, , cl
next y
end if

end if


ff3=freefile
open "tindex.bin" for binary as #ff3
if lof(ff3)>0 then close #ff3:kill "tindex.bin":open "tindex.bin" for binary as #ff3


yy = 1079
if outform=24 then yy=55

po=0:pn=0

FOR y = v - 1 TO 0 STEP -1
l=0:ll=0

if numpals>1 then vpo=(y\secheight)*hpals

FOR x = 0 TO h - 1

r=rawbm(x,y,0)
g=rawbm(x,y,1)
b=rawbm(x,y,2)

if numpals>1 then
pn=vpo+(x\secwidth)
pn=palmap(pn)
po=pn*pa
end if

zz=((y+x) and 1)
a46:
if r<0 then r=0
if g<0 then g=0
if b<0 then b=0
if r>255 then r=255
if g>255 then g=255
if b>255 then b=255
diff = 200000: c = 0
FOR z = po TO po+colors(pn)-1
rdiff = clist1(z, 0) - r
gdiff = clist1(z, 1) - g
bdiff = clist1(z, 2) - b
dif = rdiff * rdiff + gdiff * gdiff + bdiff * bdiff
IF dif = 0 THEN c = z: GOTO a135
IF dif < diff THEN diff = dif: c = z
NEXT z
a135:
r2=clist1(c,0):rerr(0)=r-r2
g2=clist1(c,1):rerr(1)=g-g2
b2=clist1(c,2):rerr(2)=b-b2

if dlevel=1 then
r+=(rerr(0) shr 1)
g+=(rerr(1) shr 1)
b+=(rerr(2) shr 1)
if zz=1 then zz=0:goto a46
end if

if dlevel=2 then
for z=0 to 2
if x<h-1 then
i=rawbm(x+1,y,z):i+=((7*rerr(z)) shr 4)
if i<0 then i=0
if i>255 then i=255
rawbm(x+1,y,z)=i
end if
if y>0 then
if x>0 then
i=rawbm(x-1,y-1,z):i+=((3*rerr(z)) shr 4)
if i<0 then i=0
if i>255 then i=255
rawbm(x-1,y-1,z)=i
end if
i=rawbm(x,y-1,z):i+=((5*rerr(z)) shr 4)
if i<0 then i=0
if i>255 then i=255
rawbm(x,y-1,z)=i
if x<h-1 then
i=rawbm(x+1,y-1,z):i+=(rerr(z) shr 4)
if i<0 then i=0
if i>255 then i=255
rawbm(x+1,y-1,z)=i
end if
end if
next z
end if

if minunit>63 then r2=((r2*9) shr 3):g2=((g2*9) shr 3):b2=((b2*9) shr 3)

lbuf(ll)=b2:ll=ll+1
lbuf(ll)=g2:ll=ll+1
lbuf(ll)=r2:ll=ll+1

ibuf(l)=c-po

if numpals>1 then c=(c-po)+(pn*maxcolors)

obuf(l)=c:l=l+1

NEXT x

if outform=8 then PUT #ff2, yy, obuf():yy=yy+h
if outform=24 then put #ff2,yy,lbuf():yy=yy+linel

xx=y*(h shl 1)+1
put #ff3,xx,ibuf()

NEXT y

CLOSE #ff2

