' compile with FreeBASIC win32
'
' see below for hints on setting up bitmasks for custom color depth
' (set bitmaskr2, bitmaskg2, bitmaskb2 to zero to disable dithering)
'
dim as integer l,cl,yy,zz,dif,diff,rdiff,gdiff,bdiff,maxcolors
dim as integer h,hh,v,ff1,ff2,colors,x,y,z,xx,c,oldcolors,zzz
dim as ushort s,r2,g2,b2,i2,r,g,b,i
dim as ubyte a,incr,incg,incb,inci,minunit
dim as ubyte bitmaskr1,bitmaskr2
dim as ubyte bitmaskg1,bitmaskg2
dim as ubyte bitmaskb1,bitmaskb2
dim as ubyte bitmaski1,bitmaski2
DIM clist1(0 TO 32767, 0 TO 2) as ubyte
DIM plist1(0 TO 32767) as integer
dim ifn as string
dim ofn as string
dim aa as string*1

PRINT
PRINT "DamageX BMP 24bit->8bit palettized color reducer tensai"
PRINT "V4.0"
PRINT
print "select color depth"
print
print "1) RGB 777       2,097,152       (VBXE)"
print "2) RGB 666       262,144         (VGA)"
print "3) RGB 565       65,536"
print "4) RGBi 5551     65,536          (X68000)"
print "5) RGB 555       32,768          (SNES)"
print "6) RGB 444       4,096           (Amiga OCS)"
print "7) RGBi 3331     1,024"
print "8) RGB 333       512             (PCE)"
print "9) RGB 332       256             (MSX)"
print "10) RGBi 2221    128"
print "11) RGB 222      64              (SMS)"
print "12) RGBi 1111    16              (EGA)"
print "13) RGB 111      8               (PC-88)"
print "14) custom"

a15:
? "option";:input x
bitmaski1=0:bitmaski2=0:bitmaskr1=1

if x=1 then
bitmaskr1=254:bitmaskg1=254:bitmaskb1=254
bitmaskr2=1:bitmaskg2=1:bitmaskb2=1
end if
if x=2 then
bitmaskr1=252:bitmaskg1=252:bitmaskb1=252
bitmaskr2=2:bitmaskg2=2:bitmaskb2=2
end if
if x=3 then
bitmaskr1=248:bitmaskg1=252:bitmaskb1=248
bitmaskr2=4:bitmaskg2=2:bitmaskb2=4
end if
if x=4 then
bitmaskr1=248:bitmaskg1=248:bitmaskb1=248
bitmaskr2=4:bitmaskg2=4:bitmaskb2=4
bitmaski1=7:bitmaski2=4
end if
if x=5 then
bitmaskr1=248:bitmaskg1=248:bitmaskb1=248
bitmaskr2=4:bitmaskg2=4:bitmaskb2=4
end if
if x=6 then
bitmaskr1=240:bitmaskg1=240:bitmaskb1=240
bitmaskr2=8:bitmaskg2=8:bitmaskb2=8
end if
if x=7 then
bitmaskr1=224:bitmaskg1=224:bitmaskb1=224
bitmaskr2=16:bitmaskg2=16:bitmaskb2=16
bitmaski1=31:bitmaski2=16
end if
if x=8 then
bitmaskr1=224:bitmaskg1=224:bitmaskb1=224
bitmaskr2=16:bitmaskg2=16:bitmaskb2=16
end if
if x=9 then
bitmaskr1=224:bitmaskg1=224:bitmaskb1=192
bitmaskr2=16:bitmaskg2=16:bitmaskb2=32
end if
if x=10 then
bitmaskr1=192:bitmaskg1=192:bitmaskb1=192
bitmaskr2=32:bitmaskg2=32:bitmaskb2=32
bitmaski1=63:bitmaski2=32
end if
if x=11 then
bitmaskr1=192:bitmaskg1=192:bitmaskb1=192
bitmaskr2=32:bitmaskg2=32:bitmaskb2=32
end if
if x=12 then
bitmaskr1=128:bitmaskg1=128:bitmaskb1=128
bitmaskr2=64:bitmaskg2=64:bitmaskb2=64
bitmaski1=127:bitmaski2=64
end if
if x=13 then
bitmaskr1=128:bitmaskg1=128:bitmaskb1=128
bitmaskr2=64:bitmaskg2=64:bitmaskb2=64
end if

if x=14 then 
PRINT "bitmask1 red"; : INPUT bitmaskr1
PRINT "bitmask1 green"; : INPUT bitmaskg1
PRINT "bitmask1 blue"; : INPUT bitmaskb1
PRINT "bitmask2 red"; : INPUT bitmaskr2
PRINT "bitmask2 green"; : INPUT bitmaskg2
PRINT "bitmask2 blue"; : INPUT bitmaskb2
PRINT "bitmask1 intensity"; : INPUT bitmaski1
PRINT "bitmask2 intensity"; : INPUT bitmaski2
end if

if bitmaskr1=1 then goto a15

incr = bitmaskr2
incg = bitmaskg2
incb = bitmaskb2

a17:
PRINT "palette size (2...256)"; : INPUT maxcolors
IF maxcolors < 2 THEN GOTO a17
IF maxcolors > 256 THEN GOTO a17

minunit = 1
a18:
IF (bitmaskr1 AND minunit) THEN GOTO a19
IF (bitmaskg1 AND minunit) THEN GOTO a19
IF (bitmaskb1 AND minunit) THEN GOTO a19
IF (bitmaski2 AND minunit) THEN GOTO a19
minunit = minunit + minunit: GOTO a18

a19:
PRINT "infile "; : INPUT ifn
PRINT "outfile "; : INPUT ofn

ff1=freefile
OPEN ifn FOR BINARY AS #ff1

GET #ff1, , s
IF s <> &H4D42 THEN PRINT "infile is not a 'BM'": END

l = 19
GET #ff1, l, h
l = 23
GET #ff1, l, v

PRINT "input file width = "; h; " height = "; v

FOR x = 0 TO 32767: plist1(x) = -1: NEXT x
colors = 0

hh = h * 3
yy = 55

dim shared lbuf(0 to hh-1) as ubyte
dim shared obuf(0 to h-1) as ubyte
dim shared rawbm(0 to h-1,0 to v-1,0 to 2) as ubyte

PRINT "analyzing image..."

FOR y = v - 1 TO 0 STEP -1
GET #ff1, yy, lbuf()
yy = yy + hh
xx=0

FOR x = 0 TO h - 1
b=lbuf(xx):xx=xx+1
g=lbuf(xx):xx=xx+1
r=lbuf(xx):xx=xx+1
IF ((y + x) AND 1) THEN
IF (r and bitmaskr2) THEN r = r + incr:if r>255 then r=255
IF (g and bitmaskg2) THEN g = g + incg:if g>255 then g=255
IF (b and bitmaskb2) THEN b = b + incb:if b>255 then b=255
END IF
i = ((r AND bitmaski1) + (g AND bitmaski1) + (b AND bitmaski1)) \ 3
i2 = (i AND bitmaski2)
r2 = (r AND bitmaskr1)+i2
g2 = (g AND bitmaskg1)+i2
b2 = (b AND bitmaskb1)+i2
rawbm(x,y,0)=r2
rawbm(x,y,1)=g2
rawbm(x,y,2)=b2

IF colors = 0 THEN GOTO a130

FOR z = 0 TO colors - 1
IF r2 <> clist1(z, 0) THEN GOTO a131
IF g2 <> clist1(z, 1) THEN GOTO a131
IF b2 <> clist1(z, 2) THEN GOTO a131
plist1(z) = plist1(z) + 1
'keep the list sorted as we go along
a133:
IF z = 0 THEN GOTO a132
IF plist1(z) <= plist1(z - 1) THEN GOTO a132
c = clist1(z - 1, 0): clist1(z - 1, 0) = clist1(z, 0): clist1(z, 0) = c
c = clist1(z - 1, 1): clist1(z - 1, 1) = clist1(z, 1): clist1(z, 1) = c
c = clist1(z - 1, 2): clist1(z - 1, 2) = clist1(z, 2): clist1(z, 2) = c
cl = plist1(z - 1): plist1(z - 1) = plist1(z): plist1(z) = cl
z = z - 1
GOTO a133
a131:
NEXT z

a130:       'add color to list
IF colors = 32768 THEN PRINT "too many colors, try lower depth": END
clist1(colors, 0) = r2
clist1(colors, 1) = g2
clist1(colors, 2) = b2
plist1(colors) = 1
colors = colors + 1

a132:
NEXT x
NEXT y

CLOSE #ff1

PRINT "unique colors: "; colors
oldcolors = colors - 1

PRINT "building optimal palette..."

IF colors > maxcolors THEN
diff = minunit + 1
a60:
FOR z = colors - 1 TO 1 STEP -1
r = clist1(z, 0)
g = clist1(z, 1)
b = clist1(z, 2)
FOR zz = 0 TO z - 1
rdiff = ABS(clist1(zz, 0) - r)
gdiff = ABS(clist1(zz, 1) - g)
bdiff = ABS(clist1(zz, 2) - b)
IF rdiff * rdiff + gdiff * gdiff + bdiff * bdiff < diff THEN GOTO a10
NEXT zz
GOTO a20
a10:
plist1(zz) = plist1(zz) + plist1(z)
a40:
IF zz = 0 THEN GOTO a30
IF plist1(zz) <= plist1(zz - 1) THEN GOTO a30
zzz = zz - 1
c = clist1(zzz, 0): clist1(zzz, 0) = clist1(zz, 0): clist1(zz, 0) = c
c = clist1(zzz, 1): clist1(zzz, 1) = clist1(zz, 1): clist1(zz, 1) = c
c = clist1(zzz, 2): clist1(zzz, 2) = clist1(zz, 2): clist1(zz, 2) = c
cl = plist1(zzz): plist1(zzz) = plist1(zz): plist1(zz) = cl
zz = zzz
GOTO a40
a30:
colors = colors - 1
FOR zz = z TO colors - 1
clist1(zz, 0) = clist1(zz + 1, 0)
clist1(zz, 1) = clist1(zz + 1, 1)
clist1(zz, 2) = clist1(zz + 1, 2)
plist1(zz) = plist1(zz + 1)
NEXT zz
IF colors = maxcolors THEN GOTO a50
a20:
NEXT z
diff = diff + minunit: GOTO a60
END IF
a50:     'done...

ff2=freefile

OPEN ofn FOR BINARY AS #ff2

' write BMP header
aa = "B": PUT #ff2, , aa
aa = "M": PUT #ff2, , aa
l = h * v + 1078: PUT #ff2, , l         ' file length
l = 0: PUT #ff2, , l                      ' reserved
l = 1078: PUT #ff2, , l                   ' offset where bitmap starts in file
l = 40: PUT #ff2, , l                     ' subheader length
l = h: PUT #ff2, , l
l = v: PUT #ff2, , l
s = 1: PUT #ff2, , s                      ' "color planes" set to 1
s = 8: PUT #ff2, , s                      ' bits per pixel
l = 0: PUT #ff2, , l                      ' compression method (none)
l = h * v: PUT #ff2, , l                ' size of naked bitmap
l = &HEC4: PUT #ff2, , l: PUT #ff2, , l     ' pixels per meter H/V
l = 0: PUT #ff2, , l                      ' colors in palette (0=determined by bitdepth)
l = 0: PUT #ff2, , l                      ' number of "important" colors

'write palette
FOR z = 0 TO 255
r = clist1(z, 0)
g = clist1(z, 1)
b = clist1(z, 2)
cl = b + (g shl 8) + (r shl 16)
PUT #ff2, , cl
NEXT z

PRINT "converting image..."

yy = 1079

FOR y = v - 1 TO 0 STEP -1
l=0

FOR x = 0 TO h - 1

r2=rawbm(x,y,0)
g2=rawbm(x,y,1)
b2=rawbm(x,y,2)

diff = 200000: c = 0
FOR z = 0 TO maxcolors - 1
rdiff = ABS(clist1(z, 0) - r2)
gdiff = ABS(clist1(z, 1) - g2)
bdiff = ABS(clist1(z, 2) - b2)
dif = rdiff * rdiff + gdiff * gdiff + bdiff * bdiff
IF dif = 0 THEN c = z: GOTO a135
IF dif < diff THEN diff = dif: c = z
NEXT z
a135:
obuf(l)=c
l=l+1

NEXT x

PUT #ff2, yy, obuf()
yy=yy+h

NEXT y

CLOSE #ff2

