#lang "fblite"
option gosub

' FBLITE version

' added "W" write wav with two loops
'
' updated dt2wave (wavout) and command line parsing
'

' DamageX tracker for Turbo Grafx music

' Turbo Grafx sound general info
' volume ranges from 0-31
' actual frequency = 3.58Mhz / ((period+1) * 32)
'
' music files are command based, here are the commands
'
' 0-29 = set a variable, the following byte is the value to write
'       variables are as follows:
'       0-4   main volume (ends attack, begins initial decay)
'       5-9   attack rate (value is divided by two and added to the actual
'                         volume every frame)
'       10-14 decay1 (value is divided by 64 and subtracted every frame)
'       15-19 decay2 (value is divided by 256 and subtracted every frame)
'       20-24 level volume (ends initial decay, begins secondary decay)
'       25-29 release rate (after key off, divided by 64 and subtracted)
' 32+x  stops reading music data until the next frame
'       x ranges from 0-31 and specifies additional frames to wait
' 64+x  key on / key off
'       bit 0 specifies the event (0=key off 1=key on)
'       bits 1-3 contain the number of the sound channel (0-4)
' 96+x  vibrato on/off
'       bits 0-2 contain the number of the sound channel (0-4)
'       bit 4 specifies vibrato on or off (set=on clear=off)
' 128+x sets the period of a sound channel
'       bits 0-2 contain the 3 highest bits of the period
'       bits 3-5 contain the number of the sound channel (0-4)
'       the following byte contains the 8 low bits of the period
' 192+x sets panning
'       bits 0-2 contain the number of the sound channel (0-4)
'       the following byte contains volume for left channel (bits 4-7)
'       and the volume for right channel (bits 0-3)
'       (note that generating a .WAV from the tracker uses only the top
'       three bits of each nibble while the PCE obviously uses all of them)
' 253   set loop point (marks the beginning of the loop)
' 254   loop (jumps to the beginning of the loop)
' 255 = jump, the following three bytes specify the bank, low byte, high byte
'       (but these won't be used here since you don't know the starting
'       address of the data in ROM! Some routines here expect not to see this)
'

dim as single freq,freq2,freq3
dim as short sx
dim as integer fcount,fcountold,steele,countdown,csold,eline
dim as integer cl,redundait,ff1,ff2,ff3,ff4,ff5,o,loopadr
dim as integer x,y,z,dt2wave,wboffset,frames,sframe,zl,zr,w
dim as integer commandscroll,notescroll,length,pline,fpl,noffset,nlines
dim dtfile as string
dim lgaim as string
DIM thefile(0 TO 32000) AS ubyte
DIM regs(0 TO 34) AS integer
DIM keys(0 TO 4) AS integer
DIM volume(0 TO 4) AS integer
DIM pcount(0 TO 4) AS integer
DIM pl(0 TO 4) AS integer
DIM hexs(0 TO 15) AS STRING * 1
DIM iassign(0 TO 4) AS integer
DIM instruments(0 TO 7, 0 TO 31) AS integer
DIM pinstl(0 TO 4, 0 TO 31) AS integer
DIM pinstr(0 TO 4, 0 TO 31) AS integer
DIM vibrato(0 TO 4) AS integer
DIM panning(0 TO 4) AS integer
DIM byt AS STRING * 1
DIM dword AS LONG
DIM copybuf(0 TO 1023) AS integer
DIM wavbuff(0 to 1469) as short
FOR x = 0 TO 9: hexs(x) = CHR$(x + 48): NEXT x
FOR x = 10 TO 15: hexs(x) = CHR$(x + 55): NEXT x
DIM viblow(0 TO 10) AS integer
DIM vibhigh(0 TO 10) AS integer
DIM t1table(0 TO 31) AS integer
DIM logtable(0 TO 31) AS SINGLE
dim sy as single
dim k as string
dim quickname as string

CLS
COLOR 0, 7
PRINT "Damage Tracker               Version 3.03                     PRESS F1 FOR HELP"
PRINT
PRINT
PRINT
PRINT
PRINT "Commands                 ";
COLOR 7, 0
PRINT "  ";
COLOR 0, 7
PRINT "Notes                                               "
COLOR 7, 0


t1table(31) = 0
t1table(30) = 1
t1table(29) = 1
t1table(28) = 1
t1table(27) = 1
t1table(26) = 2
t1table(25) = 2
t1table(24) = 2
t1table(23) = 2
t1table(22) = 3
t1table(21) = 3
t1table(20) = 3
t1table(19) = 4
t1table(18) = 4
t1table(17) = 4
t1table(16) = 5
t1table(15) = 5
t1table(14) = 6
t1table(13) = 6
t1table(12) = 7
t1table(11) = 7
t1table(10) = 8
t1table(9) = 8
t1table(8) = 9
t1table(7) = 10
t1table(6) = 11
t1table(5) = 12
t1table(4) = 14
t1table(3) = 15
t1table(2) = 17
t1table(1) = 20
t1table(0) = 31
          

viblow(0) = 0: vibhigh(0) = 0
viblow(1) = 1: vibhigh(1) = 0
viblow(2) = 2: vibhigh(2) = 1
viblow(3) = 2: vibhigh(3) = 1
viblow(4) = 1: vibhigh(4) = 1
viblow(5) = 0: vibhigh(5) = 0
viblow(6) = -1: vibhigh(6) = 0
viblow(7) = -2: vibhigh(7) = -1
viblow(8) = -2: vibhigh(8) = -1
 viblow(9) = -1: vibhigh(9) = -1
viblow(10) = 0: vibhigh(10) = 0

sy = 1
FOR x = 31 TO 0 STEP -1
logtable(x) = sy
sy = sy * 1.15
NEXT x

FOR x = 0 TO 7
FOR y = 31 TO 0 STEP -1
READ z
instruments(x, y) = z - 16
NEXT y
NEXT x

a632: commandscroll = 0
notescroll = 0
length = 1
thefile(0) = 32
pline = 0
fpl = 1
noffset = 0
nlines = 0


gosub a1000
gosub a2200
LOCATE 7, 26, 0
PRINT "<-"

if command(1)="" then goto a10

if command(1)="wavout" then
quickname=command(2)
dt2wave=1
else
quickname=command(1)
end if

k=quickname+".dt3"
goto a6968

'****************************** tHe JuNk ********************************
a10: IF ms > 0 THEN ms = ms - 1: goto a19

DO
k = INKEY$
if k <> "" then goto a91
sleep 50
LOOP
a91:

IF k = chr$(255) + CHR$(73) THEN ms = 10: k = chr$(255) + CHR$(72)
IF k = chr$(255) + CHR$(81) THEN ms = 10: k = chr$(255) + CHR$(80)

IF k = "q" THEN
gosub a2000
LOCATE 2, 1: PRINT "Quit (y/n)"; : INPUT k
IF k = "y" THEN END
goto a10
END IF

IF k = "l" THEN
gosub a2000
LOCATE 2, 1: PRINT "Load what file (ENTER to cancel)"; : INPUT k
a6968: IF k = "" THEN goto a10
ff1=freefile
OPEN k FOR BINARY AS #ff1
commandscroll = 0
length = lof(ff1)
IF length > 4 THEN length = length - 5
PRINT "Length: "; length
FOR x = 0 TO 4
get #ff1, , byt
iassign(x) = ASC(byt)
NEXT x
FOR x = 0 TO 32000
get #ff1, , byt
thefile(x) = ASC(byt)
NEXT x
close #ff1

IF dt2wave = 1 THEN
seconds = 0
frames = 0
gosub a2000
LOCATE 2, 1, 0
PRINT "Writing .WAV file"
k = quickname + ".wav"
ff1=freefile
OPEN k FOR BINARY AS #ff1
goto a6969
END IF

gosub a1000
gosub a2200
goto a10
END IF

a19: IF k = chr$(255) + CHR$(72) THEN
fcount = 0
IF commandscroll = 0 THEN goto a57
'scroll up
cl = 0
x = 0
DO
cl = cl + x
z = thefile(cl)
gosub a2100
LOOP UNTIL cl + x = commandscroll
commandscroll = cl
fcount = fcountold
gosub a1000
a57: gosub a2000
LOCATE 2, 1, 0
PRINT "Displaying commands starting in Frame "; fcount
goto a10
END IF

IF k = chr$(255) + CHR$(80) THEN
'scroll down
fcount = 0
cl = 0
x = 0
DO
cl = cl + x
z = thefile(cl)
gosub a2100
LOOP UNTIL cl = commandscroll
IF commandscroll + x < length THEN
commandscroll = commandscroll + x
gosub a2000
LOCATE 2, 1, 0
PRINT "Displaying commands starting in Frame "; fcount
END IF
gosub a1000
goto a10
END IF

IF k = chr$(255) + CHR$(59) THEN
gosub a2000: LOCATE 2, 1, 0
PRINT "Q quit          <- pointer up   PGUP com. up 10 N notes mode    S save as      "
PRINT "L load          -> pointer down PGDN com.down10 P append comand W write .WAV   "
PRINT "A notes up       commands up   F increase fpl  I insert comand T set patterns "
PRINT "Z notes down     commands down V decrease fpl  D delete com.     F2 FOR MORE  "
goto a10
END IF

IF k = chr$(255) + CHR$(60) THEN
gosub a2000: LOCATE 2, 1, 0
PRINT "E extend by 1s      M modify channel (for register     J join channels from"
PRINT "C copy commands     X modify value   setting commands)   another file"
PRINT "SPC paste commands  ^ combine waits                    B break into 5 files "
PRINT "O obliterate        R rip out channels/sections          (one per channel)"
goto a10
END IF

IF k = "x" THEN
commandscrol = commandscroll
IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscrol)
gosub a2100
commandscrol = commandscrol + x
IF commandscrol > length - 1 THEN goto a10
NEXT w
END IF
z = thefile(commandscrol)
IF z < 32 THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "Current value: "; thefile(commandscrol + 1)
PRINT "New value "; : INPUT z
IF z < 0 THEN goto a10
IF z > 255 THEN goto a10
thefile(commandscrol + 1) = z
gosub a1000
gosub a2200
goto a10
END IF
goto a10
END IF

IF k = "m" THEN
commandscrol = commandscroll
IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscrol)
gosub a2100
commandscrol = commandscrol + x
IF commandscrol > length - 1 THEN goto a10
NEXT w
END IF
z = thefile(commandscrol)
IF z < 32 THEN
w = z - (INT(z / 5) * 5) + 1
IF w = 5 THEN w = 0
thefile(commandscrol) = (INT(z / 5) * 5) + w
gosub a1000
gosub a2200
goto a10
END IF
goto a10
END IF

IF k = "o" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "Forget all song data (y/n) "; : INPUT k
IF k = "y" THEN goto a632
goto a10
END IF

IF k = "c" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "How many"; : INPUT steele
IF steele < 1 THEN goto a10
IF steele > 512 THEN PRINT "too many!": goto a10
csold = commandscroll
IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscroll)
gosub a2100
commandscroll = commandscroll + x
IF commandscroll > length - 1 THEN commandscroll = csold: goto a10
NEXT w
END IF
w = 1
FOR y = 1 TO steele
z = thefile(commandscroll)
gosub a2100
copybuf(w) = z: w = w + 1: commandscroll = commandscroll + 1
IF x = 2 THEN copybuf(w) = thefile(commandscroll): w = w + 1: commandscroll = commandscroll + 1
IF commandscroll >= length THEN goto a817
NEXT y
a817: copybuf(0) = w
copybuf(w) = 255
commandscroll = csold
PRINT "Copied."
END IF

IF k = "r" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "Remove which channel (0-4,5=all)"; : INPUT steele
IF steele < 0 THEN PRINT "nan da to!?": goto a10
IF steele > 5 THEN PRINT "try again foo!": goto a10
PRINT "Starting frame number"; : INPUT frames
IF frames < 0 THEN PRINT "*ice explosion*": goto a10
gosub a4005
IF cl >= length THEN PRINT "there aren't that many frames": goto a10
fcount = frames
PRINT "Ending frame number"; : INPUT frames
IF fcount > frames THEN PRINT "don't be silly": goto a10

DO
IF cl >= length THEN goto a757
z = thefile(cl)
gosub a2100
IF (z AND 224) = 32 THEN cl = cl + x: goto a756

IF steele = 5 THEN goto a755

IF z < 32 THEN
IF (z MOD 5) = steele THEN goto a755
cl = cl + x: goto a756
END IF

IF z < 96 THEN
IF (z AND 14) \ 2 = steele THEN goto a755
cl = cl + x: goto a756
END IF

IF z < 128 THEN
IF (z AND 7) = steele THEN goto a755
cl = cl + x: goto a756
END IF

IF z < 192 THEN
IF (z AND 56) \ 8 = steele THEN goto a755
cl = cl + x: goto a756
END IF

if z < 253 then
IF (z AND 7) = steele THEN goto a755
end if

cl = cl + x: goto a756

a755: FOR w = cl TO length - x
thefile(w) = thefile(w + x)
NEXT w
length = length - x

a756: LOOP UNTIL fcount >= frames
a757: 'reposition command window if it is looking at an area that is outside
' the bounds of the file now
PRINT "Removed."
gosub a1000
gosub a2200
END IF


IF k = "j" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "Input file (ENTER to cancel)"; : INPUT dtfile
IF dtfile = "" THEN goto a10
ff4=freefile
OPEN dtfile FOR BINARY AS #ff4
FOR x = 1 TO 5
get #ff4, , byt
IF eof(ff4) THEN PRINT "how about a different file?": close #ff4: goto a10
NEXT x
PRINT "Load which channel (0-4,5=all)"; : INPUT steele
IF steele < 0 THEN PRINT "inconcievable!": close #ff4: goto a10
IF steele > 5 THEN PRINT "bakanatoiunoka": close #ff4: goto a10
PRINT "Destination starting frame number"; : INPUT frames
IF frames < 0 THEN PRINT "ALL YOUR FRAMES ARE BELONG TO US": close #ff4: goto a10
gosub a4005
IF cl >= length THEN PRINT "there aren't that many frames": close #ff4: goto a10

sframe = frames
dtcount = 0

a759: get #ff4, , byt
IF eof(ff4) THEN goto a758
z = ASC(byt)

IF (z AND 224) = 32 THEN
dtcount = dtcount + z - 31
a763: frames = sframe + dtcount
gosub a4005
IF cl >= length THEN thefile(length) = 60: length = length + 1: goto a763
goto a759
END IF

IF z < 32 THEN
x = 2
IF steele = 5 THEN goto a760
IF (z MOD 5) = steele THEN goto a760
get #ff4, , byt
goto a759
END IF

IF z < 96 THEN
x = 1
IF steele = 5 THEN goto a760
IF (z AND 14) / 2 = steele THEN goto a760
goto a759
END IF

IF z < 128 THEN
x = 1
IF steele = 5 THEN goto a760
IF (z AND 7) = steele THEN goto a760
goto a759
END IF

IF z < 192 THEN
x = 2
IF steele = 5 THEN goto a760
IF ((z AND 56) shr 3) = steele THEN goto a760
get #ff4, , byt
goto a759
END IF

if z < 224 then
x = 2
IF steele = 5 THEN goto a760
IF (z AND 7) = steele THEN goto a760
get #ff4, , byt
end if

goto a759

a760: FOR w = length TO cl STEP -1
thefile(w + x) = thefile(w)
NEXT w
length = length + x
thefile(cl) = z: cl = cl + 1
a761: IF x > 1 THEN get #ff4, , byt: thefile(cl) = ASC(byt): cl = cl + 1: x = x - 1: goto a761

goto a759

a758: close #ff4
PRINT "Loaded."
gosub a1000
gosub a2200
END IF


IF k = "b" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "files CHANNEL0.DT3, CHANNEL1.DT3, CHANNEL2.DT3, CHANNEL3.DT3, CHANNEL4.DT3"
PRINT "will be created OK (y/n)"; : INPUT k
IF k <> "y" THEN goto a10
ff1=freefile
OPEN "channel0.dt3" FOR BINARY AS #ff1
IF lof(ff1) > 1 THEN close #ff1: KILL "channel0.dt3": OPEN "channel0.dt3" FOR BINARY AS #ff1
ff2=freefile
OPEN "channel1.dt3" FOR BINARY AS #ff2
IF lof(ff2) > 1 THEN close #ff2: KILL "channel1.dt3": OPEN "channel1.dt3" FOR BINARY AS #ff2
ff3=freefile
OPEN "channel2.dt3" FOR BINARY AS #ff3
IF lof(ff3) > 1 THEN close #ff3: KILL "channel2.dt3": OPEN "channel2.dt3" FOR BINARY AS #ff3
ff4=freefile
OPEN "channel3.dt3" FOR BINARY AS #ff4
IF lof(ff4) > 1 THEN close #ff4: KILL "channel3.dt3": OPEN "channel3.dt3" FOR BINARY AS #ff4
ff5=freefile
OPEN "channel4.dt3" FOR BINARY AS #ff5
IF lof(ff5) > 1 THEN close #ff5: KILL "channel4.dt3": OPEN "channel4.dt3" FOR BINARY AS #ff5
FOR x = 0 TO 4
byt = CHR$(iassign(x))
put #ff1, , byt
put #ff2, , byt
put #ff3, , byt
put #ff4, , byt
put #ff5, , byt
NEXT x
FOR w = 0 TO length - 1
z = thefile(w)
IF z < 32 THEN x = 2: steele = (z MOD 5): goto a767
IF z < 64 THEN goto a769
IF z < 96 THEN x = 1: steele = ((z AND 14) shr 1): goto a767
IF z < 128 THEN x = 1: steele = (z AND 7): goto a767
IF z < 192 THEN x = 2: steele = ((z and 56) shr 3): goto a767
if z < 253 then x = 2: steele = (z AND 7): goto a767

a769:
byt = CHR$(z)
put #ff1, , byt
put #ff2, , byt
put #ff3, , byt
put #ff4, , byt
put #ff5, , byt
goto a768

a767: w = w + (x - 1)
byt = CHR$(z)
IF steele = 0 THEN put #ff1, , byt: IF x = 2 THEN byt = CHR$(thefile(w)): put #ff1, , byt
IF steele = 1 THEN put #ff2, , byt: IF x = 2 THEN byt = CHR$(thefile(w)): put #ff2, , byt
IF steele = 2 THEN put #ff3, , byt: IF x = 2 THEN byt = CHR$(thefile(w)): put #ff3, , byt
IF steele = 3 THEN put #ff4, , byt: IF x = 2 THEN byt = CHR$(thefile(w)): put #ff4, , byt
IF steele = 4 THEN put #ff5, , byt: IF x = 2 THEN byt = CHR$(thefile(w)): put #ff5, , byt
a768: NEXT w
close #ff1
close #ff2
close #ff3
close #ff4
close #ff5
PRINT "Saved."
goto a10
END IF


IF k = " " THEN
gosub a2000
LOCATE 2, 1, 0
csold = commandscroll
IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscroll)
gosub a2100
commandscroll = commandscroll + x
IF commandscroll > length - 1 THEN commandscroll = csold: goto a10
NEXT w
END IF
y = copybuf(0) - 1
IF y < 1 THEN commandscroll = csold: PRINT "Nothing to paste": goto a10
length = length + y
FOR w = length - 1 TO commandscroll + y STEP -1
thefile(w) = thefile(w - y)
NEXT w
x = 1
DO
thefile(commandscroll) = copybuf(x)
commandscroll = commandscroll + 1: x = x + 1
LOOP UNTIL x = copybuf(0)
commandscroll = csold
gosub a1000
gosub a2200
END IF

IF k = "e" THEN
thefile(length) = 61
thefile(length + 1) = 61
length = length + 2
gosub a1000
gosub a2200
goto a10
END IF

IF k = "t" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "Current wave pattern assignments "; iassign(0); iassign(1); iassign(2); iassign(3); iassign(4)
FOR w = 0 TO 4
LOCATE 3, 1, 0
PRINT "New pattern for channel "; w; " "; : INPUT y
IF ((y < 0) OR (y > 7)) THEN goto a10
iassign(w) = y
NEXT w
goto a10
END IF

IF k = "n" THEN goto a4000

IF k = "w" THEN
loopadr=-1
gosub writewav
goto a10
END IF

IF k = "W" THEN
loopadr=0
gosub writewav
goto a10
END IF

IF k = "s" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "Save as"; : INPUT k
ff1=freefile
OPEN k FOR BINARY AS #ff1
IF lof(ff1) > 1 THEN close #ff1: KILL k: OPEN k FOR BINARY AS #ff1
FOR x = 0 TO 4
byt = CHR$(iassign(x))
put #ff1, , byt
NEXT x
FOR x = 0 TO length - 1
byt = CHR$(thefile(x))
put #ff1, , byt
NEXT x
close #ff1
PRINT "Saved."
goto a10
END IF

IF k = "p" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "Append command"
gosub a2300
thefile(length) = y
thefile(length + 1) = z
length = length + x
gosub a1000
gosub a2200
goto a10
END IF

IF k = "^" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "Combining wait commands to compact file..."
commandscroll = 0
DO

redundaits = 0
z = thefile(commandscroll)
IF ((z < 32) OR (z > 63)) THEN goto a13
thewait = (z AND 31) + 1
DO
redundaits = redundaits + 1
IF commandscroll + redundaits > length - 1 THEN goto a14
z = thefile(commandscroll + redundaits)
IF ((z < 32) OR (z > 63)) THEN goto a14
thenewwait = thewait + (z AND 31) + 1
IF thenewwait > 32 THEN goto a14
thewait = thenewwait
LOOP
a14: IF redundaits < 2 THEN goto a13
redundaits = redundaits - 1
' WORK IN PROGRESS!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
thefile(commandscroll) = 31 + thewait
FOR w = commandscroll + 1 TO length - redundaits
thefile(w) = thefile(w + redundaits)
NEXT w
length = length - redundaits
x = 1: goto a15
a13: gosub a2100
a15: commandscroll = commandscroll + x
LOOP UNTIL commandscroll > length - 1
a12: PRINT "Done."
commandscroll = 0
gosub a1000
gosub a2200
END IF

IF k = "d" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "Delete command (y/n/b)"; : INPUT k
genocide = 1
IF k = "b" THEN k = "y": PRINT "How many"; : INPUT genocide: IF genocide = 0 THEN goto a10
IF k <> "y" THEN goto a10

FOR y = 1 TO genocide
csold = commandscroll

IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscroll)
gosub a2100
commandscroll = commandscroll + x
IF commandscroll > length - 1 THEN commandscroll = csold: goto a11
NEXT w
END IF

z = thefile(commandscroll)
gosub a2100
FOR w = commandscroll TO length - x
thefile(w) = thefile(w + x)
NEXT w
length = length - x
commandscroll = csold
NEXT y
a11: PRINT "Deleted."
gosub a1000
gosub a2200
END IF

IF k = "i" THEN
gosub a2000
LOCATE 2, 1, 0
PRINT "Insert command"
gosub a2300

keys(0) = x
keys(1) = y
keys(2) = z

csold = commandscroll

IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscroll)
gosub a2100
commandscroll = commandscroll + x
IF commandscroll > length - 1 THEN commandscroll = csold: goto a10
NEXT w
END IF

length = length + keys(0)

FOR w = length - 1 TO commandscroll + keys(0) STEP -1
thefile(w) = thefile(w - keys(0))
NEXT w

thefile(commandscroll) = keys(1)
IF keys(0) = 2 THEN thefile(commandscroll + 1) = keys(2)
commandscroll = csold
gosub a1000
gosub a2200
goto a10
END IF

IF k = "a" THEN
nlines = nlines - 1
IF nlines < 0 THEN nlines = 0
gosub a2200
goto a10
END IF
IF k = "z" THEN
nlines = nlines + 1
gosub a2200
goto a10
END IF
IF k = "A" THEN
nlines = nlines - 8
IF nlines < 0 THEN nlines = 0
gosub a2200
goto a10
END IF
IF k = "Z" THEN
nlines = nlines + 8
gosub a2200
goto a10
END IF

IF k = "f" THEN
fpl = fpl + 1
gosub a2200
goto a10
END IF

IF k = "v" THEN
fpl = fpl - 1
IF fpl < 1 THEN fpl = 1
gosub a2200
goto a10
END IF

IF k = chr$(255) + CHR$(75) THEN pline = pline - 1: IF pline < 0 THEN pline = 0
IF k = chr$(255) + CHR$(77) THEN pline = pline + 1: IF pline > 15 THEN pline = 15

FOR x = 7 TO 23: LOCATE x, 26, 0: PRINT "  ": NEXT x
LOCATE pline + 7, 26, 0
PRINT "<-"

goto a10

a1000: 'commands window

LOCATE 7, 1
FOR x = 7 TO 23
PRINT "                         "
NEXT x

x = commandscroll
y = 7
LOCATE 7, 1

DO
PRINT hexs(INT((x AND 32767) / 4096));
PRINT hexs(INT((x AND 4095) / 256));
PRINT hexs(INT((x AND 255) / 16));
PRINT hexs(INT((x AND 15))); " ";

z = thefile(x)
x = x + 1

IF z < 32 THEN
channel = (z MOD 5)
reg = INT(z / 5)
z = thefile(x)
x = x + 1
IF reg = 0 THEN PRINT "Set volume "; channel; ","; z
IF reg = 1 THEN PRINT "Set attack "; channel; ","; z
IF reg = 2 THEN PRINT "Set decay1 "; channel; ","; z
IF reg = 3 THEN PRINT "Set decay2 "; channel; ","; z
IF reg = 4 THEN PRINT "Set level  "; channel; ","; z
IF reg = 5 THEN PRINT "Set release"; channel; ","; z
goto a20
END IF

IF z < 64 THEN
PRINT "Wait "; (z AND 31) + 1
goto a20
END IF

IF z < 96 THEN
channel = (z AND 14) / 2
IF (z AND 1) = 0 THEN PRINT "Key off "; channel
IF (z AND 1) = 1 THEN PRINT "Key on "; channel
goto a20
END IF

IF z < 128 THEN
channel = (z AND 7)
IF (z AND 16) = 0 THEN PRINT "Vibrato off "; channel
IF (z AND 16) = 16 THEN PRINT "Vibrato on "; channel
goto a20
END IF

IF z < 192 THEN
channel = ((z AND 56) shr 3)
period = ((z AND 7) shl 8)
z = thefile(x)
x = x + 1
period = period + z
PRINT "Set period"; channel; ","; period
goto a20
END IF

IF z < 253 THEN
channel = (z AND 7)
z = thefile(x)
x = x + 1
PRINT "Set panning"; channel; ","; z
goto a20
END IF

IF z = 253 THEN
PRINT "Begin loop"
goto a20
END IF

IF z = 254 THEN
PRINT "End loop"
goto a20
END IF

IF z = 255 THEN
x = x + 3
PRINT "Jump "; thefile(x - 3); thefile(x - 2); thefile(x - 1)
goto a20
END IF

PRINT "                    "

a20: y = y + 1
LOOP UNTIL ((y = 23) OR (x >= length))
RETURN

a2000: 'clear upper window
LOCATE 2, 1
PRINT SPACE$(79)
PRINT SPACE$(79)
PRINT SPACE$(79)
PRINT SPACE$(79)

RETURN

a2100: 'parse file 1 command
fcountold = fcount
x = 1
IF z < 32 THEN x = x + 1:goto a21

IF z < 64 THEN
fcount = fcount + 1 + (z AND 31)
goto a21
END IF

IF z < 128 THEN goto a21

IF z < 224 THEN x = x + 1:goto a21

'if z = 253 then goto a21
'if z = 254 then goto a21

IF z = 255 THEN
x = x + 3
goto a21
END IF

a21: RETURN

a2200: 'notes window
FOR x = 7 TO 23
LOCATE x, 28, 0
PRINT "                                                     "
NEXT x
PRINT "Frames/line = "; fpl; " Starting at line "; nlines; " Time "; INT(fpl * nlines / 60); "         ";

y = 7
x = 0
countdown = 0
cline = 0
fplcount = fpl
FOR w = 0 TO 4: keys(w) = 0: NEXT w

DO
IF countdown > 0 THEN
countdown = countdown - 1

fplcount = fplcount - 1
IF fplcount > 0 THEN goto a23

fplcount = fpl
cline = cline + 1

IF cline > nlines THEN
FOR w = 0 TO 4
LOCATE y, w * 10 + 28, 0
IF keys(w) = 1 THEN PRINT "Key on"
IF keys(w) = -1 THEN PRINT "Key off"
IF keys(w) = 0 THEN PRINT "   -"
NEXT w
y = y + 1
END IF

FOR w = 0 TO 4: keys(w) = 0: NEXT w
goto a23
END IF

z = thefile(x)

IF z < 32 THEN x = x + 2: goto a23
IF z < 64 THEN x = x + 1: countdown = (z AND 31) + 1: goto a23

IF z < 96 THEN
x = x + 1
channel = ((z AND 14) shr 1)
IF (z AND 1) = 0 THEN keys(channel) = -1
IF (z AND 1) = 1 THEN keys(channel) = 1
goto a23
END IF

IF z < 128 THEN x = x + 1: goto a23
IF z < 253 THEN x = x + 2: goto a23
if z = 253 then x=x+1:goto a23
if z = 254 then x=x+1:goto a23
IF z = 255 THEN goto a22

goto a575

a23: IF x > length THEN goto a22

LOOP UNTIL y = 24

a22: IF y = 7 THEN nlines = nlines - 8: IF nlines < 0 THEN nlines = 0

RETURN

a2300: 'ask for a command

PRINT "1) set a register  2) wait  3) key on  4) key off  5) vibrato on"
PRINT "6) vibrato off  7) set period  8) set panning  ENTER to cancel :";
INPUT k

IF k = "1" THEN
x = 2
gosub a2000
LOCATE 2, 1, 0
PRINT "0-4 main volume  5-9 attack rate  10-14 decay 1"
PRINT "15-19 decay 2    20-24 level vol. 25-29 release"
PRINT "which register"; : INPUT y
IF ((y < 0) OR (y > 29)) THEN return a10
PRINT "value"; : INPUT z
RETURN
END IF

IF k = "2" THEN
x = 1
PRINT "how many frames (1-32)"; : INPUT y
IF ((y < 1) OR (y > 32)) THEN return a10
y = y + 31
RETURN
END IF

IF k = "3" THEN
x = 1
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN return a10
y = y * 2 + 65
RETURN
END IF

IF k = "4" THEN
x = 1
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN return a10
y = y * 2 + 64
RETURN
END IF

IF k = "5" THEN
x = 1
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN return a10
y = y + 112
RETURN
END IF

IF k = "6" THEN
x = 1
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN return a10
y = y + 96
RETURN
END IF

IF k = "7" THEN
x = 2
gosub a2000
LOCATE 2, 1, 0
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN return a10
PRINT "period value"; : INPUT z
IF ((z < 0) OR (z > 2047)) THEN return a10
y = y * 8 + 128 + (z shr 8)
z = (z AND 255)
RETURN
END IF

IF k = "8" THEN
x = 2
gosub a2000
LOCATE 2, 1, 0
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN return a10
PRINT "panning value"; : INPUT z
IF ((z < 0) OR (z > 255)) THEN return a10
y = y + 192
RETURN
END IF

return a10

a4000: 'notes editor
echannel = 0
eline = 0
gosub a2000
LOCATE 2, 1, 0: PRINT "Notes mode, press n to return to normal mode"

gosub a4001

a4010:

DO
k = INKEY$
if k <> "" then goto a92
sleep 50
LOOP
a92:


IF k = "w" THEN
gosub writewav
goto a4010
END IF

IF k = "n" THEN
gosub a2000
LOCATE 2, 1, 0: PRINT "Normal mode"
goto a10
END IF

IF k = chr$(255) + CHR$(59) THEN
gosub a2000: LOCATE 2, 1, 0
PRINT "N normal mode   <- cursor left  K key on"
PRINT "Q quit          -> cursor right O key off"
PRINT "A notes up       cursor up     C clear (keys)"
PRINT "Z notes down     cursor down   P set pitch"
goto a4010
END IF

IF k = "p" THEN
' set pitch
gosub a2000
LOCATE 2, 1, 0
PRINT "New pitch eg. f440 or p253 or 2a (2a+ for A#)"
PRINT "or ENTER to cancel"
INPUT lgaim
IF lgaim = "" THEN goto a4010
lgaim = lgaim + "  "
IF MID$(lgaim, 1, 1) = "f" THEN period = INT(111861 / VAL(MID$(lgaim, 2))) - 1
IF MID$(lgaim, 1, 1) = "p" THEN period = VAL(MID$(lgaim, 2))

IF ((ASC(MID$(lgaim, 1, 1)) > 48) AND (ASC(MID$(lgaim, 1, 1)) < 58)) THEN
octave = ASC(MID$(lgaim, 1, 1)) - 48
halfstep = 66
IF MID$(lgaim, 2, 1) = "c" THEN halfstep = 0
IF MID$(lgaim, 2, 1) = "d" THEN halfstep = 2
IF MID$(lgaim, 2, 1) = "e" THEN halfstep = 4
IF MID$(lgaim, 2, 1) = "f" THEN halfstep = 5
IF MID$(lgaim, 2, 1) = "g" THEN halfstep = 7
IF MID$(lgaim, 2, 1) = "a" THEN halfstep = 9
IF MID$(lgaim, 2, 1) = "b" THEN halfstep = 11
IF halfstep = 66 THEN goto a4010
IF MID$(lgaim, 3, 1) = "+" THEN halfstep = halfstep + 1
freq = 8363 * 2 ^ (octave + 2 - (120 - halfstep) / 12)
IF freq < 55 THEN PRINT "Outside PCE frequency range": goto a4010
period = INT(111861 / freq) - 1
END IF

gosub a4004
' add command for setting period
length = length + 2
FOR w = length TO cl + 2 STEP -1
thefile(w) = thefile(w - 2)
NEXT w
thefile(cl) = echannel * 8 + 128 + (period shr 8)
thefile(cl + 1) = (period AND 255)
cl = cl + 2
' search for and remove other commands for setting period
DO
z = thefile(cl)

IF z < 32 THEN cl = cl + 2: goto a4014
IF z < 64 THEN cl = length: goto a4014
IF z < 96 THEN cl = cl + 1: goto a4014
IF z < 128 THEN cl = cl + 1: goto a4014
IF z < 192 THEN
IF ((z AND 56) shr 3) <> echannel THEN cl = cl + 2: goto a4014
FOR w = cl TO length - 2
thefile(w) = thefile(w + 2)
NEXT w
length = length - 2: goto a4014
END IF
IF z < 253 THEN cl = cl + 2: goto a4014

cl=cl+1

a4014: LOOP UNTIL cl >= length

gosub a1000
END IF

IF k = "k" THEN
' key ON
gosub a4004
length = length + 1
FOR w = length TO cl + 1 STEP -1
thefile(w) = thefile(w - 1)
NEXT w
thefile(cl) = 65 + echannel * 2
gosub a1000
END IF

IF k = "o" THEN
' key OFF
gosub a4004
length = length + 1
FOR w = length TO cl + 1 STEP -1
thefile(w) = thefile(w - 1)
NEXT w
thefile(cl) = 64 + echannel * 2
gosub a1000
END IF

IF k = "c" THEN
' no keys on or off
fcount = 0
cl = 0
x = 0
DO
cl = cl + x
z = thefile(cl)
gosub a2100
LOOP UNTIL fcount >= frames
IF fcount > frames THEN goto a4010
cl = cl + x
DO
z = thefile(cl)

IF z < 32 THEN cl = cl + 2: goto a4013
IF z < 64 THEN cl = length: goto a4013
IF z < 96 THEN
IF ((z AND 14) shr 1) = echannel THEN
FOR w = cl TO length - 1
thefile(w) = thefile(w + 1)
NEXT w
length = length - 1: goto a4013
END IF
cl = cl + 1: goto a4013
END IF
IF z < 128 THEN cl = cl + 1: goto a4013
'IF z < 192 THEN cl = cl + 2: goto a4013
IF z < 253 THEN cl = cl + 2: goto a4013

cl=cl+1

a4013: LOOP UNTIL cl >= length
gosub a1000
END IF

IF k = "q" THEN
gosub a2000
LOCATE 2, 1: PRINT "Quit (y/n)"; : INPUT k
IF k = "y" THEN END
goto a4010
END IF

IF k = chr$(255) + CHR$(75) THEN echannel = echannel - 1: IF echannel < 0 THEN echannel = 0
IF k = chr$(255) + CHR$(77) THEN echannel = echannel + 1: IF echannel > 4 THEN echannel = 4
IF k = chr$(255) + CHR$(72) THEN eline = eline - 1: IF eline < 0 THEN eline = 0:k="a"
IF k = chr$(255) + CHR$(80) THEN eline = eline + 1: IF eline > 16 THEN eline = 16:k="z"

IF k = "a" THEN
nlines = nlines - 1
IF nlines < 0 THEN nlines = 0
gosub a2200
END IF
IF k = "z" THEN
nlines = nlines + 1
gosub a2200
END IF
IF k = "A" THEN
nlines = nlines - 8
IF nlines < 0 THEN nlines = 0
gosub a2200
END IF
IF k = "Z" THEN
nlines = nlines + 8
gosub a2200
END IF

gosub a2200
gosub a4001
gosub a4002

goto a4010


a4001:
' notes cursor
x = echannel * 20 + eline * 160 + 961
'FOR y = 27 TO 36
'DEF SEG = &HB800
'POKE x + (y * 2), 79
'DEF SEG
'NEXT y

x=echannel*10+28
color 7,4
for y=x to x+9
locate eline+7,y
? chr$(screen(eline+7,y))
next y
color 7,0
RETURN


a4002: 'registers status
w = fpl * nlines + eline * fpl + 1

FOR x = 0 TO 34: regs(x) = 0: NEXT x

FOR x = 0 TO 4
vibrato(x) = 0
NEXT x

frames = 0
x = 0
countdown = 0
DO
IF countdown > 0 THEN
countdown = countdown - 1
frames = frames + 1

IF frames = w THEN
frames = frames - 1
gosub a2000
freq=3579545 / ((regs(echannel + 30) + 1) * 32)
freq3=200000
for octave=1 to 5
for halfstep=0 to 11
freq2 = 8363 * 2 ^ (octave + 2 - (120 - halfstep) / 12)
if abs(freq2-freq)<freq3 then freq3=abs(freq2-freq):y=halfstep:o=octave
next halfstep
next octave

if y=0 then lgaim="c"
if y=1 then lgaim="c+"
if y=2 then lgaim="d"
if y=3 then lgaim="d+"
if y=4 then lgaim="e"
if y=5 then lgaim="f"
if y=6 then lgaim="f+"
if y=7 then lgaim="g"
if y=8 then lgaim="g+"
if y=9 then lgaim="a"
if y=10 then lgaim="a+"
if y=11 then lgaim="b"

LOCATE 2, 1, 0
PRINT "Channel "; echannel; " Frame "; frames; " Vibrato "; vibrato(echannel)
PRINT "Volume "; regs(echannel); " Attack "; regs(echannel + 5); " Decay1 "; regs(echannel + 10); " Decay2 "; regs(echannel + 15); " Level "; regs(echannel + 20)
PRINT "Panning "; panning(echannel); " Release "; regs(echannel + 25); " Period "; regs(echannel + 30); " ( Frequency "; INT(freq); ") ";str$(o);lgaim
RETURN
END IF

goto a4003
END IF

z = thefile(x)

IF z < 32 THEN x = x + 2: regs(z) = thefile(x - 1): goto a4003
IF z < 64 THEN x = x + 1: countdown = z - 31: goto a4003
IF z < 96 THEN x = x + 1: keys((z AND 14) shr 1) = (z AND 1): goto a4003
IF z < 128 THEN x = x + 1: vibrato(z AND 7) = (z AND 16): goto a4003
IF z < 192 THEN x = x + 2: regs(30 + ((z AND 56) shr 3)) = ((z AND 7) shl 8) + thefile(x - 1): goto a4003
IF z < 253 THEN x = x + 2: panning(z AND 7) = thefile(x - 1): goto a4003

x=x+1

a4003: IF x > length - 1 THEN IF countdown = 0 THEN RETURN
LOOP

a4004: frames = fpl * (nlines + eline)
a4005: fcount = 0
cl = 0
x = 0
IF frames = 0 THEN RETURN
DO
cl = cl + x
IF cl >= length THEN RETURN
z = thefile(cl)
gosub a2100
LOOP UNTIL fcount >= frames
IF fcount = frames THEN cl = cl + x: RETURN
y = fcount - frames
thefile(cl) = (thefile(cl) AND 31) - y + 32
length = length + 1
cl = cl + 1
FOR w = length TO cl STEP -1
thefile(w) = thefile(w - 1)
NEXT w
thefile(cl) = y + 31
RETURN

a575: PRINT "D'oh! bogus data was encountered when parsing the file in memory."
PRINT "I'm going to exit to DOS now but I'll be considerate and save the"
PRINT "file first, as BUGGERED.DT"
ff1=freefile
OPEN "buggered.dt" FOR BINARY AS #ff1
IF lof(ff1) > 1 THEN close #ff1: KILL "buggered.dt": OPEN "buggered.dt" FOR BINARY AS #ff1
FOR x = 0 TO 4
byt = CHR$(iassign(x))
put #ff1, , byt
NEXT x
FOR x = 0 TO length - 1
byt = CHR$(thefile(x))
put #ff1, , byt
NEXT x
close #ff1
END


writewav:

'RUBBISH
panning(0) = 79
panning(1) = 255
panning(2) = 255
panning(3) = 244
panning(4) = 255

seconds = 0
frames = 0
gosub a2000
LOCATE 2, 1, 0
PRINT "Writing .WAV file"
ff1=freefile
OPEN "dtracker.wav" FOR BINARY AS #ff1
IF lof(ff1) > 1 THEN close #ff1: KILL "dtracker.wav": OPEN "dtracker.wav" FOR BINARY AS #ff1

'write header
a6969: byt = "R": put #ff1, , byt
byt = "I": put #ff1, , byt
byt = "F": put #ff1, , byt
byt = "F": put #ff1, , byt

put #ff1, , dword

byt = "W": put #ff1, , byt
byt = "A": put #ff1, , byt
byt = "V": put #ff1, , byt
byt = "E": put #ff1, , byt

byt = "f": put #ff1, , byt
byt = "m": put #ff1, , byt
byt = "t": put #ff1, , byt
byt = " ": put #ff1, , byt

dword = 16
put #ff1, , dword
sx = 1
put #ff1, , sx
sx = 2           ' 1=mono 2=stereo
put #ff1, , sx
dword = 44100
put #ff1, , dword
dword = 176400   'bytes/second
put #ff1, , dword
sx = 4
put #ff1, , sx     'bytes/sample
sx = 16
put #ff1, , sx

byt = "d": put #ff1, , byt
byt = "a": put #ff1, , byt
byt = "t": put #ff1, , byt
byt = "a": put #ff1, , byt

put #ff1, , dword

FOR x = 30 TO 34: regs(x) = 0: NEXT x

countdown = 0
x = 0
wwstart:
DO
IF countdown > 0 THEN
countdown = countdown - 1
frames = frames + 1
IF (frames MOD 60) = 59 THEN seconds = seconds + 1: PRINT "+";

FOR w = 0 TO 4
IF vibrato(w) = 0 THEN goto a35
vibrato(w) = vibrato(w) + 1
IF vibrato(w) = 11 THEN vibrato(w) = 1
a35: NEXT w

FOR w = 0 TO 4
z = keys(w)
IF z = 0 THEN volume(w) = volume(w) - (regs(25 + w) shl 2): IF volume(w) < 0 THEN volume(w) = 0
IF z = 1 THEN volume(w) = volume(w) + (regs(5 + w) shl 7): IF volume(w) > (regs(w) shl 8) THEN volume(w) = (regs(w) shl 8): keys(w) = 2: goto a32
IF z = 2 THEN
' fuse10
volume(w) = volume(w) - (regs(10 + w) shl 2)
IF volume(w) < regs(w + 20) * (regs(w) shl 3) THEN volume(w) = regs(w + 20) * (regs(w) shl 3): keys(w) = 3: goto a32
END IF
IF z = 3 THEN volume(w) = volume(w) - regs(15 + w): IF volume(w) < 0 THEN volume(w) = 0
a32: NEXT w


FOR w = 0 TO 4
y = ((panning(w) AND 15) shl 5)
FOR i = 0 TO 31
pinstl(w, i) = (instruments(iassign(w), i) * y) / logtable(volume(w) shr 8)
NEXT i
y = ((panning(w) AND 240) shl 1)
FOR i = 0 TO 31
pinstr(w, i) = (instruments(iassign(w), i) * y) / logtable(volume(w) shr 8)
NEXT i
NEXT w

FOR y = 0 TO 1468 STEP 2

zl = 0: zr = 0
FOR i = 1 TO 2
FOR w = 0 TO 4
IF pcount(w) = 0 THEN
IF regs(30 + w) = 0 THEN goto a36
IF regs(30 + w) > 115 THEN pl(w) = regs(30 + w) + viblow(vibrato(w))
IF regs(30 + w) <= 115 THEN pl(w) = regs(30 + w) + vibhigh(vibrato(w))
pcount(w) = pl(w)
goto a34
END IF
pcount(w) = pcount(w) - 1
a34: IF pl(w) > pcount(w) THEN
c = (pcount(w) shl 5) \ pl(w)
zl = zl + pinstl(w, c)
zr = zr + pinstr(w, c)
END IF
a36: NEXT w
NEXT i
wavbuff(y)=zl
wavbuff(y+1)=zr
NEXT y

put #ff1, , wavbuff()

goto a31
END IF

z = thefile(x)

IF z < 32 THEN x = x + 2: regs(z) = thefile(x - 1): goto a31
IF z < 64 THEN x = x + 1: countdown = z - 31: goto a31
IF z < 96 THEN x = x + 1: keys((z AND 14) shr 1) = (z AND 1): goto a31
IF z < 128 THEN
x = x + 1
IF (z AND 16) = 0 THEN vibrato(z AND 7) = 0: goto a31
IF vibrato(z AND 7) = 0 THEN vibrato(z AND 7) = 1
goto a31
end if
IF z < 192 THEN x = x + 2: regs(30 + ((z AND 56) shr 3)) = INT((((z AND 7) shl 8) + thefile(x - 1) + 1) / 1.268): goto a31
IF z < 253 THEN x = x + 2: panning(z AND 7) = thefile(x - 1): goto a31

x=x+1

if z=254 then loopadr=x

a31: LOOP UNTIL x > length - 1

if loopadr<>-1 then x=loopadr:loopadr=-1:goto wwstart

dword = frames * 2940
put #ff1, 41, dword
dword = dword + 36
put #ff1, 5, dword
close #ff1
PRINT " done"
IF dt2wave = 1 THEN END
return


DATA 27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
data 16,19,22,24,27,28,30,31,31,31,30,28,27,24,22,19,16,13,10,8,5,4,2,1,1,1,2,4,5,8,10,13
DATA 4,5,6,6,7,8,9,9,10,11,12,12,13,14,15,15,16,17,18,18,19,20,21,21,22,23,24,24,25,26,27,27
DATA 3,9,14,17,19,21,22,23,23,24,24,24,25,25,25,25,26,26,26,26,26,27,27,27,27,27,27,28,28,28,28,28
DATA 0,3,7,11,16,21,25,28,31,30,28,25,21,18,16,15,17,19,22,26,29,31,30,28,25,21,16,12,8,5,2
DATA 5,10,15,20,25,28,24,21,20,21,22,23,24,25,26,27,28,29,30,20,10,2,0,0,0,0,0,0,0,0,0,2
DATA 5,10,15,20,25,28,24,21,20,21,22,23,24,25,26,27,28,29,30,31,24,18,13,9,6,4,2,15,12,8,4,0
data 1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,30,28,26,24,22,20,18,16,14,12,10,8,6,4,2,0

