' convert uncompressed VGM to DT3
' (revised file format with 11bit period and loops)
' fixed timing bug and ym2612 frequency calculation
' and killed output file if it existed


DEFINT A-Z

DIM vgmadr AS LONG
DIM loopoff AS LONG
DIM loopsam AS LONG
DIM frameticks AS LONG
DIM fourcc AS STRING * 4
DIM lx AS LONG
DIM dx AS DOUBLE
DIM lint AS LONG
DIM regs1(0 TO 255)
DIM regs2(0 TO 255)
DIM keyo(1 TO 6)
DIM vol(1 TO 6)
DIM freq(1 TO 6)
DIM ffreq(1 TO 5)
DIM vibs(1 TO 5)
DIM oct(1 TO 6)
DIM algo(1 TO 6)
DIM a AS STRING * 1
DIM d AS STRING * 1
DIM h AS LONG
DIM r1(64 TO 79) AS SINGLE
DIM r2(64 TO 79) AS SINGLE
DIM attack(1 TO 5)
DIM T1L(1 TO 5)
DIM decay1(1 TO 5)
DIM decay2(1 TO 5)
DIM release(1 TO 5)
DIM panning(1 TO 5)
DIM oldffreq(1 TO 5)
DIM oldvol(1 TO 5)
DIM oldattack(1 TO 5)
DIM oldT1L(1 TO 5)
DIM olddecay1(1 TO 5)
DIM olddecay2(1 TO 5)
DIM oldrelease(1 TO 5)
DIM oldpanning(1 TO 5)
DIM oldkeyo(1 TO 5)
DIM okey(1 TO 5)
DIM ookey(1 TO 5)

DIM opnfactor AS DOUBLE
opnfactor = 7670453 / 150994944

frames = 0

PRINT
'PRINT "infile "; : INPUT inf$
'PRINT "outfile "; : INPUT outf$
inf$ = COMMAND$ + ".vgm"
outf$ = COMMAND$ + ".dt3"
'inf$ = "advanced.vgm"
'outf$ = "advanced.dt3"
PRINT
PRINT "Opening files..."
OPEN inf$ FOR BINARY AS #1
OPEN outf$ FOR BINARY AS #2: IF LOF(2) > 0 THEN CLOSE #2: KILL outf$: OPEN outf$ FOR BINARY AS #2

PRINT "Converting..."
PRINT

' write some zeros for the instrument data
a = CHR$(0)
PUT #2, , a
PUT #2, , a
PUT #2, , a
PUT #2, , a
PUT #2, , a
  
GET #1, , fourcc
IF fourcc <> "Vgm " THEN PRINT "not Vgm ": END

GET #1, , lint  ' EOF offset
GET #1, , lint  ' version
PRINT "Vgm version "; HEX$(lint)

GET #1, , lint  ' sn76489 clock
GET #1, , lint  ' ym2413 clock
GET #1, , lint  ' GD3 offset
GET #1, , lint  ' total samples
GET #1, , loopoff  ' loop offset
GET #1, , loopsam  ' loop samples
GET #1, , lint  ' rate (50hz/60hz or NA)
GET #1, , lint  ' sn76489 flags
GET #1, , lint  ' ym2612 clock
GET #1, , lint  ' ym2151 clock
GET #1, , lint  ' vgm data offset

vgmadr = &H38

IF lint = 0 THEN lint = 12
FOR lx = 5 TO lint
GET #1, , a: vgmadr = vgmadr + 1
NEXT lx

frameticks = 0

DO

3 IF frameticks > 734 THEN frameticks = frameticks - 735: GOSUB 10: GOTO 3

GET #1, , a: vgmadr = vgmadr + 1
b = ASC(a)
'PRINT "read "; HEX$(b)
IF b = &H52 THEN GET #1, , a: GET #1, , d: regs1(ASC(a)) = ASC(d): vgmadr = vgmadr + 2: GOTO 4
IF b = &H53 THEN GET #1, , a: GET #1, , d: regs2(ASC(a)) = ASC(d): vgmadr = vgmadr + 2: GOTO 4

IF b = &H4F THEN GET #1, , d: vgmadr = vgmadr + 1: GOTO 5
IF b = &H50 THEN GET #1, , d: vgmadr = vgmadr + 1: GOTO 5

IF (b AND &HF0) = &H50 THEN GET #1, , x: vgmadr = vgmadr + 2: GOTO 5
IF (b AND &HF0) = &H70 THEN frameticks = frameticks + (b AND 15) + 1: GOTO 5
IF (b AND &HF0) = &H80 THEN frameticks = frameticks + (b AND 15): GOTO 5
IF (b AND &HF0) = &HE0 THEN GET #1, , lint: vgmadr = vgmadr + 4: GOTO 5

IF b = &H61 THEN
GET #1, , x: lx = x: IF lx < 0 THEN lx = lx + 65536
vgmadr = vgmadr + 2: frameticks = frameticks + lx: GOTO 5
END IF

IF b = &H62 THEN frameticks = frameticks + 735: GOTO 5
IF b = &H63 THEN frameticks = frameticks + 882: GOTO 5
IF b = &H66 THEN GOTO 7

IF b = &H67 THEN
GET #1, , x: vgmadr = vgmadr + 2
GET #1, , lint: vgmadr = vgmadr + 4
FOR lx = 1 TO lint
GET #1, , a: vgmadr = vgmadr + 1
NEXT lx
GOTO 5
END IF

PRINT "unexpected byte "; HEX$(b)

GOTO 5

4 IF ASC(a) = 40 THEN
x = (regs1(40) AND 7)
IF x < 4 THEN x = x + 1
y = (regs1(40) AND 240)
IF y = 0 THEN keyo(x) = 0 ELSE oldkeyo(x) = 0: keyo(x) = 1
END IF

'FOR x = 1 TO 5
'ookey(x) = okey(x)
'NEXT x

'IF (regs1(40) AND 7) < 4 THEN okey((regs1(40) AND 7) + 1) = (regs1(40) AND 240)
'IF (regs1(40) AND 7) > 3 THEN okey((regs1(40) AND 7)) = (regs1(40) AND 240)

'FOR x = 1 TO 5
'IF ookey(x) = 5 THEN IF okey(x) = 5 THEN okey(x) = 4
'IF ookey(x) = 5 THEN IF okey(x) = 240 THEN okey(x) = 5
'NEXT x

'keyo((regs1(40) AND 7)) = (regs1(40) AND 240)
'keyo((regs2(40) AND 7)) = (regs2(40) AND 240)

5 LOOP UNTIL EOF(1)
7 CLOSE #1

6 IF frameticks > 734 THEN frameticks = frameticks - 735: GOSUB 10: GOTO 6

IF frames > 0 THEN a = CHR$(31 + frames): PUT #2, , a

CLOSE #2
END

10 'YM2612 emulation


freq(1) = regs1(160) + ((regs1(164) AND 7) * 256)
freq(2) = regs1(161) + ((regs1(165) AND 7) * 256)
freq(3) = regs1(162) + ((regs1(166) AND 7) * 256)
freq(4) = regs2(160) + ((regs2(164) AND 7) * 256)
freq(5) = regs2(161) + ((regs2(165) AND 7) * 256)
freq(6) = regs2(162) + ((regs2(166) AND 7) * 256)

oct(1) = (regs1(164) AND 56) / 8
oct(2) = (regs1(165) AND 56) / 8
oct(3) = (regs1(166) AND 56) / 8
oct(4) = (regs2(164) AND 56) / 8
oct(5) = (regs2(165) AND 56) / 8
oct(6) = (regs2(166) AND 56) / 8

algo(1) = INT(regs1(176) AND 7)
algo(2) = INT(regs1(177) AND 7)
algo(3) = INT(regs1(178) AND 7)
algo(4) = INT(regs2(176) AND 7)
algo(5) = INT(regs2(177) AND 7)
algo(6) = INT(regs2(178) AND 7)

IF (regs1(180) AND 192) = 192 THEN panning(1) = 238
IF (regs1(180) AND 192) = 128 THEN panning(1) = 240
IF (regs1(180) AND 192) = 64 THEN panning(1) = 15
IF (regs1(180) AND 192) = 0 THEN panning(1) = 0
IF (regs1(181) AND 192) = 192 THEN panning(2) = 238
IF (regs1(181) AND 192) = 128 THEN panning(2) = 240
IF (regs1(181) AND 192) = 64 THEN panning(2) = 15
IF (regs1(181) AND 192) = 0 THEN panning(2) = 0
IF (regs1(182) AND 192) = 192 THEN panning(3) = 238
IF (regs1(182) AND 192) = 128 THEN panning(3) = 240
IF (regs1(182) AND 192) = 64 THEN panning(3) = 15
IF (regs1(182) AND 192) = 0 THEN panning(3) = 0
IF (regs2(180) AND 192) = 192 THEN panning(4) = 238
IF (regs2(180) AND 192) = 128 THEN panning(4) = 240
IF (regs2(180) AND 192) = 64 THEN panning(4) = 15
IF (regs2(180) AND 192) = 0 THEN panning(4) = 0
IF (regs2(181) AND 192) = 192 THEN panning(5) = 238
IF (regs2(181) AND 192) = 128 THEN panning(5) = 240
IF (regs2(181) AND 192) = 64 THEN panning(5) = 15
IF (regs2(181) AND 192) = 0 THEN panning(5) = 0

FOR y = 0 TO 2
FOR x = 0 TO 12 STEP 4
r1(64 + x + y) = 127 - (regs1(64 + x + y) AND 127)
NEXT x
NEXT y
FOR y = 0 TO 2
FOR x = 0 TO 12 STEP 4
r2(64 + x + y) = 127 - (regs2(64 + x + y) AND 127)
NEXT x
NEXT y

FOR x = 0 TO 2
FOR y = 0 TO 42 STEP 4
regs1(80 + x + y) = (regs1(80 + x + y) AND 31)
regs2(80 + x + y) = (regs2(80 + x + y) AND 31)
NEXT y
NEXT x

FOR x = 96 TO 111
regs1(x) = (regs1(x) AND 31)
regs2(x) = (regs2(x) AND 31)
NEXT x

FOR x = 1 TO 3
IF algo(x) = 6 THEN algo(x) = 5
IF algo(x) < 4 THEN vol(x) = INT(r1(75 + x) / 4): attack(x) = regs1(91 + x): decay1(x) = regs1(107 + x): decay2(x) = regs1(123 + x): T1L(x) = INT((regs1(139 + x) AND 240) / 2): release(x) = ((regs1(139 + x) AND 15) * 2) + 1
IF algo(x) = 4 THEN
vol(x) = INT((r1(67 + x) + r1(75 + x)) / 8)
attack(x) = INT((regs1(91 + x) + regs1(83 + x)) / 2): decay1(x) = INT((regs1(107 + x) + regs1(99 + x)) / 2): decay2(x) = INT((regs1(123 + x) + regs1(115 + x)) / 2): T1L(x) = INT(((regs1(131 + x) AND 240) + (regs1(139 + x) AND 240)) / 4): release(x)  _
= ((regs1(139 + x) AND 15) + (regs1(131 + x) AND 15)) + 1
END IF
IF algo(x) = 5 THEN
vol(x) = INT((r1(67 + x) + r1(71 + x) + r1(75 + x)) / 12)
attack(x) = INT((regs1(91 + x) + regs1(83 + x) + regs1(87 + x)) / 3): decay1(x) = INT((regs1(107 + x) + regs1(99 + x) + regs1(103 + x)) / 3): decay2(x) = INT((regs1(123 + x) + regs1(115 + x) + regs1(119 + x)) / 3): T1L(x) = INT(((regs1(131 + x) AND  _
240) + (regs1(139 + x) AND 240) + (regs1(135 + x) AND 240)) / 6): release(x) = INT(((regs1(139 + x) AND 15) + (regs1(131 + x) AND 15) + (regs1(135 + x) AND 15)) / 1.5) + 1
END IF
IF algo(x) = 7 THEN
vol(x) = INT((r1(63 + x) + r1(67 + x) + r1(71 + x) + r1(75 + x)) / 16)
attack(x) = INT((regs1(91 + x) + regs1(83 + x) + regs1(87 + x) + regs1(79 + x)) / 4): decay1(x) = INT((regs1(107 + x) + regs1(99 + x) + regs1(103 + x) + regs1(95 + x)) / 4): decay2(x) = INT((regs1(123 + x) + regs1(115 + x) + regs1(119 + x) + regs1( _
111 + x)) / 4): T1L(x) = INT(((regs1(131 + x) AND 240) + (regs1(139 + x) AND 240) + (regs1(135 + x) AND 240) + (regs1(127 + x) AND 240)) / 8): release(x) = INT(((regs1(139 + x) AND 15) + (regs1(131 + x) AND 15) + (regs1(135 + x) AND 15) + (regs1(127 _
 + x) AND 15)) / 2) + 1
END IF
NEXT x
FOR x = 1 TO 2
IF algo(x + 3) = 6 THEN algo(x + 3) = 5
IF algo(x + 3) < 4 THEN vol(x + 3) = INT(r2(75 + x) / 4): attack(x + 3) = regs2(91 + x): decay1(x + 3) = regs2(107 + x): decay2(x + 3) = regs2(123 + x): T1L(x + 3) = INT((regs2(139 + x) AND 240) / 2): release(x + 3) = ((regs2(139 + x) AND 15) * 2) + _
 1
IF algo(x + 3) = 4 THEN
vol(x + 3) = INT((r2(67 + x) + r2(75 + x)) / 8)
attack(x + 3) = INT((regs2(91 + x) + regs2(83 + x)) / 2): decay1(x + 3) = INT((regs2(107 + x) + regs2(99 + x)) / 2): decay2(x + 3) = INT((regs2(123 + x) + regs2(115 + x)) / 2): T1L(x + 3) = INT(((regs2(131 + x) AND 240) + (regs2(139 + x) AND 240)) / _
 4): release(x + 3) = ((regs2(139 + x) AND 15) + (regs2(131 + x) AND 15)) + 1
END IF
IF algo(x + 3) = 5 THEN
vol(x + 3) = INT((r2(67 + x) + r2(71 + x) + r2(75 + x)) / 12)
attack(x + 3) = INT((regs2(91 + x) + regs2(83 + x) + regs2(87 + x)) / 3): decay1(x + 3) = INT((regs2(107 + x) + regs2(99 + x) + regs2(103 + x)) / 3): decay2(x + 3) = INT((regs2(123 + x) + regs2(115 + x) + regs2(119 + x)) / 3): T1L(x + 3) = INT((( _
regs2(131 + x) AND 240) + (regs2(139 + x) AND 240) + (regs2(135 + x) AND 240)) / 6): release(x + 3) = INT(((regs2(139 + x) AND 15) + (regs2(131 + x) AND 15) + (regs2(135 + x) AND 15)) / 1.5) + 1
END IF
IF algo(x + 3) = 7 THEN
vol(x + 3) = INT((r2(63 + x) + r2(67 + x) + r2(71 + x) + r2(75 + x)) / 16)
attack(x + 3) = INT((regs2(91 + x) + regs2(83 + x) + regs2(87 + x) + regs2(79 + x)) / 4): decay1(x + 3) = INT((regs2(107 + x) + regs2(99 + x) + regs2(103 + x) + regs2(95 + x)) / 4): decay2(x + 3) = INT((regs2(123 + x) + regs2(115 + x) + regs2(119 +  _
x) + regs2(111 + x)) / 4): T1L(x + 3) = INT(((regs2(131 + x) AND 240) + (regs2(139 + x) AND 240) + (regs2(135 + x) AND 240) + (regs2(127 + x) AND 240)) / 8): release(x + 3) = INT(((regs2(139 + x) AND 15) + (regs2(131 + x) AND 15) + (regs2(135 + x)  _
AND 15) + (regs2(127 + x) AND 15)) / 2) + 1
END IF
NEXT x

'PRINT okey(1); " "; okey(2); " "; okey(3); " "; okey(4); " "; okey(5); " "

'FOR x = 1 TO 5
'IF okey(x) = 0 THEN keyo(x) = 0
'IF okey(x) = 240 THEN oldkeyo(x) = 0: keyo(x) = 1: okey(x) = 5
'NEXT x

FOR y = 1 TO 5
dx = freq(y)
x = oct(y)
490 IF x > 0 THEN x = x - 1: dx = dx * 2: GOTO 490
dx = dx * opnfactor * 8
IF dx = 0 THEN dx = 1
lx = INT(3579545 / dx) - 1
IF lx < 2 THEN lx = 2
491 IF lx > 2045 THEN lx = lx \ 2: GOTO 491
ffreq(y) = lx
NEXT y

FOR x = 1 TO 5
T1L(x) = 127 - T1L(x)
NEXT x

REM tweaks
'vol(3) = 14
'vol(5) = 21
'release(3) = 0
'release(5) = 31
'vol(3) = vol(3) / 2
'T1L(3) = T1L(3) / 2
'vol(5) = vol(5) / 2 + 4
'T1L(5) = T1L(5) / 2 + 4
'T1L(3) = 44
'T1L(5) = 72
'decay1(5) = 31
'decay2(3) = 0
'decay2(5) = 0

'PRINT release(1); " "; release(2); " "; release(3); " "; release(4); " "; release(5); " "
'PRINT keyo(1); " "; keyo(2); " "; keyo(3); " "; keyo(4); " "; keyo(5); " "
'PRINT decay2(1); " "; decay2(2); " "; decay2(3); " "; decay2(4); " "; decay2(5); " "
'PRINT T1L(1); " "; T1L(2); " "; T1L(3); " "; T1L(4); " "; T1L(5)
'PRINT decay1(1); decay1(2); decay1(3); decay1(4); decay1(5)

'FOR arg = 1 TO 30000
'NEXT arg
'PRINT "vol "; vol(1); " d1 "; decay1(1); " d2 "; decay2(1); " T "; T1L(1); " r "; release(1)


' vibrato detect
FOR x = 1 TO 5
ra = 4 + (ffreq(x) \ 100)
IF ffreq(x) <> oldffreq(x) THEN
IF ((ffreq(x) > oldffreq(x) - ra) AND (ffreq(x) < oldffreq(x) + ra)) THEN
ffreq(x) = oldffreq(x)
IF vibs(x) = 0 THEN vibs(x) = 1: a = CHR$(x + 111): PUT #2, , a
ELSE
vibs(x) = 0
END IF
END IF
NEXT x


c = 0
FOR x = 1 TO 5
IF loopoff > 0 THEN IF vgmadr >= loopoff THEN c = 1
IF oldffreq(x) <> ffreq(x) THEN c = 1
IF oldvol(x) <> vol(x) THEN c = 1
IF oldattack(x) <> attack(x) THEN c = 1
IF olddecay1(x) <> decay1(x) THEN c = 1
IF olddecay2(x) <> decay2(x) THEN c = 1
IF oldT1L(x) <> T1L(x) THEN c = 1
IF oldrelease(x) <> release(x) THEN c = 1
IF oldkeyo(x) <> keyo(x) THEN c = 1
NEXT x
IF c = 1 THEN a = CHR$(32 + frames): frames = 0: PUT #2, , a
IF c = 0 THEN
frames = frames + 1
IF frames = 31 THEN a = CHR$(63): PUT #2, , a: frames = 0
RETURN
END IF

'FOR x = 0 TO 15
'PRINT (regs1(128 + x) AND 240);
'NEXT x
'PRINT
'
'
'PRINT T1L(1); T1L(2); T1L(3); T1L(4); T1L(5)
'PRINT

FOR x = 1 TO 5
IF loopoff > 0 THEN IF vgmadr >= loopoff THEN loopoff = 0: a = CHR$(253): PUT #2, , a
IF oldffreq(x) <> ffreq(x) THEN a = CHR$(128 + ((x - 1) * 8) + INT(ffreq(x) / 256)): PUT #2, , a: a = CHR$(ffreq(x) AND 255): PUT #2, , a
IF oldvol(x) <> vol(x) THEN a = CHR$(x - 1): PUT #2, , a: a = CHR$(vol(x)): PUT #2, , a
IF oldattack(x) <> attack(x) THEN a = CHR$(x + 4): PUT #2, , a: a = CHR$(attack(x) / 2): PUT #2, , a
IF olddecay1(x) <> decay1(x) THEN a = CHR$(x + 9): PUT #2, , a: a = CHR$((decay1(x) / 2) * (decay1(x) / 2)): PUT #2, , a
IF decay2(x) > 44 THEN decay2(x) = 44
IF olddecay2(x) <> decay2(x) THEN a = CHR$(x + 14): PUT #2, , a: a = CHR$((decay2(x) * decay2(x)) / 8): PUT #2, , a
IF oldT1L(x) <> T1L(x) THEN a = CHR$(x + 19): PUT #2, , a: a = CHR$(T1L(x) / 4): PUT #2, , a
IF oldrelease(x) <> release(x) THEN a = CHR$(x + 24): PUT #2, , a: a = CHR$(release(x) * 8): PUT #2, , a
IF oldkeyo(x) <> keyo(x) THEN a = CHR$(64 + ((x - 1) * 2) + keyo(x)): PUT #2, , a
IF oldpanning(x) <> panning(x) THEN a = CHR$(192 + (x - 1)): PUT #2, , a: a = CHR$(panning(x)): PUT #2, , a
NEXT x

FOR x = 1 TO 5
oldffreq(x) = ffreq(x)
oldvol(x) = vol(x)
oldattack(x) = attack(x)
olddecay1(x) = decay1(x)
olddecay2(x) = decay2(x)
oldT1L(x) = T1L(x)
oldrelease(x) = release(x)
oldkeyo(x) = keyo(x)
oldpanning(x) = panning(x)
NEXT x

RETURN

