;Some side view jet game
;DamageX 1999
;
;some bits taken from DEMO.ASM aka CART.PCE
; (you know, that thing with the wavy water and the stars)
;
;beware of unoptimal code here and other st00pid stuff
;I had just begun my journey into the wonderful world of
;6502/6280 assembly
;
;ram map
;
;$2000 vblank (cleared at start of vb)
;$2001-2 controller status
;$2003-4 misc
;$2005 misc
;$2006 which jet u r
;$2007 whether the multiscrolling stars should be on
;$2008 used by vb int
;$2009 ALT
;$200A ALTs (switches every other frame)
;$200B do that thing where the jet comes on the screen
;$200C can't move
;$200D used by waitf
;$200E if your jet is there
;$200F countdown until jet stops flashing
;$2010-1 jet h
;$2012-3 jet v
;$2014 count to 4
;
;$2020-2 temp storage for GRB values
;$2023   used within fadepal
;$2024   more misc        (used by fadepal)
;$2025-6 pointer used by fadepal
;
;$2040-E existence/type
;$2050-E h lo                player's shots
;$2060-E h hi
;$2070-E v lo
;$2080-E v hi
;
;$3000-31FF sprite table
;
;$3800-3BFF used by jet select
;$3C00-3FFF copy of palette
;


	.bank 0
	.org $FFF6

        .dw null_int    
        .dw vb_int      
        .dw null_int    
        .dw null_int    
        .dw reset_int   

	.org $E000


vb_int:
        pha
        phx

        lda $0000             ; makes the ROM run some more emulators

        sec
	lda #1
	sbc <$09              ; ALT
	sta <$09
	beq d1
	lda #1
	sec
	sbc <$0A              ; ALTs
	sta <$0A
d1:

        ldx <$14
        inx
        cpx #4                ; count to 4
        bne d2
        clx
d2:
        stx <$14

	lda #1
	sta $1000
	lda #3
	sta $1000
	lda #1
	sta $1000
	pha
        pla                   ; I guess these waits are necessary  
        nop                   ; on a real TG ?
	lda $1000
	sta <$02              ; inverse L D R U
	lda #0
	sta $1000
	pha
	pla
	nop
	lda $1000
	sta <$01              ; R S I II

	ldx <$07
	bne c16
c15:
        plx
        pla
	stz <$00
null_int:
	rti
c16:                          ; multiscrolling stars
	sty <$08
	clx
c17:
	txa
        asl a
        asl a
        asl a
	tay
	sec
	lda $3102,y
	sbc #1
	sta $3102,y
	lda $3103,y
	sbc #0
	sta $3103,y
	cmp #0
	bne c18
	lda $3102,y
	cmp #26
	bne c18
	lda #140
	sta $3102,y
	lda #1
	sta $3103,y
c18:
	inx
	cpx #16
	bne c17
	ldy <$09
	beq c19
c20:
	txa
        asl a
        asl a
        asl a
	tay
	sec
	lda $3102,y
	sbc #1
	sta $3102,y
	lda $3103,y
	sbc #0
	sta $3103,y
	cmp #0
	bne c21
	lda $3102,y
	cmp #26
	bne c21
	lda #140
	sta $3102,y
	lda #1
	sta $3103,y
c21:
	inx
	cpx #32
	bne c20
c19:
	st0 #0
	st1 #128
	st2 #$7F
	st0 #2
	tia $3100,$0002,$0100
	ldy <$08
	jmp c15

reset_int:
	sei                   ; disable interrupts 
	csh                   ; select the 7.16 MHz clock
	cld                   ; clear the decimal flag 
	lda #$FF              ; page 0 is i/o
	tam #0
	lda #$F8              ; page 1 is ram
	tam #1
	lda #$02              ; page 2 is rom bank
	tam #2
	lda #$03              ; page 3 is rom bank
	tam #3
	lda #$04              ; page 4 is rom bank
	tam #4
	lda #$05              ; page 5 is rom bank
	tam #5
	lda #$01              ; page 6 is 2nd code bank
	tam #6
	stz $2000             ; clear all the RAM
	tii $2000,$2001,$1FFF
	ldx #$FF              ; initialize the stack
	txs
	jsr initvid           ; initialize the video controller
;        jsr initpsg           ; and the sound generator
	jsr clearvram         ; duh
	jsr palette1          ; set palette
	jsr copyblks
	jsr copyblks2
	stz $C01              ; stop the timer

	cli
        jsr copyspr
        jsr palette1 
	jsr copytitle
	jsr initstars
	ldx #1
	stx <$07

	st0 #0
	st1 #14
	st2 #5
	st0 #2
	tia words4,$0002,$0020

        jsr waitt
        ldx #8
	jsr waitkey
        jsr fadepal
        jsr waitv
        jsr palette1
        jsr jetselect
	jsr clearspr
	jsr clearsprt
	jsr clearmap
	stz <$07              ; turn off multiscrolling stars

	lda <$06
	asl a
	asl a
	asl a
	tay
	clx
			      ; copy jet sprite over
a9:
	lda jetsprites,y
	sta $3000,x
	inx
	iny
	cpx #8
	bne a9
	jsr prepare1
	ldx #1
	stx <$0B
	stz <$10
	stz <$11              ; h

	stz <$13              ; v
	ldx #176
	stx <$12

        ldx #222              ; flash for a while
        stx <$0F

	jmp startloop

prepare1:

       rts

initstars:
	clx
c13:
	txa
	clc
	rol a
	rol a
	rol a
	tay
	lda starsxy,x
	sta $3100,y
	lda starsxy+32,x
	sta $3101,y
	lda starsxy+64,x
	sta $3102,y
	lda starsxy+96,x
	sta $3103,y
	lda #$0C
	sta $3104,y
	lda #3
	sta $3105,y
	lda #$1
	sta $3106,y
	inx
	cpx #16
	bne c13
c14:
	txa
	clc
	rol a
	rol a
	rol a
	tay
	lda starsxy,x
	sta $3100,y
	lda starsxy+32,x
	sta $3101,y
	lda starsxy+64,x
	sta $3102,y
	lda starsxy+96,x
	sta $3103,y
	lda #$0E
	sta $3104,y
	lda #3
	sta $3105,y
	lda #$1
	sta $3106,y
	inx
	cpx #32
	bne c14
	rts

initvid:
	st0 #5
	st1 #200              ; control reg
	st2 #0

	st0 #7
	st1 #0                ; scroll x
	st2 #0
	st0 #8
	st1 #0                ; scroll y
	st2 #0

	st0 #9
	st1 #208              ; screen size
	st2 #0

	st0 #10
	st1 #2                ; horizontal register things
	st2 #2

	st0 #11
	st1 #44               ; more h reg things
	st2 #4

	st0 #12
	st1 #2
	st2 #15
	st0 #13               ; vertical reg things
	st1 #$EF
	st2 #0
	st0 #14
	st1 #4
	st2 #0

	st0 #15
	st1 #16               ; dma reg
	st2 #0

	st0 #19
	st1 #0                ; sprite table adr
	st2 #$7F

	ldx #5
	stx $0400             ; color clock 
	rts

copyblks:
	lda #$03              ; switch in blocks bank 1
	tam #3
	st0 #0
	st1 #0
	st2 #$20

	st0 #2
	tia $6000,$0002,$2000
	rts

waitt:
        ldx #4
a78:
	jsr waitv
	dex
        bne a78
	rts

fadepal:
        ldx #8
        stx <$24

        lda #1
        sta <$25
        cly
a67:
        lda #$3B
        sta <$26
        lda #4
        sta <$27
a76:
        inc <$26
a77:
        lda [$25],y
        asl a
        asl a
        sta <$20
        dec <$25
        lda [$25],y
        tax
        and #7
        sta <$22
        txa
        lsr a
        lsr a
        lsr a
        tax
        and #7
        sta <$21
        txa
        lsr a
        lsr a
        lsr a
        and #3
        clc
        adc <$20
        dec a
        bpl a68
        inc a
a68:
        sta <$20
        lda <$21
        dec a
        bpl a69
        inc a
a69:
        sta <$21
        lda <$22
        dec a
        bpl a70
        inc a
a70:
        sta <$22
        sta <$23
        lda <$21
        asl a
        asl a
        asl a
        clc
        adc <$23
        sta <$23
        lda <$20
        and #3
        asl a
        asl a
        asl a
        asl a
        asl a
        asl a
        adc <$23
        sta [$25],y
        cla
        inc <$25
        sta [$25],y
        lda <$20
        and #4
        beq a71
        lda #1
        sta [$25],y
a71:
        iny
        iny
        bne a77

        dec <$27
        bne a76

        jsr waitt
        jsr a72

        cly
        dec <$24
        bne a67
        rts

copyblks2:
	lda #$04              ; switch in title screen 
	tam #4                ; blocks 1  
	st0 #0
	st1 #0
	st2 #$30

	st0 #2
	tia $8000,$0002,$2000
	rts

copyspr:
	lda #$05              ; switch in sprites
	tam #4
	st0 #0
	st1 #0
	st2 #$60

	st0 #2
	tia $8000,$0002,$1000
	rts

clearsprt:
	stz $3000
	stz $3001
	tai $3000,$3002,$01FE
	rts

updateshots:
        ldx #15
        stx <$05
a30:
        ldx <$05
        dex
        bmi a32
        stx <$05
        lda <$40,x
        bne a31
        txa
        asl a
        asl a
        asl a
        tax
        lda #2
        sta $3009,x
        bra a30
a31:
        tay
        lda <$50,x
        clc
        adc shotspecs+3,y
        sta <$50,x
        lda <$60,x
        adc #0
        sta <$60,x
        lda <$50,x
        sec
        sbc #128
        sta <$50,x
        lda <$60,x
        sbc #0
        sta <$60,x
        lda <$70,x
        clc
        adc shotspecs+2,y
        sta <$70,x
        lda <$80,x
        adc #0
        sta <$80,x
        lda <$70,x
        sec
        sbc #128
        sta <$70,x
        lda <$80,x
        sbc #0
        sta <$80,x
        txa
        asl a
        asl a
        asl a
        tay
        lda <$50,x
        sta $300A,y
        lda <$60,x
        sta $300B,y
        lda <$70,x
        sta $3008,y
        lda <$80,x
        sta $3009,y
        beq a34
        bmi a33
        lda <$70,x
        cmp #40
        bmi a34
a33:
        stz <$40,x
a34:
        lda <$60,x
        beq a36
        bmi a35
        lda <$50,x
        cmp #168
        bcc a36
a35:
        stz <$40,x
a36:
        jmp a30
a32:
        rts

addshotp:
	ldx #15
        stx <$05
a27:
	lda <$40,x
	beq a28
        ldx <$05
        dex
        stx <$05
	bne a27
	rts
a28:                 
	sty <$40,x
        lda shotspecs+5,y
	clc
	adc <$10
        sta <$50,x
        cla
        adc <$11
        sta <$60,x
	sec
        lda <$50,x
	sbc #128
        sta <$50,x
        lda <$60,x
	sbc #0
        sta <$60,x
        lda shotspecs+4,y
	clc
	adc <$12
        sta <$70,x
	lda <$13      
	adc #0
        sta <$80,x
	sec
        lda <$70,x
	sbc #128
        sta <$70,x
        lda <$80,x
	sbc #0
        sta <$80,x
	txa
	asl a
	asl a
	asl a
	tax
	lda shotdata,y
	sta $300C,x
	lda shotdata+1,y
	sta $300D,x
	lda shotdata+2,y
	sta $300E,x
	lda shotdata+3,y
	sta $300F,x
	rts

clearspr:
	st0 #0
	st1 #0
	st2 #$7F
	st0 #2

	clx
c11:
	stz $0002
	stz $0003
	dex
	bne c11
	rts

palette1:
	tii $4000,$3C00,$0400

a72:
	stz $0402
	stz $0403

	clx
a3:
        lda $3C00,x
	sta $0404
	inx
        lda $3C00,x
	sta $0405
	inx
	bne a3
a4:
        lda $3D00,x
	sta $0404
	inx
        lda $3D00,x
	sta $0405
	inx
	bne a4
a40:
        lda $3E00,x
	sta $0404
	inx
        lda $3E00,x
	sta $0405
	inx
	bne a40
a41:
        lda $3F00,x
	sta $0404
	inx
        lda $3F00,x
	sta $0405
	inx
	bne a41

	rts

clearmap:
	st0 #0
	st1 #0
	st2 #0
	st0 #2

	ldx #0
	ldy #16
a7:
	st1 #0
	st2 #1
	dex
	bne a7
	dey
	bne a7

	rts

clearvram:
	st0 #0
	st1 #0
	st2 #0
	st0 #2

	ldx #0
	ldy #128
a2:
	st1 #0
	st2 #0
	dex
	bne a2
	dey
	bne a2

	rts

waitv:
	ldy #1
	sty $2000
a6:
	lda $2000
	bne a6
	rts

waitf:
	ldx #120
	stx <$0D
a1:
	jsr waitv
	lda #8
	and <$01
	bne a21
	lda <$0D
	bne a22
	lda #8
	and <$01
	beq a13
a22:
	dex
	bne a1
a13:
	jsr waitv
	rts
a21:
	stz <$0D
	bra a22

jetselect:
	jsr clearmap

	st0 #0
	st1 #14
	st2 #5
	st0 #2
	tia words3,$0002,$0022

	; setting up jet sprites
	tii jetsprites,$3000,$0018   

c2:
	lda <$02
	and #10
	cmp #10
	bne c2

	jsr waitv

	lda #3
	and <$01
	cmp #3
	beq c12
	jmp c3
c12:
	ldx <$02

	txa
	and #2
	bne c4
	inc <$06
c4:
	txa
	and #8
	bne c5
	dec <$06
c5:
	ldy <$06
	cpy #255
	bne c6
	stz <$06
c6:
	cpy #3
	bne c7
	dec <$06
c7:
	stz $3800
	stz $3801
	inc $3801
	inc $3801
	tai $3800,$3802,$3FE

	ldy <$06

	cpy #2
	bne c8
	tii selectorb,$3018,$0020
	tii stats1m,$3824,$0010
	tii stats2m,$3922,$0016
	tii stats3m,$3A22,$0014
	tii stats4m,$3AA2,$0014
	jmp c10
c8:
	cpy #1
	bne c9
	tii selectora,$3018,$0020
	tii stats1r,$3826,$000E
	tii stats2r,$3922,$0016
	tii stats3r,$3A22,$0018
	jmp c10
c9:
	tii selector,$3018,$0020
	tii stats1e,$3822,$0014
	tii stats2e,$3920,$0018
	tii stats3e,$3A22,$0014
	tii stats4e,$3AA2,$0016
c10:
	st0 #0
	st1 #0
	st2 #2
	st0 #2
	tia $3800,$0002,$0400
	st0 #0
	st1 #0
	st2 #$7F
	st0 #2
	tia $3000,$0002,$0200
	jmp c2

c3:
	rts

copytitle:
	st0 #0
	st1 #64
	st2 #0
	st0 #2
	tia titlemap,$0002,$0400
	rts

waitkey:
	stx <$05
c1:
	lda <$01
	and <$05
	bne c1
	rts

movement:
	ldx <$02

	txa
	and #1
	bne a23
	lda <$12                ;
	sec                     ;
	sbc #3                  ; stuff to go up
	sta <$12                ;
	lda <$13                ;
	sbc #0                  ;
	sta <$13
	bne a23
	lda <$12
	cmp #73
	bcs a23
	clc
	adc #3
	sta <$12
a23:
	txa
	and #4
	bne a24
	lda <$12                ;
	clc                     ;
	adc #3                  ; stuff to go down
	sta <$12                ;
	lda <$13                ;
	adc #0                  ;
	sta <$13
	beq a24
	lda <$12
	cmp #15
	bmi a24
	sec
	sbc #3
	sta <$12
a24:
	txa
	and #2
	bne a25
	lda <$10                ;
	clc                     ;
	adc #4                  ; stuff to go right
	sta <$10                ;
	lda <$11                ;
	adc #0                  ;
	sta <$11
	beq a25
	lda <$10
	cmp #100
	bmi a25
	sec
	sbc #4
	sta <$10
a25:
	txa
	and #8
	bne a26
	lda <$10                ;
	sec                     ;
	sbc #4                  ; stuff to go left
	sta <$10                ;
	lda <$11                ;
	sbc #0                  ;
	sta <$11
	bne a26
	lda <$10
	cmp #33
	bcs a26
	clc
	adc #4
	sta <$10
a26:

	rts

	.bank 1
	.org $C000

startloop:
	jsr waitv

	ldx <$0B            ; that thing where jet comes from left?
	beq a12
	inc <$0C
	ldx <$10
	inx
	stx <$10
	cpx #96             ; jet had better be left of 64
	bne a12
	stz <$0E
	stz <$0C
	stz <$0B
a12:
	ldx <$0C
	bne a15             ; movement
	jsr movement
a15:
	ldx <$0F            ; flashing ?
	beq a14
        ldx <$0A
	stx <$0E
        dec <$0F
        bne a14
        stz <$0E
a14:
	ldx <$0E            ; there ?
	beq a10
	ldx #2
	stx $3001
	jmp a11
a10:
	ldx <$12            ;
	stx $3000           ;   jet v
	ldx <$13            ;
	stx $3001           
	ldx <$10            ;
	stx $3002           ;   jet h
	ldx <$11            ;
	stx $3003           
a11:

	ldx <$0C
	bne a29
        lda <$01
        and #2
        bne a29
        lda <$14            ;   shooting
        bne a29
        lda <$06
        inc a
        asl a
        asl a
        asl a
        tay
	jsr addshotp
a29:
        jsr updateshots

	st0 #0
	st1 #0
	st2 #$7F
	st0 #2
	tia $3000,$0002,$0200
a8:
	jmp startloop

	.bank 2
	.org $4000

pal1:
	.dw 000,073,146,219,292,365,438,511,001,002,003,004,005,006,007,000
	.dw 000,511,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000

	.dw 000,146,219,292,365,003,005,160,232,080,024,040,132,196,260,324
	.dw 000,040,056,366,294,075,002,000,000,000,000,000,000,000,000,000
	.dw 000,438,292,511,508,434,432,056,040,024,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	.dw 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000

words3:
	.dw $1203,$1208,$120F,$120F,$1213,$1205,$1200
	.dw $1219,$120F,$1215,$1212,$1200
	.dw $1203,$1212,$1201,$1206,$1214
words4:
	.dw $1210,$1212,$1205,$1213,$1213,$1200
	.dw $1212,$1215,$120E,$1200
	.dw $1202,$1215,$1214,$1214,$120F,$120E
jetsprites:
	.dw $0100,98,$0300,$0180
	.dw $0100,196,$0304,$0180
	.dw $0100,302,$0308,$0080
selector:
	.dw $00F0,82,$030A,$0081
	.dw $0110,82,$030A,$8081
	.dw $00F0,130,$030A,$0881
	.dw $0110,130,$030A,$8881
selectora:
	.dw $00F0,180,$030A,$0081
	.dw $0110,180,$030A,$8081
	.dw $00F0,228,$030A,$0881
	.dw $0110,228,$030A,$8881
selectorb:
	.dw $00F0,278,$030A,$0081
	.dw $0110,278,$030A,$8081
	.dw $00F0,326,$030A,$0881
	.dw $0110,326,$030A,$8881
stats1e:
	.dw $123A,$1236,$1205,$1200,$1213,$1209,$120C,$1216,$1205,$1212
stats2e:
	.dw $120D,$1201,$1203,$1208,$1209,$120E,$1205,$1200,$1207,$1215,$120E,$1213
stats3e:
	.dw $1237,$1200,$1205,$120E,$1208,$1201,$120E,$1203,$1205,$1204
stats4e
	.dw $1217,$1205,$1201,$1210,$120F,$120E,$1200,$1202,$1201,$1219,$1213
stats1r:
	.dw $123A,$1237,$1203,$1200,$1212,$1205,$1204
stats2r:
	.dw $1204,$1215,$1201,$120C,$1200,$120C,$1201,$1213,$1205,$1212,$1213
stats3r:
	.dw $1236,$1200,$1217,$1205,$1201,$1210,$120F,$120E,$1200,$1202,$1201,$1219
stats1m:
	.dw $123A,$1238,$120D,$1200,$1202,$120C,$1215,$1205
stats2m:
	.dw $1210,$1215,$120C,$1213,$1205,$1200,$120C,$1201,$1213,$1205,$1212
stats3m:
	.dw $1236,$1200,$1205,$120E,$1208,$1201,$120E,$1203,$1205,$1204
stats4m:
	.dw $1217,$1205,$1201,$1210,$120F,$120E,$1200,$1202,$1201,$1219
starsxy:
	.incbin "fstars"
shotspecs:
        ; width height speedv+128 speedh+128 starty+128 startx+128 damage
	.db 0,0,0,0,0,0,0,0    ; null
        .db 8,3,128,136,138,144,1,0    ; machine guns
        .db 32,5,128,160,128,120,3,0   ; red laser
        .db 24,6,128,152,133,120,2,0   ; pulse laser

shotdata:
	; address attributes
	.dw 0,0,0,0              ; null
        .dw $0310,$0082,0,0      ; machine guns
        .dw $0318,$0182,0,0      ; red laser
        .dw $0314,$0182,0,0      ; pulse laser

titlemap:
	.incbin "fk.map"

	.bank 3
	.org $6000

	.incbin "jet1.set"

	.bank 4
	.org $8000

	.incbin "frothigu.set"

	.bank 5
	.org $6000

	.incbin "fspr1.set"
	.incbin "fspr2.set"



