; a slideshow...
;
; a903 is next
;
;RAM map
;
;$2000   vblank (cleared at start of vb)
;$2001-2 controller status
;$2003   slide number!
;
;$2009-A scroll h
;$200B-C scroll v
;
;$2020-2 temp storage for GRB values
;$2023   used within fadepal
;$2024   more misc        (used by fadepal)
;$2025-6 pointer used by fadepal (and misc)
;$2027   more misc        (used by fadepal and windraw)
;
;$20A3   old copy of <$01 for controls
;$20A4   old copy of <$02 for controls
;

	.bank 0
	.org $FFF6

	.dw null_int    ;IRQ2,  used by the BRK instruction
	.dw vb_int      ;IRQ1,  interrupt from the VDC
	.dw null_int    ;TIMER, not used in this demo
	.dw null_int    ;NMI,   never used (or may be by a HuCard!?)
	.dw reset_int   ;RESET, the most important one :)

	.org $E000

        .db "created by DamageX 2006/3/7"
vb_int:
	pha
	phx
	phy
	lda $0000

	lda <$02            
	sta <$A4            ; controller status last frame
	lda <$01            ;
	sta <$A3
	lda #1
	sta $1000
	lda #3
	sta $1000
	lda #1
	sta $1000
	pha
	pla
	nop
	lda $1000
	sta <$02              ; inverse L D R U
	lda #0
	sta $1000
	pha
	pla
	nop
	lda $1000
	sta <$01              ; R S I II

	ply
	plx
	pla
	stz <$00
null_int:
	rti

reset_int:
	sei                   ; disable interrupts 
	csh                   ; select the 7.16 MHz clock
	cld                   ; clear the decimal flag 
	lda #$FF              ; page 0 is i/o
	tam #0
	lda #$F8              ; page 1 is ram
	tam #1
        lda #$01              ; page 2 is rom bank
	tam #2
        lda #$02              ; page 3 is rom bank
	tam #3
        lda #$03              ; page 4 is rom bank
	tam #4
        lda #$04              ; page 5 is rom
	tam #5
        lda #$05              ; page 6 is rom
	tam #6
	stz $C01              ; stop the timer
	stz $2000             ; clear all the RAM
	tii $2000,$2001,$1FFF
	ldx #$FF              ; initialize the stack
	txs
	jsr initvid           ; initialize the video controller

	jsr initpsg           ; and the sound generator
	jsr clearvram         ; duh

        cli

        lda #1
        sta <$03
        jsr displaythegoods

a28:
        jsr waitv

        lda <$A4
        and #15
        cmp #15
        bne a30
        lda <$02
        and #3
        cmp #3
        beq a31
a32:
        inc <$03
        lda #14
        cmp <$03
        beq a33
        jmp changeslides
a31:
        lda <$02
        and #12
        cmp #12
        beq a30
a33:
        dec <$03
        beq a32
        jmp changeslides
a30:

        jmp a28

changeslides:

        lda #252
        ldx <$03
a34:
        clc
        adc #5
        dex
        bne a34
        tam #2
        inc a
        tam #3
        inc a
        tam #4
        inc a
        tam #5
        inc a
        tam #6

        jsr displaythegoods

        jmp a30

displaythegoods:

        jsr fadepal

        st0 #0
        st1 #0
        st2 #$10
        st0 #2
        tia mihoset,$0002,$A000

        lda #LOW(mihomap)
        sta <$05
        lda #HIGH(mihomap)
        sta <$06
        st0 #0
        st1 #0
        st2 #0
        st0 #2
        cly
        lda #28
        sta <$07
a26:
        ldx #44
a25:
        lda [$05],y
        iny
        sta $0002
        lda [$05],y
        sta $0003
        iny
        bne a29
        inc <$06
a29:
        dex
        bne a25
        ldx #20
a27:
        st1 #0
        st2 #0
        dex
        bne a27
        dec <$07
        bne a26

        jsr waitv
        tii mihopal,$3600,$0200
	jsr palette1          ; set palette

        rts

initpsg:
	clx
a170:
	stx $0800
	stz $0804
	inx
	cpx #6
	bne a170
	ldx #$FF
	stx $0801
	rts

initvid:
        clx
a841:
        cly
a848:
        lda vidregs,x
        sta $0000,y
        inx
        iny
        cpy #4
        bne a848
        cpx #44
        bne a841

	ldx #5
	stx $0400             ; color clock 
	rts

palette1:
	tii $3600,$3C00,$0400

a72:
	stz $0402
	stz $0403
	clx
a3:
	lda $3C00,x
	sta $0404
	inx
	lda $3C00,x
	sta $0405
	inx
	bne a3
a4:
	lda $3D00,x
	sta $0404
	inx
	lda $3D00,x
	sta $0405
	inx
	bne a4
a40:
	lda $3E00,x
	sta $0404
	inx
	lda $3E00,x
	sta $0405
	inx
	bne a40
a41:
	lda $3F00,x
	sta $0404
	inx
	lda $3F00,x
	sta $0405
	inx
	bne a41

	rts

fadepal:
        stz <$20
        stz <$21
        stz <$22

        ldy #8
a67:
        phy

        dec <$20
        dec <$21
        dec <$22

        jsr palmod
	jsr waitt
	jsr a72

        ply

        dey
	bne a67
	rts

palmod:

        stz <$24
        lda #$36
        sta <$25

        stz <$E1
        lda #$3C
        sta <$E2

        lda #2
        sta <$27

        stz <$23
        cly
a859:
        lda [$24],y
        sta <$26
        tax
        iny
        lda [$24],y
        asl <$26
        rol a
        asl <$26
        rol a
        clc
        adc <$20
        bpl a860
        cla
a860:
        cmp #8
        bcc a861
        lda #7
a861:
        stz <$26
        lsr a
        ror <$26
        lsr a
        ror <$26
        pha
        txa
        iny
a862:
        and #7
        clc
        adc $2020,y
        bpl a863
        cla
a863:
        cmp #8
        bcc a864
        lda #7
a864:
        dey
        beq a865
        ora <$26
        sta <$26
        txa
        lsr a
        lsr a
        lsr a
        bra a862
a865:
        asl a
        asl a
        asl a
        ora <$26
        sta [$E1]
        inc <$E1
        pla
        sta [$E1]
        inc <$E1
        bne a866
        inc <$25
        inc <$E2
a866:
        lda <$E1
        sta <$24

        dec <$23
        bne a859

        dec <$27
        bne a859

        rts

clearvram:
	st0 #0
	st1 #0
	st2 #0
	st0 #2

	clx
	ldy #128
a2:
	st1 #0
	st2 #0
	dex
	bne a2
	dey
	bne a2

	rts

waitv:
	phy
	ldy #1
	sty <$00
a6:
	ldy <$00
	bne a6
	ply
	rts

waitt:
	ldx #4
a14:
	jsr waitv
	dex
	bne a14
	rts

vidregs:
        .db 5,0,200,0
        .db 7,0,0,0
        .db 8,0,0,0
        .db 9,0,144,0
        .db 10,0,3,3
        .db 11,0,43,6
        .db 12,0,2,23
        .db 13,0,223,0
        .db 14,0,3,0
        .db 15,0,16,0
        .db 19,0,0,127

        .bank 1
        .org $4000
mihopal:
        .incbin "miho1.pal"
mihomap:
        .incbin "miho1.map"
mihoset:
        .incbin "miho1.set"

        .bank 6
        .org $4000
        .incbin "miho2.pal"
        .incbin "miho2.map"
        .incbin "miho2.set"

        .bank 11
        .org $4000
        .incbin "miho3.pal"
        .incbin "miho3.map"
        .incbin "miho3.set"

        .bank 16
        .org $4000
        .incbin "youko.pal"
        .incbin "youko.map"
        .incbin "youko.set"

        .bank 21
        .org $4000
        .incbin "ai.pal"
        .incbin "ai.map"
        .incbin "ai.set"

        .bank 26
        .org $4000
        .incbin "aya.pal"
        .incbin "aya.map"
        .incbin "aya.set"

        .bank 31
        .org $4000
        .incbin "sky.pal"
        .incbin "sky.map"
        .incbin "sky.set"

        .bank 36
        .org $4000
        .incbin "aki.pal"
        .incbin "aki.map"
        .incbin "aki.set"

        .bank 41
        .org $4000
        .incbin "ayaya.pal"
        .incbin "ayaya.map"
        .incbin "ayaya.set"

        .bank 46
        .org $4000
        .incbin "maki.pal"
        .incbin "maki.map"
        .incbin "maki.set"

        .bank 51
        .org $4000
        .incbin "yukie.pal"
        .incbin "yukie.map"
        .incbin "yukie.set"

        .bank 56
        .org $4000
        .incbin "miyuki.pal"
        .incbin "miyuki.map"
        .incbin "miyuki.set"

        .bank 61
        .org $4000
        .incbin "akane.pal"
        .incbin "akane.map"
        .incbin "akane.set"
