' bitmap editor with UI recycled from mbfast

' load 8/15/24bpp BMP, typical JPEG
' save 8/15/24bpp BMP

' WIP:
' some values in colorspace config cause crash/bad behavior
' rotation is not implemented
' multiple palettes are not implemented


#lang "fblite"
option gosub
option explicit

dim shared as integer rh,rv,sh,sv,ix,iy,xc,yc,iyy,newh,newv
dim shared as integer c0,c1,c2,d0,d1,d2,v1,v2,rd,gd,bd,plane
dim shared cpy(0 to 2) as integer

dim shared as ushort s,rstint
dim shared as ubyte cnum,sambits,bbits,bcom,dbuf,ybh,ybv
dim shared as integer bh,bv,m
dim shared as integer bbytes,bho,bvo,blksdone
dim shared cr(1 to 4) as ubyte
dim shared cq(1 to 4) as ubyte
dim shared ced(1 to 8) as ubyte
dim shared olddc(1 to 4) as short
dim shared qtable(0 to 3,0 to 63) as ubyte
dim shared htl(0 to 7,0 to 15) as ubyte
dim shared htable(0 to 7,0 to 2047) as ubyte
dim shared hcode(0 to 7,0 to 2047) as ushort
dim shared blk(0 to 79) as short
dim shared blk2(0 to 63) as short
dim shared blk4(1 to 6,0 to 63) as integer
dim shared filebuf(0 to 4095) as ubyte

dim shared as any ptr scrp
dim shared as integer ptr xptr,yptr,cbp,cbp2,scrp2
dim shared as ushort ptr scrp3
dim shared as ubyte ptr scrp4,bp1
dim shared as single ptr fpp,fpp2
dim shared as double bfps,btimer
dim shared as single scale,scaleold,aspect,aspectold
dim shared as single pi,z1,z2,z3
dim shared as integer swidth,sheight,u,bools1,maxx,maxy
dim shared as integer maxh,maxv,amxold,amyold,bmp1h,bmp1v,maxh2
dim shared as integer c,h,v,hh,vv,x,y,z,xx,yy,zz,mx,my,amx,amy,mw,mb,ff1
dim shared as integer mxold,myold,mwold,mbold,h1,h2,f0,f1,f2,seqnum
dim shared as integer oldmx,oldmy,txtheight,lastalt,i0,i1,i2,i3,dirindex
dim shared as integer renderh,renderv,numbuttons,wid,cdepth,mpindex,imgtype
dim shared as short region,defcol,focusb=-1,focusw=-1
dim shared as ubyte redraw,render,recalc,lc,rc,a,e,nextbox,uitool,abox,notool
dim shared as ubyte message,winmove,mpwin,r,g,b,hidemenu,fillhole,nofile
dim shared aa as string*1
'dim shared pindex(1 to 39) as byte
'dim shared pindex2(1 to 39) as byte
dim shared stats(0 to 29) as integer
dim shared fpval(0 to 29) as single
dim shared blah(0 to 10) as ubyte
dim shared ki as string
dim shared ki2 as string
dim shared fname as string
dim shared sstr as string*4
dim shared wtitle as string*26

dim shared imgspecs(0 to 1) as string*5 => _
{ "*.bmp","*.jpg" }


' UI stuff

dim shared messages(0 to 12) as string*25 => _
{ _
 "                         ", _
 "Canceled.                ", _
 "Error: unrecognized file ", _
 "Error: size is too large ", _
 "Error: JPEG decode error ", _
 "File saved.              ", _
 "File loaded.             ", _
 "Error: not palettized    ", _
 "Model cleared!           ", _
 "Deleted!                 ", _
 "function not implemented ", _
 "Nothing selected!        ", _
 "Screenshot saved.        " _
}

' text colors
dim shared tcol(0 to 15) as integer => _
{ &H000000,&H404040,&H808080,&HC0C0C0,&H000040,&H80C080,&HC08080,&H8080C0, _
  &HC0A080,&HC060C0 }

' h position, v position, width (chars), button ID, window ID, misc
dim shared btlst(0 to 199,0 to 5) as ubyte

dim shared winadrs(0 to 39) as ushort

' window data format
' 1 byte - h position
' 1 byte - v position
' 1 byte - width
' 1 byte - number of buttons
' n bytes - ID of each button
dim shared windata(0 to 999) as ubyte => _
{ _
 2,2,16,1,0, _
 2,4,16,10,14,6,7,8,66,67,5,9,10,11, _                     ' file
 2,4,16,7,14,21,22,23,24,25,27, _                    ' edit
 2,4,16,10,14,15,16,17,18,19,20,58,59,60, _            ' view
 2,4,16,9,14,34,35,36,37,38,39,40,41, _           ' colors
 19,4,16,3,14,26,33, _                            ' rotate
 19,4,16,7,14,9,10,11,31,32,33, _                ' resize
 19,4,16,11,14,57,42,43,44,45,46,47,61,48,49, _      ' color space
 19,4,16,8,14,56,50,51,52,53,54,55, _               ' color palettes
 2,4,16,5,14,62,63,64,65 _                        ' debug
}
dim shared btext(0 to 159) as string*16 => _
{ _
 "                ", _
 "  File          ", _
 "  Edit          ", _
 "  View          ", _
 " Colors         ", _
 " Quit           ", _
 " Open           ", _ 
 " Save           ", _ 
 " save as Bmp 24 ", _
 "current image   ", _
 "width           ", _          ' 10
 "height          ", _
 "                ", _
 "                ", _
 "---- close -----", _
 "aspect          ", _
 "scaling         ", _
 "h offset        ", _
 "v offset        ", _
 "Original size   ", _
 "[_] locK view   ", _          ' 20
 "[_] crop Tool   ", _
 "flip X          ", _
 "flip Y          ", _
 "Benchmark       ", _
 "Rotate image    ", _
 "Angle           ", _
 "reSize image    ", _
 "[_] Lock aspect ", _
 "X scale         ", _
 "Y scale         ", _          ' 30
 "nEw x           ", _
 "neW y           ", _
 "....confirm.....", _
 "[_] adJust color", _
 "Contrast        ", _
 "brigHt          ", _
 "Red add         ", _
 "Green add       ", _
 "Blue add        ", _          
 "color Space     ", _          ' 40
 "color Palette   ", _
 "# of levels for ", _
 " each component ", _
 "Red             ", _
 "Green           ", _
 "Blue            ", _
 "[_] Intensty bit", _
 "[_] Dithering   ", _
 "[_] Floyd/steinb", _
 "Pal size        ", _          ' 50
 "[_] Multipalette", _
 "# of palS       ", _
 "pal zone size   ", _
 "Width           ", _
 "Height          ", _
 "[_] Use palette ", _
 "[_] adJust depth", _
 "Fit to screen   ", _
 "[_] Automatic   ", _
 " resize on load ", _          ' 60
 "[_] greYscale   ", _
 "debug 1         ", _
 "debug 2         ", _
 "debug 3         ", _
 "debug 4         ", _
 " save as bMp 15 ", _
 " save as bmP 8  " _
}

dim shared bwidth(0 to 159) as ubyte => _
{ 16,8,8,8,8,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, _
  16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, _
  16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, _
  16,16,16,16,16,16,16,16 }
' button types
'  0 = does nothing     1 = opens a window
'  2 = check box        3 = misc function
'  4 = shows parameter  5 = modifiable parameter
'  6 = part name        7 = editable part name
dim shared btype(0 to 159) as ubyte => _
{ 0,1,1,1,1,3,3,3,3,0,4,4,0,0,3,4,4,4,4,3, _
  2,2,3,3,3,1,5,1,2,5,5,5,5,3,2,5,5,5,5,5, _
  1,1,0,0,5,5,5,2,2,2,5,2,5,0,5,5,2,2,3,2, _
  0,2,4,4,4,4,3,3 }
dim shared bparam(0 to 159) as ubyte => _
{ 0,1,2,3,4,0,1,2,3,0,0,1,0,0,4,50,51,2,3,5, _
  0,1,6,7,8,5,52,6,2,53,54,4,5,9,3,6,7,8,9,10, _
  7,8,0,0,11,12,13,10,4,5,15,6,16,0,17,18,7,8,10,9, _
  0,11,20,21,22,23,11,12 }
dim shared bkey as string*160 => _
 " fevcqosb     -    o" _
 "ktxybraslxyew.jchrgb" _
 "sp  rgbidfpms whujfa" _
 "y     mp"


' install menu bar
btlst(0,0)=2:btlst(0,1)=2:btlst(0,2)=8:btlst(0,3)=1:btlst(0,4)=0
btlst(1,0)=12:btlst(1,1)=2:btlst(1,2)=8:btlst(1,3)=2:btlst(1,4)=0
btlst(2,0)=22:btlst(2,1)=2:btlst(2,2)=8:btlst(2,3)=3:btlst(2,4)=0
btlst(3,0)=32:btlst(3,1)=2:btlst(3,2)=8:btlst(3,3)=4:btlst(3,4)=0
numbuttons=4

' build an index into window data
x=0:y=0
a99:
winadrs(y)=x:y=y+1
z=windata(x+3)
if z>0 then x=x+4+z:goto a99



' gfx stuff

xx=19:cdepth=32
maxh=4096:maxv=4096
' load settings from .INI
ff1=freefile
open "IMGTOOL.INI" for binary as #ff1
if lof(ff1)=0 then
' write default settings if file didn't exist
print #ff1,"'''' settings file for IMGTOOL"
print #ff1,"''''"
print #ff1,"'''' screen modes:"
print #ff1,"''''"
print #ff1,"''''    13 - 320x200    14 - 320x240    15 - 400x300"
print #ff1,"''''    16 - 512x384    17 - 640x400    18 - 640x480"
print #ff1,"''''    19 - 800x600    20 - 1024x768   21 - 1280x1024"
print #ff1,"''''"
print #ff1,"'''' or specify custom mode with 8 digits eg. 11520864"
print #ff1,"''''"
print #ff1,"mode = 19"
print #ff1,""
print #ff1,"'''' color depth: 8,15,16, or 32"
print #ff1,"''''"
print #ff1,"cdep = 32"
print #ff1,""
print #ff1,"'''' maxh, maxv"
print #ff1,"'''' the maximum dimensions of a bitmap"
print #ff1,"'''' determines how much memory is allocated"
print #ff1,"''''"
print #ff1,"maxh = 4096"
print #ff1,"maxv = 4096"
goto a102
end if
do
get #ff1,,sstr
if sstr="mode" then gosub getnum:xx=x
if sstr="cdep" then gosub getnum:cdepth=x
if sstr="maxh" then gosub getnum:maxh=x
if sstr="maxv" then gosub getnum:maxv=x
do
if eof(ff1) then goto a102
get #ff1,,a
loop until a=10
loop
a102:
close #ff1

'screen 19,8
if xx>21 then
yy=(xx\10000):xx=xx-(yy*10000)
screenres yy,xx,cdepth
if xx>400 then width (yy\8),(xx\16)
else
screen xx,cdepth
end if
scrp=screenptr
screeninfo swidth,sheight,cdepth
txtheight=sheight\hiword(width)
maxx=swidth-1:maxy=sheight-1
maxh2=maxh*4
renderh=0
renderv=0

dim shared cbuf(0 to maxy,0 to maxx) as integer

dim shared lbuf(0 to maxh*3) as ubyte
dim shared lbuf2(0 to maxv*3) as ubyte
dim shared bmp1(0 to maxv-1,0 to maxh-1,0 to 3) as ubyte
dim shared bmp2(0 to maxv-1,0 to maxh-1,0 to 3) as ubyte
dim shared bpal(0 to 262143) as integer
dim shared ccount(0 to 262143) as integer
dim shared bcount(0 to 262143) as integer

cbp=@cbuf(0,0)

if cdepth=8 then
for x=0 to 255
palette x,(x\64)*85,((x and 60) shr 2)*17,(x and 3)*85
next x
for x=0 to 15
tcol(x)=((tcol(x) and &HC00000) shr 16)+((tcol(x) and &HF000) shr 10)+((tcol(x) and 255) shr 6)
next x
end if


dim shared zigzag(0 to 63) as ubyte => _
{ 0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5, _
  12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28, _
  35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51, _
  58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63 }

dim shared itable(0 to 4095) as integer

pi=3.1415926

' build a lookup table to speed up iDCT later
zz=0
for y=0 to 7
for x=0 to 7
z1=1
if x=0 then z1=z1*.707107
if y=0 then z1=z1*.707107
for yy=0 to 7
for xx=0 to 7
z2=z1*cos(pi*x*((xx*2)+1)/16)*cos(pi*y*((yy*2)+1)/16)
itable(zz)=(z2*65536)
zz+=1
next xx
next yy
next x
next y

scale=1:aspect=1
recalc=1
bools1=512
uitool=0
hidemenu=0

' default color space settings
stats(11)=256:stats(12)=256:stats(13)=256:stats(14)=0
stats(15)=256

'ff1=freefile
'open "debugm.txt" for output as #ff1

fname="default.bmp"

if command$<>"" then ki2=command$:gosub openfile2


uistart:

nofile=0
if bmp1h<1 then nofile=1
if bmp1v<1 then nofile=1

if recalc=1 then
if nofile=0 then 
for v=0 to bmp1v-1
xptr=@bmp1(v,0,0):yptr=@bmp2(v,0,0)
for h=0 to bmp1h-1
*yptr=*xptr
xptr+=1:yptr+=1
next h
next v
if (bools1 and 8) then gosub coloradj
if (bools1 and 256) then gosub colorspace
if (bools1 and 128) then gosub palettes
end if
recalc=0
render=1
end if

if render>0 then
if nofile=0 then
if renderh>maxx then renderh=maxx
if renderv>maxy then renderv=maxy
if (bools1 and 512) then if message=6 then gosub fitscreen
newh=bmp1h*scale*aspect
newv=bmp1v*scale
if renderh+newh<1 then renderh=1-newh
if renderv+newv<1 then renderv=1-newv
bp1=@bmp1(0,0,0)
if (bools1 and &H188)>0 then bp1=@bmp2(0,0,0)

if render=2 then
' fast scrolling
if renderh<>stats(2) then gosub scrollh
if renderv<>stats(3) then gosub scrollv
end if

stats(2)=renderh:stats(3)=renderv

if render=1 then
clear cbuf(0,0),0,(swidth*sheight*4)
gosub definearea
gosub resizex
end if

end if
render=0
redraw=1
end if


if redraw=1 then
stats(0)=bmp1h:stats(1)=bmp1v
fpval(0)=aspect:fpval(1)=scale

screenlock
gosub copybuffer
if hidemenu=0 then
gosub showgui
color tcol(5),tcol(0)
if message>0 then locate 23,1,0:? messages(message);
end if
screenunlock
message=0
redraw=0
end if

a18:

gosub readmouse

ki=inkey$

' benchmark mode
if uitool=5 then
render=1
if timer>btimer+4 then btimer=timer:bfps=0
if rc=2 then uitool=0
if ki<>"" then uitool=0
ki2=fname:gosub openfile2:recalc=1
goto uistart
end if

' check whether ALT has been pressed (pain in the ass)
x=multikey(56)
if x=0 then goto a100
if lastalt<>0 then goto a100
redraw=1:focusb=-1
if focusw<>0 then focusw=0:goto a100
focusw=-1
a100:
lastalt=x:if redraw=1 then goto uistart

if ki<>"" then goto a54
if oldmx<>mx then goto a54
if oldmy<>my then goto a54
if mbold<>mb then goto a54
if mwold<>mw then goto a54

sleep 40
goto a18

a54:

if ki=chr$(255)+chr$(59) then
' function key reminder 
color tcol(0),tcol(1)
locate 5,6,0:? space$(28)
for x=6 to 17:locate x,6,0:? " ":locate x,33,0:? " ":next x
locate 18,6,0:? space$(28)
color tcol(0),tcol(2)
locate  6,7,0:? " F1 (this reminder)       "
locate  7,7,0:? " F2 fit-to-screen         "
locate  8,7,0:? " F3 previous file         "
locate  9,7,0:? " F4 next file             "
locate 10,7,0:? "                          "
locate 11,7,0:? " F11 hide menus           "
locate 12,7,0:? " ALT access menu bar      "
locate 13,7,0:? " arrows navigate menus or "
locate 14,7,0:? "  scroll image            "
locate 15,7,0:? " TAB cycle active menu    "
locate 16,7,0:? " PGUP/PGDN/HOME/END       "
locate 17,7,0:? "  pixel aspect/zoom       "
sleep
ki=inkey$
redraw=1
goto uistart
end if

if ki=chr$(255)+chr$(60) then gosub fitscreen

if ki=chr$(255)+chr$(61) then
' previous file
gosub dirscanname
a184:
if dirindex>0 then
dirindex=dirindex-1
gosub dirscannumber
gosub openfile2
if message=2 then goto a184
recalc=1:goto uistart
end if
end if

if ki=chr$(255)+chr$(62) then
' next file
gosub dirscanname
a185:
dirindex=dirindex+1
gosub dirscannumber
if ki2<>"" then
gosub openfile2
if message=2 then goto a185
recalc=1:goto uistart
end if
end if

'if ki=chr$(255)+chr$(63) then f2=23:goto openwin

if ki=chr$(255)+chr$(133) then hidemenu=1-hidemenu:redraw=1

' debug window
stats(20)=focusw:stats(21)=focusb:stats(22)=bools1
if ki=chr$(255)+chr$(134) then f2=9:goto openwin

if ki=chr$(255)+"k" then end
if ki=chr$(255)+"a" then if focusw>0 then wid=focusw:gosub removewin:goto a72

' arrow keys menu navigation
if focusw=0 then
if ki=chr$(255)+chr$(80) then z=focusb:goto a154
if ki=chr$(255)+chr$(75) then redraw=1:focusb=focusb-1
if ki=chr$(255)+chr$(77) then redraw=1:focusb+=1
if focusb<0 then focusb=3
if focusb>3 then focusb=0
end if
if focusw>0 then
x=0
if ki=chr$(255)+chr$(72) then x=-1
if ki=chr$(255)+chr$(80) then x=1
if x<>0 then
do
focusb+=x
if focusb<0 then focusb=numbuttons-1
if focusb>numbuttons-1 then focusb=0
loop until btlst(focusb,4)=focusw
redraw=1
end if
end if

' TAB changes window focus
if focusw<>0 then
if ki=chr$(9) then
if focusw=-1 then focusw=0
x=1000
for z=0 to numbuttons-1
if btlst(z,4)>focusw then if btlst(z,4)<x then x=btlst(z,4)
next z
focusw=x:if focusw=1000 then focusw=-1
a155:
focusb=-1:redraw=1
end if
end if

if redraw=1 then goto skipmouselook

if ki=chr$(13) then if focusb<>-1 then z=focusb:goto a154


' check for menu-related keyboard shortcuts
if ki="" then goto a90
if ki=" " then goto a90
a118:
for z=0 to numbuttons-1
if btlst(z,4)=focusw then
xx=btlst(z,3)
if mid$(bkey,xx+1,1)=ki then goto a154
end if
next z
a90:


if (mb and 1)=0 then notool=0

' arrow key image zoom/scroll
if (bools1 and 1)=0 then
if focusw=-1 then
z=8
if multikey(&H2A) then z=64
if multikey(&H36) then z=64
if ki=chr$(255)+chr$(80) then renderv=renderv-z:render=2
if ki=chr$(255)+chr$(77) then renderh=renderh-z:render=2
if ki=chr$(255)+chr$(75) then renderh+=z:render=2
if ki=chr$(255)+chr$(72) then renderv+=z:render=2
' PGUP/PGDN aspect
if ki=chr$(255)+chr$(73) then aspect=aspect*.95:render=1
if ki=chr$(255)+chr$(81) then aspect=aspect*1.05:render=1
' HOME/END scaling
if ki=chr$(255)+chr$(71) then scale=scale*.95:render=1
if ki=chr$(255)+chr$(79) then scale=scale*1.05:render=1
if render>0 then goto a89
end if                        
end if

' right-click-and-drag window movement
if (mb and 2)=0 then winmove=0:goto a158
if winmove>0 then
x=(amx-amxold)\8:y=(amy-amyold)\txtheight
if ((x<>0) or (y<>0)) then
' need to make a test pass to ensure buttons won't go off screen
for z=0 to numbuttons-1
if btlst(z,4)=winmove then
xx=btlst(z,0):yy=btlst(z,1)
if x+xx<1 then x=1-xx
if x+xx+btlst(z,2)>loword(width) then x=loword(width)-xx-btlst(z,2)
if y+yy<1 then y=1-yy
if y+yy+1>hiword(width) then y=hiword(width)-yy-1
end if
next z
for z=0 to numbuttons-1
if btlst(z,4)=winmove then btlst(z,0)+=x:btlst(z,1)+=y
next z
amxold+=x*8:amyold+=y*txtheight
redraw=1
end if
goto a79
end if
if rc=2 then
gosub searchbutton
if z=-1 then goto a158
y=btlst(z,4)
if y>0 then winmove=y:goto skipmouselook
end if
a158:

' check for left-click in UI button
if lc=1 then
gosub searchbutton
if z=-1 then goto a89
notool=1
a154:
' button was clicked, do stuff?
xx=btlst(z,3):wid=btlst(z,4)
yy=btype(xx)


if yy=1 then
' open a new window?
f2=bparam(xx)
openwin:
' check whether window already exists, if so change focus but do not reopen
for z=0 to numbuttons-1
if btlst(z,4)=f2 then focusw=f2:focusb=z:goto a72
next z
x=winadrs(f2)
h=windata(x):v=windata(x+1)
if focusw<>-1 then focusw=0
' check for existing window in same spot
'if numbuttons>0 then
for y=0 to numbuttons-1
if btlst(y,0)<>h then goto a76
if btlst(y,1)<>v then goto a76
wid=btlst(y,4):gosub removewin
a76:
next y
'end if
if focusw=0 then focusw=f2:focusb=-1
' add all buttons specified in the window data to button list
for y=x+4 to x+3+windata(x+3)
f1=windata(y)
btlst(numbuttons,0)=h
btlst(numbuttons,1)=v
btlst(numbuttons,2)=bwidth(f1)
btlst(numbuttons,3)=f1
btlst(numbuttons,4)=f2
numbuttons+=1
v+=1
next y
goto a72
end if


if yy=2 then
' check box
f1=bparam(xx)
h1=1
if f1>0 then
for f2=1 to f1
h1=h1+h1
next f2
end if
bools1=(bools1 xor h1)
if (bools1 and 8192) then uitool=6
recalc=1
goto skipmouselook
end if


if yy=3 then
' misc functions
f1=bparam(xx)
if f1=0 then end
if f1=1 then gosub openfile:recalc=1:goto skipmouselook
if f1=2 then i1=24:gosub savefile:goto a72
if f1=3 then i1=24:gosub saveasfile:goto a72
if f1=4 then gosub removewin:goto a72

if f1=5 then aspect=1:scale=1:render=1:goto skipmouselook

if f1=6 then
' flip X
for v=0 to bmp1v-1
x=0
for h=0 to bmp1h-1
lbuf(x)=bmp1(v,h,0):lbuf(x+1)=bmp1(v,h,1):lbuf(x+2)=bmp1(v,h,2):x+=3
next h
for h=0 to bmp1h-1
x=x-3:bmp1(v,h,0)=lbuf(x):bmp1(v,h,1)=lbuf(x+1):bmp1(v,h,2)=lbuf(x+2)
next h
next v
recalc=1:goto skipmouselook
end if

if f1=7 then
' flip Y
for h=0 to bmp1h-1
x=0
for v=0 to bmp1v-1
lbuf2(x)=bmp1(v,h,0):lbuf2(x+1)=bmp1(v,h,1):lbuf2(x+2)=bmp1(v,h,2):x+=3
next v
for v=0 to bmp1v-1
x=x-3:bmp1(v,h,0)=lbuf2(x):bmp1(v,h,1)=lbuf2(x+1):bmp1(v,h,2)=lbuf2(x+2)
next v
next h
recalc=1:goto skipmouselook
end if

if f1=8 then btimer=timer:bfps=0:uitool=5:recalc=1:goto skipmouselook
' benchmark mode

if f1=9 then
' "confirm" ...

if wid=6 then
' resize image
newh=stats(4):newv=stats(5)
if newh>maxh then message=3:goto a72
if newv>maxv then message=3:goto a72

for v=0 to bmp1v-1
for h=0 to bmp1h-1
bmp2(v,h,0)=bmp1(v,h,0)
bmp2(v,h,1)=bmp1(v,h,1)
bmp2(v,h,2)=bmp1(v,h,2)
next h
next v

bp1=@bmp2(0,0,0)

h1=0:v1=0:h2=newh-1:v2=newv-1

render=0:gosub resizex

bmp1h=newh:bmp1v=newv
recalc=1:goto skipmouselook
end if

end if

if f1=10 then gosub fitscreen:goto skipmouselook

if f1=11 then i1=16:gosub saveasfile:goto a72
if f1=12 then
if (bools1 and 128)=0 then message=7:goto a72
i1=8:gosub saveasfile:goto a72
end if

if f1=38 then
end if

end if


if yy=5 then
' modifiable value

' should we go to mouse plot mode?
'if (bools1 and 128) then
'h1=bparam(xx)
'if h1=13 then mpindex=-1:goto a165
'if h1=14 then mpindex=-1:goto a165
'if h1<50 then goto a103
'if h1<53 then mpindex=0:goto a165
'if h1<56 then mpindex=3:goto a165
'if h1<59 then mpindex=6:goto a165
'if h1<62 then
'mpindex=9
'a165:
'mpwin=wid:uitool=1:redraw=1
'goto skipmouselook
'end if
'a103:
'end if

color tcol(3),tcol(4)
a86:
f1=btlst(z,0)+btlst(z,2)-7
y=btlst(z,1)
locate y,f1,0:? "_      "
z1=0:a=0:f2=8:nextbox=0:z3=1
a84:
gosub readmouse
if lc=1 then goto a85
ki2=inkey$
if ki2="" then sleep 30:goto a84
if ki2=chr$(13) then goto a85
locate y,f1+a,0
if ((asc(ki2)>47) and (asc(ki2)<58)) then z1=(z1*10)+(asc(ki2)-48):a+=1:? ki2
if ki2="." then a+=1:? ki2:f2=a
if ki2="-" then a+=1:? ki2:z3=-1
if ki2=chr$(27) then goto a72            ' ESCape key
if ki2=chr$(9) then nextbox=1:goto a85 ' TAB key
if a<7 then goto a84                      

a85:
if f2<a then z1=z1/10:f2+=1:goto a85
h1=bparam(xx)
if h1>49 then fpval(h1-50)=z1*z3:if h1=66 then render=1
if h1<50 then stats(h1)=z1*z3
if nextbox=1 then
' continue data entry in next Type 5 button (if any)
if z=numbuttons-1 then goto a72
zz=z
for z=zz+1 to numbuttons-1
xx=btlst(z,3)
if btype(xx)=5 then goto a86
next z
end if

recalc=1:goto skipmouselook
end if



a72:
redraw=1

a89:
end if

' done with menu processing, now mouse tools

if notool=1 then goto skipmouselook


' selection
if uitool=2 then
if rc=2 then redraw=1
if (mb and 2) then goto skipmouselook
if lc=1 then abox=1
if (mb and 1) then redraw=1:goto a79

if (((mb and 1)=0) and (abox=1)) then
' button was released -- let's see what was selected
if mxold>mx then swap mxold,mx
if myold>my then swap myold,my

'for y=myold to my
'for x=mxold to mx
'cbuf(y,x)=maxtris
'next x
'next y

render=1
end if

goto skipmouselook
end if


' mouse plot
if uitool=1 then
' leave mouse plot mode if mouseplot check box button ceases to exist
for x=0 to numbuttons-1
if btlst(x,3)=58 then goto a127
next x
uitool=0:goto a128
a127:

if lc=1 then ki=".":lc=0:focusw=mpwin:focusb=-1:goto a118
if rc=2 then uitool=0
if (bools1 and 128)=0 then uitool=0
a128:
redraw=1
goto skipmouselook
end if


' mouselook
a123:
if (bools1 and 1)=0 then
if (mb and 3)=3 then
aspect=aspectold+(mx-mxold)/swidth:if aspect<.1 then aspect=.1
if aspect<>aspectold then render=1
goto skipmouselook
end if
if (mb and 1) then
renderh=renderh+(mx-mxold)*2
renderv=renderv+(my-myold)*2
render=2
end if
if (mb and 2) then
scale=scaleold+(mx-mxold)/swidth:if scale<.01 then scale=.01
if scale<>scaleold then render=1
end if
end if

skipmouselook:

abox=0
mxold=mx:myold=my
amxold=amx:amyold=amy
scaleold=scale
aspectold=aspect
a79:

goto uistart




copybuffer:
scrp2=scrp
scrp3=scrp
scrp4=scrp
cbp2=cbp

if cdepth>16 then
'for v=0 to maxy
'for h=0 to maxx
'*scrp2=*cbp2
'scrp2+=1
'cbp2+=1
'next h
'next v
asm
cld
mov esi,dword ptr [cbp]
mov edi,dword ptr [scrp]
mov eax,dword ptr [swidth]
mul dword ptr [sheight]
mov ecx,eax
rep movsd
end asm
end if

if cdepth=16 then
'for v=0 to maxy
'for h=0 to maxx
'*scrp3=((*cbp2 shr 8) and &HF800)+((*cbp2 shr 5) and &H07E0)+((*cbp2 shr 3) and 31)
'scrp3+=1
'cbp2+=1
'next h
'next v
asm
cld
mov esi,dword ptr [cbp]
mov edi,dword ptr [scrp]
mov eax,dword ptr [swidth]
mul dword ptr [sheight]
mov ecx,eax
a124:
lodsd
mov ebx,eax
mov edx,0x1F
shr ebx,3
and edx,ebx
mov eax,0x7E0
shr ebx,2
and eax,ebx
add edx,eax
shr ebx,3
mov eax,0xF800
and eax,ebx
add eax,edx
stosw
sub ecx,1
jnz a124
end asm
end if

if cdepth=15 then
'for v=0 to maxy
'for h=0 to maxx
'*scrp3=((*cbp2 shr 9) and &H7C00)+((*cbp2 shr 6) and &H03E0)+((*cbp2 shr 3) and 31)
'scrp3+=1
'cbp2+=1
'next h
'next v
asm
cld
mov esi,dword ptr [cbp]
mov edi,dword ptr [scrp]
mov eax,dword ptr [swidth]
mul dword ptr [sheight]
mov ecx,eax
a125:
lodsd
mov ebx,eax
mov edx,0x1F
shr ebx,3
and edx,ebx
mov eax,0x3E0
shr ebx,3
and eax,ebx
add edx,eax
shr ebx,3
mov eax,0x7C00
and eax,ebx
add eax,edx
stosw
sub ecx,1
jnz a125
end asm
end if

if cdepth=8 then
'for v=0 to maxy
'for h=0 to maxx
'*scrp4=((*cbp2 shr 16) and 192)+((*cbp2 shr 10) and 60)+((*cbp2 shr 6) and 3)
'scrp4+=1
'cbp2+=1
'next h
'next v
asm
cld
mov esi,dword ptr [cbp]
mov edi,dword ptr [scrp]
mov eax,dword ptr [swidth]
mul dword ptr [sheight]
mov ecx,eax
a126:
lodsd
mov ebx,eax
mov edx,0x03
shr ebx,6
and edx,ebx
mov eax,0x3C
shr ebx,4
and eax,ebx
add edx,eax
shr ebx,6
mov eax,0xC0
and eax,ebx
add eax,edx
stosb
sub ecx,1
jnz a126
end asm
end if

return




showgui:

'for x=1 to 30
'pindex2(x)=pindex(x)
'next x

if uitool=2 then uitool=0
if uitool=0 then
if (bools1 and 512) then
for z=0 to numbuttons-1
if btlst(z,4)=10 then
uitool=2
line (amxold,amyold)-(amx,amyold),&HFF00FF
line (amx,amyold)-(amx,amy),&HFF00FF
line (amx,amy)-(amxold,amy),&HFF00FF
line (amxold,amy)-(amxold,amyold),&HFF00FF
goto a104
end if
next z
end if
a104:
end if


color tcol(5),tcol(0)
locate 1,3,0:? "current file: ";mid$(fname,1,24)
locate 3,3,0    ':? "tool: ";
'if uitool=0 then ? "mouselook"
'if uitool=1 then ? "mouse plot (R-click to end)"
'if uitool=2 then ? "selection"
'if uitool=3 then ? "autotriangle (R-click to end)"
'if uitool=4 then ? "manualtriangle (R-click to end)"
if uitool=5 then bfps+=1:if timer>btimer then ? "FPS (R-click to end) ";bfps/(timer-btimer)
'if uitool=6 then ? "vertex edit"


' if we changed windows, go to the first button in the window
if ((focusw>-1) and (focusb=-1)) then
for z=0 to numbuttons-1
if btlst(z,4)=focusw then focusb=z:goto a152
next z
focusw=-1       ' non-existent window?
a152:
end if


' draw buttons
'if numbuttons>0 then
for z=0 to numbuttons-1
x=btlst(z,0):y=btlst(z,1)
xx=btlst(z,2):yy=btlst(z,3)

c=tcol(0):c2=tcol(2)
if btype(yy)=1 then c2=tcol(7)
if btype(yy)=2 then c2=tcol(5)
if btype(yy)=3 then c2=tcol(6)
if btype(yy)=6 then c2=tcol(9)
if btype(yy)=7 then c2=tcol(8)

if focusb=z then
c=tcol(3)
h1=(x shl 3)-9:h2=h1+(xx shl 3)+1
v=(y-1)*txtheight:vv=v+txtheight-1
for h=1 to 4
line (h1,v)-(h1,vv),c
line (h2,v)-(h2,vv),c
h1=h1-1:h2+=1:v+=1:vv=vv-1
next h
end if

color c,c2

locate y,x,0
? mid$(btext(yy),1,xx)

if btype(yy)=2 then
' show checkbox state
f1=bparam(yy)
h1=1
if f1>0 then
for f2=1 to f1
h1=h1+h1
next f2
end if
if (bools1 and h1) then locate y,x+1,0:? "X"
goto a80
end if


if ((btype(yy)=4) or (btype(yy)=5)) then
if btype(yy)=5 then color tcol(3),tcol(4)

' display a numeric value...
i1=bparam(yy):z2=10000000:h1=0
if i1<50 then
z1=stats(i1)
else
z1=fpval(i1-50)
end if
if z1<0 then z1=abs(z1):z2=1000000:h1=1:blah(0)=asc("-")

if z1>=z2 then locate y,x+9,0:? "big num":goto a80

' compute digits
i2=0
a156:
if z2=1 then
if z1=0 then goto a75
blah(h1)=asc("."):i2=1:h1+=1:if h1=7 then goto a75
end if
z2=z2/10:if z1>=z2 then i2=1
if i2=0 then goto a156
i3=0
a157:
if z1>=z2 then z1=z1-z2:i3+=1:goto a157
blah(h1)=48+i3:h1+=1:if h1=7 then goto a75
goto a156
a75:
if i2=0 then blah(h1)=48:h1+=1

' write digits to screen
x=x+xx
for i2=0 to 6
x=x-1:a=32
if h1>0 then h1=h1-1:a=blah(h1)
locate y,x,0:? chr$(a)
next i2
goto a80
end if


'if ((btype(yy)=6) or (btype(yy)=7)) then
' display part name and number
'e=pindex2(btlst(z,4))
'a=e\10
'locate y,x+1,0
'? chr$(48+a);chr$(48+e-(a*10));" ";partnames(e)
'btlst(z,5)=e
'e+=1:if e=100 then e=0
'pindex2(btlst(z,4))=e
'goto a80
'end if


a80:

next z
'end if

return



openfile:
wtitle="  OPEN  - enter filename  "
gosub stringentry
if ki2="" then message=1:return

openfile2:
ff1=freefile
open ki2 for binary as #ff1

get #ff1,,s
if s=&H4D42 then goto bmpload
if s=&HD8FF then goto startparse

message=2:goto a122

bmpload:

x=19:get #ff1,x,bmp1h
x=23:get #ff1,x,bmp1v

if bmp1h>maxh then message=3:goto a122
if bmp1v>maxv then message=3:goto a122

fname=ki2

get #ff1,,s:get #ff1,,s
yy=55

if s=8 then
' 8-bit BMP
for x=0 to 255
get #ff1,yy,bpal(x):yy+=4
next x

for y=bmp1v-1 to 0 step -1
get #ff1,,lbuf(0),bmp1h
for x=0 to bmp1h-1
z=lbuf(x)
bmp1(y,x,0)=(bpal(z) and 255)
bmp1(y,x,1)=((bpal(z) shr 8) and 255)
bmp1(y,x,2)=(bpal(z) shr 16)
next x
next y

goto a224
end if

if s=16 then
' 16-bit BMP
xx=bmp1h+bmp1h

for y=bmp1v-1 to 0 step -1
get #ff1,yy,lbuf(0),xx
yy+=xx
z=0
for x=0 to bmp1h-1
zz=lbuf(z)+(lbuf(z+1) shl 8)
bmp1(y,x,0)=((zz and 31) shl 3)
bmp1(y,x,1)=((zz and 992) shr 2)
bmp1(y,x,2)=((zz and 31744) shr 7)
z+=2
next x
next y

goto a224
end if

' 24-bit BMP
xx=(((bmp1h*3)+3) and 32764)

for y=bmp1v-1 to 0 step -1
get #ff1,yy,lbuf(0),bmp1h*3
yy+=xx
z=0
for x=0 to bmp1h-1
bmp1(y,x,0)=lbuf(z)
bmp1(y,x,1)=lbuf(z+1)
bmp1(y,x,2)=lbuf(z+2)
z+=3
next x
next y

a224:
message=6
a122:
close #ff1
return


removewin:
' close a window (remove all of its buttons)
if wid=focusw then focusw=-1:focusb=-1
i1=0

a74:
if i1=numbuttons then return
if btlst(i1,4)<>wid then i1+=1:goto a74

numbuttons=numbuttons-1
'if numbuttons>i1 then
for i2=i1 to numbuttons-1
btlst(i2,0)=btlst(i2+1,0)
btlst(i2,1)=btlst(i2+1,1)
btlst(i2,2)=btlst(i2+1,2)
btlst(i2,3)=btlst(i2+1,3)
btlst(i2,4)=btlst(i2+1,4)
btlst(i2,5)=btlst(i2+1,5)
next i2
'end if
goto a74


savefile:

if i1=24 then zz=(((bmp1h*3)+3) and &HFFFC)
if i1=16 then zz=bmp1h+bmp1h
if i1=8 then zz=bmp1h
xx=zz*bmp1v

ff1=freefile
open fname for binary as #ff1
if lof(ff1)>0 then close #ff1:kill fname:OPEN fname FOR BINARY AS #ff1

' write BMP header
y=0:if i1=8 then y=1024
aa = "B": PUT #ff1, , aa
aa = "M": PUT #ff1, , aa
x=xx+54+y:PUT #ff1, , x                   ' file length
x=0: PUT #ff1, , x                      ' reserved
x=54+y:PUT #ff1, , x                   ' offset where bitmap starts in file
x=40: PUT #ff1, , x                     ' subheader length
PUT #ff1, , bmp1h
PUT #ff1, , bmp1v
s = 1: PUT #ff1, , s                      ' "color planes" set to 1
s = i1: PUT #ff1, , s                      ' bits per pixel
x = 0: PUT #ff1, , x                      ' compression method (none)
PUT #ff1, , xx                          ' size of naked bitmap
x = &HEC4: PUT #ff1, , x: PUT #ff1, , x     ' pixels per meter H/V
x = 0: PUT #ff1, , x                      ' colors in palette (0=determined by bitdepth)
x = 0: PUT #ff1, , x                      ' number of "important" colors

if i1=8 then            ' write palette for 8-bit BMPs
a=0
for z=0 to 255
b=((bpal(z) and 63) shl 2)
g=((bpal(z) shr 4) and 252)
r=((bpal(z) shr 10) and 252)
put #ff1,,r:put #ff1,,g:put #ff1,,b:put #ff1,,a
next z
end if


for y=bmp1v-1 to 0 step -1
z=0

if i1=24 then
for x=0 to bmp1h-1
if (bools1 and &H188)>0 then
lbuf(z)=bmp2(y,x,0):lbuf(z+1)=bmp2(y,x,1):lbuf(z+2)=bmp2(y,x,2)
else
lbuf(z)=bmp1(y,x,0):lbuf(z+1)=bmp1(y,x,1):lbuf(z+2)=bmp1(y,x,2)
end if
z+=3
next x
end if
if i1=16 then
for x=0 to bmp1h-1
if (bools1 and &H188)>0 then
lbuf(z)=(bmp2(y,x,0) shr 3)+((bmp2(y,x,1) shl 2) and 224)
lbuf(z+1)=(bmp2(y,x,1) shr 6)+((bmp2(y,x,2) shr 1) and 124)
else
lbuf(z)=(bmp1(y,x,0) shr 3)+((bmp1(y,x,1) shl 2) and 224)
lbuf(z+1)=(bmp1(y,x,1) shr 6)+((bmp1(y,x,2) shr 1) and 124)
end if
z+=2
next x
end if
if i1=8 then
c=stats(15):if c>256 then c=256
for x=0 to bmp1h-1
yy=((bmp2(y,x,0) shr 2) shl 12)+((bmp2(y,x,1) shr 2) shl 6)+(bmp2(y,x,2) shr 2)
for z=0 to c-1
if bpal(z)=yy then goto a232
next z
a232:
lbuf(x)=z
next x
end if

put #ff1,,lbuf(0),zz
next y

close #ff1
message=5
return


saveasfile:
wtitle="  SAVE  - enter filename  "
gosub stringentry
if ki2="" then message=1:return
fname=ki2
goto savefile



stringentry:
color tcol(0),tcol(2)
locate 7,7,0:? wtitle
locate 8,7,0:? space$(26)
locate 9,7,0:? space$(26)
color tcol(0),tcol(1)
locate 6,6,0:? space$(28)
locate 7,6,0:? " ":locate 7,33,0:? " "
locate 8,6,0:? " ":locate 8,33,0:? " "
locate 9,6,0:? " ":locate 9,33,0:? " "
locate 10,6,0:? space$(28)
color tcol(3),tcol(4)
locate 8,8,0:? space$(24)
locate 8,8,0:input ki2
return



readmouse:
mbold=mb:mwold=mw
oldmx=mx:oldmy=my
x=getmouse(amx,amy,mw,mb)
mx=amx:my=amy
lc=0:rc=0
if mb=-1 then mb=0
if (mbold and 1)=0 then lc=(mb and 1)
if (mbold and 2)=0 then rc=(mb and 2)
if mx<0 then mx=0
if my<0 then my=0
if mx>maxx then mx=maxx
if my>maxy then my=maxy
return


getnum:
x=0:y=0
a101:
if eof(ff1) then return
get #ff1,,a
if a=13 then return
if ((a>47) and (a<58)) then x=(x*10)+(a-48):y=y+1:goto a101
if y=0 then goto a101
return



searchbutton:
for z=0 to numbuttons-1
x=(btlst(z,0) shl 3)-8:y=(btlst(z,1)-1)*txtheight
if amx<x then goto a71
if amy<y then goto a71
if amy>=y+txtheight then goto a71
if amx>x+(btlst(z,2) shl 3) then goto a71
region=-1:if amx>x+(btlst(z,2) shl 2) then region=1
return
a71:
next z
z=-1
return


definearea:
h1=0-stats(2):if h1<0 then h1=0
v1=0-stats(3):if v1<0 then v1=0
h2=maxx-stats(2):if h2>newh-1 then h2=newh-1
v2=maxy-stats(3):if v2>newv-1 then v2=newv-1
return


resizex:
if newh<2 then return
if newv<2 then return

rh=bmp1h*512\newh
rv=bmp1v*512\newv
sh=newh*512\bmp1h
sv=newv*512\bmp1v

for y=v1 to v2

yc=(y+1)*rv

if render=0 then
xptr=@bmp1(y,0,0)
else
xptr=@cbuf(y+stats(3),stats(2)+h1)
'scrp2=scrp
'xptr=scrp2+((y+stats(3))*swidth)+(h1+stats(2))
end if

'for x=h1 to h2

'iy=y*rv
'd0=0:d1=0:d2=0
'xc=(x+1)*rh

'a21:
'ix=x*rh
'c0=0:c1=0:c2=0
'a20:
'i2=bmp1((iy shr 9),(ix shr 9),0)
'i1=bmp1((iy shr 9),(ix shr 9),1)
'i0=bmp1((iy shr 9),(ix shr 9),2)
'if (ix and &HFFFFFE00)=(xc and &HFFFFFE00) then
'z=((xc-ix) and 511)
'ix=ix+rh
'else
'z=(512-(ix and 511))
'ix=ix+z
'end if
'c0+=i0*z:c1+=i1*z:c2+=i2*z
'if ix<xc then goto a20

asm
        push ebp
        cld
        mov eax,dword ptr [h1]
        mov dword ptr [x],eax
        mov edi,dword ptr [xptr]
a228:
        mov eax,dword ptr [y]
        imul eax,dword ptr [rv]
        mov dword ptr [iy],eax

        mov ebx,dword ptr [x]
        mov ecx,dword ptr [rh]
        imul ebx,ecx
        mov dword ptr [ix],ebx
        add ecx,ebx
        mov dword ptr [xc],ecx

        xor eax,eax
        mov dword ptr [d0],eax
        mov dword ptr [d1],eax
        mov dword ptr [d2],eax
a227:
        xor eax,eax
        mov dword ptr [c0],eax
        mov dword ptr [c1],eax
        mov dword ptr [c2],eax
        mov edx,dword ptr [ix]
        mov ebx,dword ptr [iy]
        shr ebx,9
        imul ebx,dword ptr [maxh2]
        add ebx,dword ptr [bp1]
        mov esi,ebx
a166:
        mov ebx,edx
        shr ebx,9
        shl ebx,2
        mov ebp,dword ptr [esi+ebx]

        mov ecx,dword ptr [xc]
        mov ebx,0xFFFFFE00
        mov eax,ecx
        and ecx,ebx
        and ebx,edx
        cmp ecx,ebx
        jne a167
        sub eax,edx
        add edx,512
        and eax,511
        jmp a168
a167:
        mov ecx,edx
        mov eax,512
        and ecx,511
        sub eax,ecx
        add edx,eax
a168:
        mov ecx,ebp
        movzx ebx,cl
        imul ebx,eax
        add dword ptr [c2],ebx
        movzx ebx,ch
        imul ebx,eax
        shr ecx,16
        add dword ptr [c1],ebx
        imul ecx,eax
        add dword ptr [c0],ecx
        cmp edx,dword ptr [xc]
        jl a166

        mov ebx,dword ptr [sh]
        mov eax,dword ptr [c0]
        imul eax,ebx
        shr eax,18
        mov dword ptr [c0],eax
        mov eax,dword ptr [c1]
        imul eax,ebx
        shr eax,18
        mov dword ptr [c1],eax
        mov eax,dword ptr [c2]
        imul eax,ebx
        shr eax,18
        mov dword ptr [c2],eax

        mov ebx,0xFFFFFE00
        mov eax,dword ptr [iy]
        mov ecx,ebx
        mov edx,dword ptr [yc]
        and ebx,eax
        and ecx,edx
        cmp ebx,ecx
        jne a225
        sub edx,eax
        and edx,511
        add dword ptr [iy],512
        jmp a226
a225:
        mov edx,512
        and eax,511
        sub edx,eax
        add dword ptr [iy],edx
a226:
        mov eax,dword ptr [c0]
        imul eax,edx
        add dword ptr [d0],eax
        mov eax,dword ptr [c1]
        imul eax,edx
        add dword ptr [d1],eax
        mov eax,dword ptr [c2]
        imul eax,edx
        add dword ptr [d2],eax
        mov eax,dword ptr [iy]
        cmp eax,dword ptr [yc]
        jl a227

        mov ebx,dword ptr [sv]
        mov eax,dword ptr [d0]
        imul eax,ebx
        shr eax,2
        mov ecx,dword ptr [d1]
        imul ecx,ebx
        shr ecx,10
        mov ah,ch
        mov ecx,dword ptr [d2]
        imul ecx,ebx
        shr ecx,18
        mov al,cl
        stosd

        inc dword ptr [x]
        mov eax,dword ptr [h2]
        cmp eax,dword ptr [x]
        jae a228
        pop ebp
end asm

'c0=((c0*sh) shr 18)
'c1=((c1*sh) shr 18)
'c2=((c2*sh) shr 18)
'if (iy and &HFFFFFE00)=(yc and &HFFFFFE00) then
'z=((yc-iy) and 511)
'iy=iy+rv
'else
'z=(512-(iy and 511))
'iy=iy+z
'end if
'd0+=c0*z:d1+=c1*z:d2+=c2*z
'if iy<yc then goto a21

'cbuf(y+renderv,x+renderh)=(((d0*sv) shr 2) and &HFF0000)+(((d1*sv) shr 10) and &HFF00)+((d2*sv) shr 18)

'next x

next y
return


coloradj:
' stats 6 - contrast, 7 - bright, 10,9,8 r,g,b add
x=stats(6)+128:y=stats(7)+128
for v=0 to bmp1v-1
for h=0 to bmp1h-1
for plane=0 to 2
c0=bmp2(v,h,plane)
c0=(((c0-128)*x) shr 7)+y+stats(10-plane)
if c0>255 then c0=255
if c0<0 then c0=0
bmp2(v,h,plane)=c0
next plane
next h
next v
return

colorspace:

if (bools1 and 2048) then
' ---------------- greyscale -----------------------
x=stats(11):if x<stats(12) then x=stats(12)
if x<stats(13) then x=stats(13)
yy=255\(x-1):i1=(yy shr 2):i2=(yy shr 1):i3=i1+i2

if (bools1 and 48)<>48 then     ' simple dither or none
if (bools1 and 16)=0 then i1=i2:i3=i2
for v=0 to bmp1v-1
for h=0 to bmp1h-1
bd=bmp2(v,h,0):gd=bmp2(v,h,1):rd=bmp2(v,h,2)
y=((bd*30+gd*149+rd*77) shr 8)
if ((v+h) and 1) then
y=((y+i1)\yy)*yy
else
y=((y+i3)\yy)*yy
end if
bmp2(v,h,0)=y:bmp2(v,h,1)=y:bmp2(v,h,2)=y
next h
next v
else                            ' Floyd Steinberg dither
for v=0 to bmp1v-1
for h=0 to bmp1h-1
bd=bmp2(v,h,0):gd=bmp2(v,h,1):rd=bmp2(v,h,2)
bmp2(v,h,0)=((bd*30+gd*149+rd*77) shr 8)
next h
next v

plane=0
for v=0 to bmp1v-1
for h=0 to bmp1h-1
c0=bmp2(v,h,0)
i0=((c0+i2)\yy)*yy
bmp2(v,h,0)=i0:bmp2(v,h,1)=i0:bmp2(v,h,2)=i0
gosub floyds
next h
next v
end if

return
end if


' ------------------------------- RGBi -------------------------------
cpy(0)=510:cpy(1)=510:cpy(2)=510
x=1:xx=7
if (bools1 and 1024) then x=2:xx=15
if stats(13)>1 then cpy(0)=(255\((stats(13)*x)-1))*x
if stats(12)>1 then cpy(1)=(255\((stats(12)*x)-1))*x
if stats(11)>1 then cpy(2)=(255\((stats(11)*x)-1))*x
iy=(cpy(1) shr 1)

if (bools1 and 48)<>48 then     ' simple dither or none
for v=0 to bmp1v-1
for h=0 to bmp1h-1

c0=bmp2(v,h,0):c1=bmp2(v,h,1):c2=bmp2(v,h,2)
if (bools1 and 16) then
z=(iy shr 1)
c0=c0-z:c1=c1-z:c2=c2-z
if ((v+h) and 1) then c0=c0+iy:c1=c1+iy:c2=c2+iy
if c0<0 then c0=0
if c1<0 then c1=0
if c2<0 then c2=0
if c0>255 then c0=255
if c1>255 then c1=255
if c2>255 then c2=255
end if
gosub findrgbi2

'if (bools1 and 1024)=0 then
'for plane=0 to 2
'y=bmp2(v,h,plane)
'if ((v+h) and 1) then
'yy=y+cpi1(plane)
'else
'yy=y+cpi3(plane)
'end if
'if yy>255 then yy=255
'bmp2(v,h,plane)=(yy\cpy(plane))*cpy(plane)
'next plane
next h
next v

else                            ' Floyd Steinberg dither
for v=0 to bmp1v-1
for h=0 to bmp1h-1

gosub findrgbi
plane=0:gosub floyds
c0=c1:i0=i1:plane=1:gosub floyds
c0=c2:i0=i2:plane=2:gosub floyds

next h
next v
end if

return


findrgbi:
c0=bmp2(v,h,0):c1=bmp2(v,h,1):c2=bmp2(v,h,2)
findrgbi2:
f0=(c0\cpy(0))*cpy(0):f1=(c1\cpy(1))*cpy(1):f2=(c2\cpy(2))*cpy(2)
rd=200000
for x=0 to xx
d0=f0:d1=f1:d2=f2
if (x and 1) then d0+=cpy(0):if d0>255 then d0=f0
if (x and 2) then d1+=cpy(1):if d1>255 then d1=f1
if (x and 4) then d2+=cpy(2):if d2>255 then d2=f2
if (x and 8) then d0+=iy:d1+=iy:d2+=iy
gd=((c0-d0)*(c0-d0))+((c1-d1)*(c1-d1))+((c2-d2)*(c2-d2))
if gd<rd then rd=gd:i0=d0:i1=d1:i2=d2
next x
bmp2(v,h,0)=i0:bmp2(v,h,1)=i1:bmp2(v,h,2)=i2
return


floyds:
if h<maxh then
d0=(((c0-i0)*7) shr 4)+bmp2(v,h+1,plane):if d0>255 then d0=255
if d0<0 then d0=0
bmp2(v,h+1,plane)=d0
end if
if v<maxv then
if h>0 then
d0=(((c0-i0)*3) shr 4)+bmp2(v+1,h-1,plane):if d0>255 then d0=255
if d0<0 then d0=0
bmp2(v+1,h-1,plane)=d0
end if
d0=(((c0-i0)*5) shr 4)+bmp2(v+1,h,plane):if d0>255 then d0=255
if d0<0 then d0=0
bmp2(v+1,h,plane)=d0
if h<maxh then
d0=((c0-i0) shr 4)+bmp2(v+1,h+1,plane):if d0>255 then d0=255
if d0<0 then d0=0
bmp2(v+1,h+1,plane)=d0
end if
end if
return


palettes:
' count colors
clear ccount(0),0,1048576
for v=0 to bmp1v-1
for h=0 to bmp1h-1
x=((bmp2(v,h,0) shr 2) shl 12)+((bmp2(v,h,1) shr 2) shl 6)+(bmp2(v,h,2) shr 2)
ccount(x)+=1
next h
next v


' build list sorted by frequency
c=0
for x=0 to 262143
z=ccount(x)
if z=0 then goto a170
bpal(c)=x:bcount(c)=z:c+=1
if c=1 then goto a170
y=c-1
a169:
if bcount(y)>bcount(y-1) then
swap bcount(y),bcount(y-1):swap bpal(y),bpal(y-1)
y=y-1:if y=0 then goto a170
goto a169
end if
a170:
next x


stats(19)=c:if c<=stats(15) then goto a176

' color reduction
d0=2
a177:
for z=c-1 to 1 step -1
b=(bpal(z) and 63)
g=((bpal(z) shr 6) and 63)
r=((bpal(z) shr 12) and 63)
for zz=0 to z-1
bd=(bpal(zz) and 63)-b
gd=((bpal(zz) shr 6) and 63)-g
rd=((bpal(zz) shr 12) and 63)-r
if (rd*rd)+(gd*gd)+(bd*bd)<d0 then goto a171
a173:
next zz
goto a172
a171:
bcount(zz)+=bcount(z)
a175:
if zz=0 then goto a174
if bcount(zz)<=bcount(zz-1) then goto a174
swap bcount(zz),bcount(zz-1)
swap bpal(zz),bpal(zz-1)
zz=zz-1
goto a175
a174:
c=c-1
for zz=z to c-1
swap bcount(zz),bcount(zz+1)
swap bpal(zz),bpal(zz+1)
next zz
if c<=stats(15) then goto a176
a172:
next z
d0+=1
goto a177


a176:
' apply new palette to image
for v=0 to bmp1v-1
for h=0 to bmp1h-1
r=bmp2(v,h,0):g=bmp2(v,h,1):b=bmp2(v,h,2)
d0=200000
for z=0 to c-1
bd=((bpal(z) and 63) shl 2)-b
gd=((bpal(z) shr 4) and 252)-g
rd=((bpal(z) shr 10) and 252)-r
d1=(rd*rd)+(gd*gd)+(bd*bd)
if d1<d0 then d0=d1:x=z:if d0=0 then goto a178
next z
a178:
bmp2(v,h,0)=((bpal(x) shr 10) and 252)
bmp2(v,h,1)=((bpal(x) shr 4) and 252)
bmp2(v,h,2)=((bpal(x) and 63) shl 2)
next h
next v

return


dirscanname:
dirindex=0:imgtype=0
a180:
if imgtype=2 then return
ki2=dir(imgspecs(imgtype),&H37)
do
ki2=dir()
if ki2="" then imgtype+=1:goto a180
if ki2=fname then return
dirindex+=1
loop

dirscannumber:
x=-1:imgtype=0
a182:
if imgtype=2 then return
ki2=dir(imgspecs(imgtype),&H37)
do
ki2=dir()
if ki2="" then imgtype+=1:goto a182
x+=1
loop until x=dirindex
return


fitscreen:
if bmp1h+bmp1v<2 then goto a179
aspect=1
z1=swidth/bmp1h:z2=sheight/bmp1v
scale=z2
if z1<z2 then scale=z1
renderh=(swidth-(bmp1h*scale))\2
renderv=(sheight-(bmp1v*scale))\2
render=1
a179:
return


scrollv:
h1=stats(2):if h1<0 then h1=0
v1=renderv:if v1<0 then v1=0
h2=newh+stats(2)-1:if h2>maxx then h2=maxx
v2=newv+renderv-1:if v2>maxy then v2=maxy

yy=stats(3)-renderv
fillhole=0
if stats(3)>renderv then if v2+yy>maxy then v2=maxy-yy:fillhole=1
if stats(3)<renderv then if v1+yy<0 then v1=0-yy:fillhole=1

z=1:zz=maxy:if yy<0 then z=-1:swap v1,v2:zz=0
for y=v1 to v2 step z
for x=h1 to h2
cbuf(y,x)=cbuf(y+yy,x)
next x
next y
for y=v2+z to zz step z
for x=h1 to h2:cbuf(y,x)=0:next x
next y

stats(3)=renderv

if fillhole=0 then return

gosub definearea

if yy>0 then v1=v2-yy:if v1<0 then v1=0
if yy<0 then v2=v1-yy:if v2>newv-1 then v2=newv-1

goto resizex


scrollh:
h1=renderh:if h1<0 then h1=0
v1=stats(3):if v1<0 then v1=0
h2=newh+renderh-1:if h2>maxx then h2=maxx
v2=newv+stats(3)-1:if v2>maxy then v2=maxy

xx=stats(2)-renderh
fillhole=0
if stats(2)>renderh then if h2+xx>maxx then h2=maxx-xx:fillhole=1
if stats(2)<renderh then if h1+xx<0 then h1=0-xx:fillhole=1

for y=v1 to v2
if xx>0 then
for x=h1 to h2
cbuf(y,x)=cbuf(y,x+xx)
next x
for x=h2+1 to maxx:cbuf(y,x)=0:next x
else
for x=h2 to h1 step -1
cbuf(y,x)=cbuf(y,x+xx)
next x
for x=0 to h1-1:cbuf(y,x)=0:next x
end if
next y

stats(2)=renderh

if fillhole=0 then return

gosub definearea

if xx>0 then h1=h2-xx:if h1<0 then h1=0
if xx<0 then h2=h1-xx:if h2>newh-1 then h2=newh-1

goto resizex


startparse:
' decode a JPEG

for y=1 to 4:olddc(y)=0:next y

get #ff1,,s

if s=&HD8FF then goto startparse     'start marker
if s=&HD9FF then message=4:goto a122       'end of image
if s=&HC2FF then message=4:goto a122            ' progressive scan :(

if s=&HDDFF then                  'restart interval
get #ff1,,a:x=a:get #ff1,,a:x=(x shl 8)+a       ' header length
get #ff1,,a:rstint=a:get #ff1,,a:rstint=(rstint shl 8)+a
goto startparse
end if

if s=&HDBFF then                     'quantization table
get #ff1,,a:x=a:get #ff1,,a:x=(x shl 8)+a       ' header length
a209:
get #ff1,,a:b=(a and 15)        ' table number
        ' (bit 4 indicates 16-bit table, but only 8-bit is supported)
for y=0 to 63
get #ff1,,qtable(b,y)           ' quantization values in zigzag order
next y
if x>67 then x=x-65:goto a209
goto startparse
end if

if s=&HC4FF then                     'huffman table
get #ff1,,a:x=a:get #ff1,,a:x=(x shl 8)+a       ' header length
a208:
get #ff1,,a:b=(a and 15)        ' table number
if (a and 16) then b+=4
for y=0 to 15:get #ff1,,htl(b,y):next y
zz=0
for y=0 to 15
for z=0 to htl(b,y)-1
get #ff1,,htable(b,zz):zz+=1
next z
next y
' build huffman code table
xx=0:zz=0
for y=0 to 15
for z=0 to htl(b,y)-1
hcode(b,zz)=xx:zz+=1:xx+=1
next z
xx+=xx
next y
if x>zz+19 then x=x-zz-17:goto a208
goto startparse
end if

if s=&HC0FF then                     'baseline DCT JPEG header
get #ff1,,a:x=a:get #ff1,,a:x=(x shl 8)+a       ' header length
get #ff1,,sambits       ' bits per sample
get #ff1,,a:v=a:get #ff1,,a:v=(v shl 8)+a       ' number of lines
get #ff1,,a:h=a:get #ff1,,a:h=(h shl 8)+a       ' number of pixels/line
bmp1h=h:bmp1v=v
get #ff1,,cnum          ' number of components
for y=0 to cnum-1
get #ff1,,a             ' component identifier
get #ff1,,cr(a)         ' component resolution (h is the high nibble)
get #ff1,,cq(a)         ' quantization table selection
next y
goto startparse
end if

if s=&HDAFF then                     'start of scan           
get #ff1,,a:x=a:get #ff1,,a:x=(x shl 8)+a       ' header length
get #ff1,,a             ' number of components in scan
for y=0 to a-1
get #ff1,,b             ' component identifier
get #ff1,,g
ced(b)=(g shr 4)        ' DC entropy coding huffman table
ced(b+4)=(g and 15)+4     ' AC entropy coding huffman table
next y
get #ff1,,a             ' start of spectral selection (?)
get #ff1,,a             ' end of spectral selection (?)
get #ff1,,a             ' approximation bit positions (?)

' start decompressing and display data

bbits=0:bbytes=4096:blksdone=0

ybh=(cr(1) shr 4):ybv=(cr(1) and 15)

for bv=0 to v-1 step (ybv shl 3)
for bh=0 to h-1 step (ybh shl 3)

for dbuf=1 to ybh*ybv
bcom=1
gosub decodeblk
next dbuf

if cnum>1 then
bcom=2:dbuf=5
gosub decodeblk
bcom=3:dbuf=6
gosub decodeblk
end if

dbuf=0
for yy=1 to ybv
bvo=((yy-1) shl 3)+bv
for xx=1 to ybh
dbuf+=1
bho=((xx-1) shl 3)+bh
if bho+8>maxh then goto a223
if bvo+8>maxv then message=3:bmp1v=maxv:goto a181
for y=0 to 7

' convert to RGB

bp1=@bmp1(bvo+y,bho,0)
asm
        push ebp
        cld
        ' calculate addresses and stuff
        mov edi,dword ptr [bp1]

        movzx eax,byte ptr [dbuf]
        dec eax
        shl eax,3
        add eax,dword ptr [y]
        shl eax,5
        add eax,offset _BLK4
        mov esi,eax

        mov ebx,dword ptr [y]
        mov al,byte ptr [ybv]
        cmp al,1
        je a193
        mov eax,dword ptr [yy]
        dec eax
        shr ebx,1
        shl eax,2
        add ebx,eax
a193:
        shl ebx,5
        mov dword ptr [z],ebx

        xor ebp,ebp
a194:
        ' load a Y value
        lodsd
        sar eax,10
        add eax,32768
        jns a231
        xor eax,eax
a231:

        ' calculate chroma components address
        mov dl,byte ptr [ybh]
        cmp dl,1
        je a195
        mov edx,dword ptr [xx]
        dec edx
        shl edx,3
        add edx,ebp
        shr edx,1
        jmp a196
a195:
        mov edx,ebp
a196:
        shl edx,2
        add edx,dword ptr [z]

        ' load chroma values
        mov ebx,dword ptr [_BLK4+1024+edx]
        mov ecx,dword ptr [_BLK4+1280+edx]
        sar ebx,18
        sar ecx,18

        ' calculate B
        mov edx,359
        imul edx,ecx
        add edx,eax
        sar edx,8
        jns a197
        xor edx,edx
a197:
        cmp edx,255
        jna a198
        mov edx,255
a198:
        push edx

        ' calculate G
        imul ecx,-183
        mov edx,-88
        imul edx,ebx
        add ecx,eax
        add edx,ecx
        sar edx,8
        jns a199
        xor edx,edx
a199:
        cmp edx,255
        jna a220
        mov edx,255
a220:

        ' calculate R
        mov ecx,454
        imul ecx,ebx
        add ecx,eax
        sar ecx,8
        jns a221
        xor ecx,ecx
a221:
        cmp ecx,255
        jna a222
        mov ecx,255
a222:

        pop eax
        shl eax,8
        add eax,edx
        shl eax,8
        add eax,ecx

        stosd
        
        inc ebp
        cmp ebp,8
        jne a194
        pop ebp
end asm

next y
a223:
next xx
next yy

blksdone+=1
if blksdone=rstint then
blksdone=0:bbits=0:bbytes+=2
for y=1 to 4:olddc(y)=0:next y
end if

next bh
next bv

message=6
a181:
if bmp1h>=maxh then message=3:bmp1h=maxh

fname=ki2
goto a122
end if

if (s and 255)<>255 then message=4:goto a122

skipchunk:
get #ff1,,a:x=a:get #ff1,,a:x=(x shl 8)+a
for y=3 to x:get #ff1,,a:next y
goto startparse


decodeblk:

' get DC coefficient
i3=ced(bcom)
gosub readcode

blk(0)=olddc(bcom)+m:olddc(bcom)=blk(0)

' get AC coefficients
i3=ced(bcom+4):z=1

a206:
gosub readcode

if x=0 then for y=z to 63:blk(y)=0:next y:goto a205
for y=1 to (x shr 4):blk(z)=0:z+=1:next y
blk(z)=m:z+=1
if z<64 then goto a206
a205:


' dequantize and un-zigzag

yptr=@blk4(dbuf,0)
bp1=@qtable(cq(bcom),0)
asm
        cld
        xor ecx,ecx
        mov esi,dword ptr [bp1]
        mov ebx,offset _BLK
        mov edi,offset _BLK2
a189:
        xor eax,eax
        lodsb
        imul word ptr [ebx+ecx*2]
        movzx edx,byte ptr [_ZIGZAG+ecx]
        mov word ptr [edi+edx*2],ax
        inc ecx
        cmp ecx,64
        jne a189

        xor eax,eax
        mov edi,dword ptr [yptr]
        mov ecx,64
        rep stosd
end asm


' iDCT

asm
        cld
        xor edx,edx
a186:
        movsx ebx,word ptr [_BLK2+edx*2]
        cmp ebx,0
        jz a187
        mov ecx,64
        mov edi,dword ptr [yptr]
        push edx
        shl edx,8
        add edx,offset _ITABLE
        mov esi,edx
a188:
        lodsd
        imul ebx
        add eax,dword ptr [edi]
        stosd
        sub ecx,1
        jnz a188
        pop edx
a187:
        inc edx
        cmp edx,64
        jne a186
end asm

return


readbit:
if bbits=0 then
if bbytes>4095 then get #ff1,,filebuf():bbytes=bbytes-4096
a=filebuf(bbytes):bbits=8:bbytes+=1
if a=255 then bbytes+=1
end if

'xx+=xx+(a shr 7)
'a+=a

asm
        rcl byte ptr [a],1
        rcl dword ptr [xx],1
end asm

bbits=bbits-1
return


readcode:
xx=0:yy=0:zz=0
a200:
gosub readbit
for x=1 to htl(i3,yy)
if hcode(i3,zz)=xx then goto a201
zz+=1
next x
yy+=1:if yy=16 then message=4:goto a122
goto a200
a201:
x=htable(i3,zz)
m=0
if (x and 15)>0 then
gosub readbit
m=-2:if (xx and 1) then m=1
xx=0:for y=2 to (x and 15):gosub readbit:m+=m:next y
if m<0 then m+=1
m+=xx
end if
return



