DEFINT A-Z
' $DYNAMIC

'
'
' "j" and "b" are working now (I hope)
'
' dt.txt has not been fully updated

' don't forget about dt2wave feature

' DamageX tracker for Turbo Grafx music

' Turbo Grafx sound general info
' volume ranges from 0-31
' actual frequency = 3.58Mhz / ((period+1) * 32)
'
' music files are command based, here are the commands
'
' 0-29 = set a variable, the following byte is the value to write
'       variables are as follows:
'       0-4   main volume (ends attack, begins initial decay)
'       5-9   attack rate (value is divided by two and added to the actual
'                         volume every frame)
'       10-14 decay1 (value is divided by 64 and subtracted every frame)
'       15-19 decay2 (value is divided by 256 and subtracted every frame)
'       20-24 level volume (ends initial decay, begins secondary decay)
'       25-29 release rate (after key off, divided by 64 and subtracted)
' 32+x  stops reading music data until the next frame
'       x ranges from 0-31 and specifies additional frames to wait
' 64+x  key on / key off
'       bit 0 specifies the event (0=key off 1=key on)
'       bits 1-3 contain the number of the sound channel (0-4)
' 96+x  vibrato on/off
'       bits 0-2 contain the number of the sound channel (0-4)
'       bit 4 specifies vibrato on or off (set=on clear=off)
' 128+x sets the period of a sound channel
'       bits 0-1 contain the 2 highest bits of the period
'       bits 2-4 contain the number of the sound channel (0-4)
'       the following byte contains the 8 low bits of the period
' 160+x sets panning
'       bits 0-2 contain the number of the sound channel (0-4)
'       the following byte contains volume for left channel (bits 4-7)
'       and the volume for right channel (bits 0-3)
'       (note that generating a .WAV from the tracker uses only the top
'       three bits of each nibble while the PCE obviously uses all of them)
' 255 = jump, the following three bytes specify the bank, low byte, high byte
'       (but these won't be used here since you don't know the starting
'       address of the music in ROM!)

CLS
COLOR 0, 7
PRINT "Damage Tracker               Version 1.05                      PRESS F1 FOR HELP"
PRINT
PRINT
PRINT
PRINT
PRINT "Commands                 ";
COLOR 7, 0
PRINT "  ";
COLOR 0, 7
PRINT "Notes                                                "
COLOR 7, 0

DIM thefile(0 TO 32000) AS INTEGER
DIM regs(0 TO 34) AS INTEGER
DIM keys(0 TO 4) AS INTEGER
DIM volume(0 TO 4) AS INTEGER
DIM pcount(0 TO 4) AS INTEGER
DIM pl(0 TO 4) AS INTEGER
DIM hexs(0 TO 15) AS STRING * 1
DIM iassign(0 TO 4) AS INTEGER
DIM instruments(0 TO 5, 0 TO 31) AS INTEGER
DIM pinstl(0 TO 4, 0 TO 31) AS INTEGER
DIM pinstr(0 TO 4, 0 TO 31) AS INTEGER
DIM vibrato(0 TO 4) AS INTEGER
DIM panning(0 TO 4) AS INTEGER
DIM byte AS STRING * 1
DIM dword AS LONG
DIM copybuf(0 TO 1023) AS INTEGER
DIM wavbuff AS STRING * 2940
WBoffset = VARPTR(wavbuff)
WBseg = VARSEG(wavbuff)
FOR x = 0 TO 9: hexs(x) = CHR$(x + 48): NEXT x
FOR x = 10 TO 15: hexs(x) = CHR$(x + 55): NEXT x
DIM viblow(0 TO 10) AS INTEGER
DIM vibhigh(0 TO 10) AS INTEGER
DIM t1table(0 TO 31) AS INTEGER
DIM logtable(0 TO 31) AS SINGLE

t1table(31) = 0
t1table(30) = 1
t1table(29) = 1
t1table(28) = 1
t1table(27) = 1
t1table(26) = 2
t1table(25) = 2
t1table(24) = 2
t1table(23) = 2
t1table(22) = 3
t1table(21) = 3
t1table(20) = 3
t1table(19) = 4
t1table(18) = 4
t1table(17) = 4
t1table(16) = 5
t1table(15) = 5
t1table(14) = 6
t1table(13) = 6
t1table(12) = 7
t1table(11) = 7
t1table(10) = 8
t1table(9) = 8
t1table(8) = 9
t1table(7) = 10
t1table(6) = 11
t1table(5) = 12
t1table(4) = 14
t1table(3) = 15
t1table(2) = 17
t1table(1) = 20
t1table(0) = 31
          

viblow(0) = 0: vibhigh(0) = 0
viblow(1) = 1: vibhigh(1) = 0
viblow(2) = 2: vibhigh(2) = 1
viblow(3) = 2: vibhigh(3) = 1
viblow(4) = 1: vibhigh(4) = 1
viblow(5) = 0: vibhigh(5) = 0
viblow(6) = -1: vibhigh(6) = 0
viblow(7) = -2: vibhigh(7) = -1
viblow(8) = -2: vibhigh(8) = -1
 viblow(9) = -1: vibhigh(9) = -1
viblow(10) = 0: vibhigh(10) = 0

sy! = 1
FOR x = 31 TO 0 STEP -1
logtable(x) = sy!
sy! = sy! * 1.15
NEXT x

FOR x = 0 TO 5
FOR y = 31 TO 0 STEP -1
READ z
instruments(x, y) = z - 16
NEXT y
NEXT x

632 commandscroll = 0
notescroll = 0
length = 1
thefile(0) = 32
pline = 0
fpl = 1
noffset = 0
nlines = 0

'RUBBISH
panning(0) = 79
panning(1) = 255
panning(2) = 255
panning(3) = 244
panning(4) = 255

GOSUB 1000
GOSUB 2200
LOCATE 7, 26, 0
PRINT "<-"

IF COMMAND$ <> "" THEN
'dt2wave = 1    ' write WAV file and exit
k$ = COMMAND$: GOTO 6968
END IF
'****************************** tHe JuNk ********************************
10 IF ms > 0 THEN ms = ms - 1: GOTO 19
DO: k$ = INKEY$: LOOP UNTIL k$ <> ""

IF k$ = CHR$(0) + CHR$(73) THEN ms = 10: k$ = CHR$(0) + CHR$(72)
IF k$ = CHR$(0) + CHR$(81) THEN ms = 10: k$ = CHR$(0) + CHR$(80)

IF k$ = "q" THEN
GOSUB 2000
LOCATE 2, 1: PRINT "Quit (y/n)"; : INPUT k$
IF k$ = "y" THEN END
GOTO 10
END IF

IF k$ = "l" THEN
GOSUB 2000
LOCATE 2, 1: PRINT "Load what file (ENTER to cancel)"; : INPUT k$
6968 IF k$ = "" THEN GOTO 10
OPEN k$ FOR BINARY AS #1
commandscroll = 0
length = LOF(1)
IF length > 4 THEN length = length - 5
PRINT "Length: "; length
FOR x = 0 TO 4
GET #1, , byte
iassign(x) = ASC(byte)
NEXT x
FOR x = 0 TO 32000
GET #1, , byte
thefile(x) = ASC(byte)
NEXT x
CLOSE #1

IF dt2wave = 1 THEN
seconds = 0
frames = 0
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Writing .WAV file"
k$ = COMMAND$ + ".wav"
OPEN k$ FOR BINARY AS #1
GOTO 6969
END IF

GOSUB 1000
GOSUB 2200
GOTO 10
END IF

19 IF k$ = CHR$(0) + CHR$(72) THEN
fcount = 0
IF commandscroll = 0 THEN GOTO 57
'scroll up
cl = 0
x = 0
DO
cl = cl + x
z = thefile(cl)
GOSUB 2100
LOOP UNTIL cl + x = commandscroll
commandscroll = cl
fcount = fcountold
GOSUB 1000
57 GOSUB 2000
LOCATE 2, 1, 0
PRINT "Displaying commands starting in Frame "; fcount
GOTO 10
END IF

IF k$ = CHR$(0) + CHR$(80) THEN
'scroll down
fcount = 0
cl = 0
x = 0
DO
cl = cl + x
z = thefile(cl)
GOSUB 2100
LOOP UNTIL cl = commandscroll
IF commandscroll + x < length THEN
commandscroll = commandscroll + x
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Displaying commands starting in Frame "; fcount
END IF
GOSUB 1000
GOTO 10
END IF

IF k$ = CHR$(0) + CHR$(59) THEN
GOSUB 2000: LOCATE 2, 1, 0
PRINT "Q quit          <- pointer up   PGUP com. up 10 N notes mode    S save as      "
PRINT "L load          -> pointer down PGDN com.down10 P append comand W write .WAV   "
PRINT "A notes up       commands up   F increase fpl  I insert comand T set patterns "
PRINT "Z notes down     commands down V decrease fpl  D delete com.     F2 FOR MORE  "
GOTO 10
END IF

IF k$ = CHR$(0) + CHR$(60) THEN
GOSUB 2000: LOCATE 2, 1, 0
PRINT "E extend by 1s      M modify channel (for register     J join channels from"
PRINT "C copy commands     X modify value   setting commands)   another file"
PRINT "SPC paste commands  ^ combine waits                    B break into 5 files "
PRINT "O obliterate        R rip out channels/sections          (one per channel)"
GOTO 10
END IF

IF k$ = "x" THEN
commandscrol = commandscroll
IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscrol)
GOSUB 2100
commandscrol = commandscrol + x
IF commandscrol > length - 1 THEN GOTO 10
NEXT w
END IF
z = thefile(commandscrol)
IF z < 32 THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Current value: "; thefile(commandscrol + 1)
PRINT "New value "; : INPUT z
IF z < 0 THEN GOTO 10
IF z > 255 THEN GOTO 10
thefile(commandscrol + 1) = z
GOSUB 1000
GOSUB 2200
GOTO 10
END IF
GOTO 10
END IF

IF k$ = "m" THEN
commandscrol = commandscroll
IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscrol)
GOSUB 2100
commandscrol = commandscrol + x
IF commandscrol > length - 1 THEN GOTO 10
NEXT w
END IF
z = thefile(commandscrol)
IF z < 32 THEN
w = z - (INT(z / 5) * 5) + 1
IF w = 5 THEN w = 0
thefile(commandscrol) = (INT(z / 5) * 5) + w
GOSUB 1000
GOSUB 2200
GOTO 10
END IF
GOTO 10
END IF

IF k$ = "o" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Forget all song data (y/n) "; : INPUT k$
IF k$ = "y" THEN GOTO 632
GOTO 10
END IF

IF k$ = "c" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "How many"; : INPUT steele
IF steele = 0 THEN GOTO 10
IF steele > 512 THEN PRINT "too many!": GOTO 10
csold = commandscroll
IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscroll)
GOSUB 2100
commandscroll = commandscroll + x
IF commandscroll > length - 1 THEN commandscroll = csold: GOTO 10
NEXT w
END IF
w = 1
FOR y = 1 TO steele
z = thefile(commandscroll)
GOSUB 2100
copybuf(w) = z: w = w + 1: commandscroll = commandscroll + 1
IF x = 2 THEN copybuf(w) = thefile(commandscroll): w = w + 1: commandscroll = commandscroll + 1
IF commandscroll >= length THEN GOTO 817
NEXT y
817 copybuf(0) = w
copybuf(w) = 255
commandscroll = csold
PRINT "Copied."
END IF

IF k$ = "r" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Remove which channel (0-4,5=all)"; : INPUT steele
IF steele < 0 THEN PRINT "nan da to!?": GOTO 10
IF steele > 5 THEN PRINT "try again foo!": GOTO 10
PRINT "Starting frame number"; : INPUT frames
IF frames < 0 THEN PRINT "*ice explosion*": GOTO 10
GOSUB 4005
IF cl >= length THEN PRINT "there aren't that many frames": GOTO 10
fcount = frames
PRINT "Ending frame number"; : INPUT frames
IF fcount > frames THEN PRINT "don't be silly": GOTO 10

DO
IF cl >= length THEN GOTO 757
z = thefile(cl)
GOSUB 2100
IF (z AND 224) = 32 THEN cl = cl + x: GOTO 756

IF steele = 5 THEN GOTO 755

IF z < 32 THEN
IF (z MOD 5) = steele THEN GOTO 755
cl = cl + x: GOTO 756
END IF

IF z < 96 THEN
IF (z AND 14) / 2 = steele THEN GOTO 755
cl = cl + x: GOTO 756
END IF

IF z < 128 THEN
IF (z AND 7) = steele THEN GOTO 755
cl = cl + x: GOTO 756
END IF

IF z < 160 THEN
IF (z AND 28) / 4 = steele THEN GOTO 755
cl = cl + x: GOTO 756
END IF

IF (z AND 7) = steele THEN GOTO 755
cl = cl + x: GOTO 756

755 FOR w = cl TO length - x
thefile(w) = thefile(w + x)
NEXT w
length = length - x

756 LOOP UNTIL fcount >= frames
757 'reposition command window if it is looking at an area that is outside
' the bounds of the file now
PRINT "Removed."
GOSUB 1000
GOSUB 2200
END IF


IF k$ = "j" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Input file (ENTER to cancel)"; : INPUT dtfile$
IF dtfile$ = "" THEN GOTO 10
OPEN dtfile$ FOR BINARY AS #4
FOR x = 1 TO 5
GET #4, , byte
IF EOF(4) THEN PRINT "how about a different file?": CLOSE #4: GOTO 10
NEXT x
PRINT "Load which channel (0-4,5=all)"; : INPUT steele
IF steele < 0 THEN PRINT "inconcievable!": CLOSE #4: GOTO 10
IF steele > 5 THEN PRINT "bakanatoiunoka": CLOSE #4: GOTO 10
PRINT "Destination starting frame number"; : INPUT frames
IF frames < 0 THEN PRINT "ALL YOUR FRAMES ARE BELONG TO US": CLOSE #4: GOTO 10
GOSUB 4005
IF cl >= length THEN PRINT "there aren't that many frames": CLOSE #4: GOTO 10

sframe = frames
dtcount = 0

759 GET #4, , byte
IF EOF(4) THEN GOTO 758
z = ASC(byte)

IF (z AND 224) = 32 THEN
dtcount = dtcount + z - 31
763 frames = sframe + dtcount
GOSUB 4005
IF cl >= length THEN thefile(length) = 60: length = length + 1: GOTO 763
GOTO 759
END IF

IF z < 32 THEN
x = 2
IF steele = 5 THEN GOTO 760
IF (z MOD 5) = steele THEN GOTO 760
GET #4, , byte
GOTO 759
END IF

IF z < 96 THEN
x = 1
IF steele = 5 THEN GOTO 760
IF (z AND 14) / 2 = steele THEN GOTO 760
GOTO 759
END IF

IF z < 128 THEN
x = 1
IF steele = 5 THEN GOTO 760
IF (z AND 7) = steele THEN GOTO 760
GOTO 759
END IF

IF z < 160 THEN
x = 2
IF steele = 5 THEN GOTO 760
IF (z AND 28) / 4 = steele THEN GOTO 760
GET #4, , byte
GOTO 759
END IF

x = 2
IF steele = 5 THEN GOTO 760
IF (z AND 7) = steele THEN GOTO 760
GET #4, , byte
GOTO 759

760 FOR w = length TO cl STEP -1
thefile(w + x) = thefile(w)
NEXT w
length = length + x
thefile(cl) = z: cl = cl + 1
761 IF x > 1 THEN GET #4, , byte: thefile(cl) = ASC(byte): cl = cl + 1: x = x - 1: GOTO 761

GOTO 759

758 CLOSE #4
PRINT "Loaded."
GOSUB 1000
GOSUB 2200
END IF


IF k$ = "b" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "The files CHANNEL0.DT, CHANNEL1.DT, CHANNEL2.DT, CHANNEL3.DT, CHANNEL4.DT"
PRINT "will be created OK (y/n)"; : INPUT k$
IF k$ <> "y" THEN GOTO 10
OPEN "channel0.dt" FOR BINARY AS #1
IF LOF(1) > 1 THEN CLOSE #1: KILL "channel0.dt": OPEN "channel0.dt" FOR BINARY AS #1
OPEN "channel1.dt" FOR BINARY AS #2
IF LOF(2) > 1 THEN CLOSE #2: KILL "channel1.dt": OPEN "channel1.dt" FOR BINARY AS #2
OPEN "channel2.dt" FOR BINARY AS #3
IF LOF(3) > 1 THEN CLOSE #3: KILL "channel2.dt": OPEN "channel2.dt" FOR BINARY AS #3
OPEN "channel3.dt" FOR BINARY AS #4
IF LOF(4) > 1 THEN CLOSE #4: KILL "channel3.dt": OPEN "channel3.dt" FOR BINARY AS #4
OPEN "channel4.dt" FOR BINARY AS #5
IF LOF(5) > 1 THEN CLOSE #5: KILL "channel4.dt": OPEN "channel4.dt" FOR BINARY AS #5
FOR x = 0 TO 4
byte = CHR$(iassign(x))
PUT #1, , byte
PUT #2, , byte
PUT #3, , byte
PUT #4, , byte
PUT #5, , byte
NEXT x
FOR w = 0 TO length - 1
z = thefile(w)
IF z < 32 THEN x = 2: steele = (z MOD 5): GOTO 767
IF z < 64 THEN
byte = CHR$(z)
PUT #1, , byte
PUT #2, , byte
PUT #3, , byte
PUT #4, , byte
PUT #5, , byte
GOTO 768
END IF
IF z < 96 THEN x = 1: steele = (z AND 14) / 2: GOTO 767
IF z < 128 THEN x = 1: steele = (z AND 7): GOTO 767
IF z < 160 THEN x = 2: steele = (z AND 28) / 4: GOTO 767
x = 2: steele = (z AND 7)
767 w = w + (x - 1)
byte = CHR$(z)
IF steele = 0 THEN PUT #1, , byte: IF x = 2 THEN byte = CHR$(thefile(w)): PUT #1, , byte
IF steele = 1 THEN PUT #2, , byte: IF x = 2 THEN byte = CHR$(thefile(w)): PUT #2, , byte
IF steele = 2 THEN PUT #3, , byte: IF x = 2 THEN byte = CHR$(thefile(w)): PUT #3, , byte
IF steele = 3 THEN PUT #4, , byte: IF x = 2 THEN byte = CHR$(thefile(w)): PUT #4, , byte
IF steele = 4 THEN PUT #5, , byte: IF x = 2 THEN byte = CHR$(thefile(w)): PUT #5, , byte
768 NEXT w
CLOSE #1
CLOSE #2
CLOSE #3
CLOSE #4
CLOSE #5
PRINT "Saved."
GOTO 10
END IF


IF k$ = " " THEN
GOSUB 2000
LOCATE 2, 1, 0
csold = commandscroll
IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscroll)
GOSUB 2100
commandscroll = commandscroll + x
IF commandscroll > length - 1 THEN commandscroll = csold: GOTO 10
NEXT w
END IF
y = copybuf(0) - 1
IF y < 1 THEN commandscroll = csold: PRINT "Nothing to paste": GOTO 10
length = length + y
FOR w = length - 1 TO commandscroll + y STEP -1
thefile(w) = thefile(w - y)
NEXT w
x = 1
DO
thefile(commandscroll) = copybuf(x)
commandscroll = commandscroll + 1: x = x + 1
LOOP UNTIL x = copybuf(0)
GOSUB 1000
GOSUB 2200
END IF

IF k$ = "e" THEN
thefile(length) = 61
thefile(length + 1) = 61
length = length + 2
GOSUB 1000
GOSUB 2200
GOTO 10
END IF

IF k$ = "t" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Current wave pattern assignments "; iassign(0); iassign(1); iassign(2); iassign(3); iassign(4)
FOR w = 0 TO 4
LOCATE 3, 1, 0
PRINT "New pattern for channel "; w; " "; : INPUT y
IF ((y < 0) OR (y > 5)) THEN GOTO 10
iassign(w) = y
NEXT w
GOTO 10
END IF

IF k$ = "n" THEN GOTO 4000

IF k$ = "w" THEN
seconds = 0
frames = 0
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Writing .WAV file"
OPEN "dtracker.wav" FOR BINARY AS #1
IF LOF(1) > 1 THEN CLOSE #1: KILL "dtracker.wav": OPEN "dtracker.wav" FOR BINARY AS #1

'write header
6969 byte = "R": PUT #1, , byte
byte = "I": PUT #1, , byte
byte = "F": PUT #1, , byte
byte = "F": PUT #1, , byte

PUT #1, , dword

byte = "W": PUT #1, , byte
byte = "A": PUT #1, , byte
byte = "V": PUT #1, , byte
byte = "E": PUT #1, , byte

byte = "f": PUT #1, , byte
byte = "m": PUT #1, , byte
byte = "t": PUT #1, , byte
byte = " ": PUT #1, , byte

dword = 16
PUT #1, , dword
x = 1
PUT #1, , x
x = 2           ' 1=mono 2=stereo
PUT #1, , x
dword = 44100
PUT #1, , dword
dword = 176400   'bytes/second
PUT #1, , dword
x = 4
PUT #1, , x     'bytes/sample
x = 16
PUT #1, , x

byte = "d": PUT #1, , byte
byte = "a": PUT #1, , byte
byte = "t": PUT #1, , byte
byte = "a": PUT #1, , byte

PUT #1, , dword

FOR x = 30 TO 34: regs(x) = 0: NEXT x

countdown = 0
x = 0
DO
IF countdown > 0 THEN
countdown = countdown - 1
frames = frames + 1
IF (frames MOD 60) = 59 THEN seconds = seconds + 1: PRINT "+";

FOR w = 0 TO 4
IF vibrato(w) = 0 THEN GOTO 35
vibrato(w) = vibrato(w) + 1
IF vibrato(w) = 11 THEN vibrato(w) = 1
35 NEXT w

FOR w = 0 TO 4
z = keys(w)
IF z = 0 THEN volume(w) = volume(w) - regs(25 + w) * 4: IF volume(w) < 0 THEN volume(w) = 0
IF z = 1 THEN volume(w) = volume(w) + regs(5 + w) * 128: IF volume(w) > regs(w) * 256 THEN volume(w) = regs(w) * 256: keys(w) = 2: GOTO 32
IF z = 2 THEN
volume(w) = volume(w) - regs(10 + w) * 4
IF volume(w) < regs(w + 20) * regs(w) * 8 THEN volume(w) = regs(w + 20) * regs(w) * 8: keys(w) = 3: GOTO 32
END IF
IF z = 3 THEN volume(w) = volume(w) - regs(15 + w): IF volume(w) < 0 THEN volume(w) = 0
32 NEXT w


FOR w = 0 TO 4
y = (panning(w) AND 15) * 32
FOR i = 0 TO 31
pinstl(w, i) = (instruments(iassign(w), i) * y) \ logtable(volume(w) \ 256)
NEXT i
y = (panning(w) AND 240) * 2
FOR i = 0 TO 31
pinstr(w, i) = (instruments(iassign(w), i) * y) \ logtable(volume(w) \ 256)
NEXT i
NEXT w

FOR y = 0 TO 2936 STEP 4

zl = 0: zr = 0
FOR i = 1 TO 2
FOR w = 0 TO 4
IF pcount(w) = 0 THEN
IF regs(30 + w) = 0 THEN GOTO 36
IF regs(30 + w) > 115 THEN pl(w) = regs(30 + w) + viblow(vibrato(w))
IF regs(30 + w) <= 115 THEN pl(w) = regs(30 + w) + vibhigh(vibrato(w))
pcount(w) = pl(w)
GOTO 34
END IF
pcount(w) = pcount(w) - 1
34 IF pl(w) > pcount(w) THEN
c = INT(32 * pcount(w) \ pl(w))
zl = zl + pinstl(w, c)
zr = zr + pinstr(w, c)
END IF
36 NEXT w
NEXT i
w = WBoffset + y
DEF SEG = WBseg
POKE w, (zl AND 255)
POKE w + 1, (zl \ 256)
POKE w + 2, (zr AND 255)
POKE w + 3, (zr \ 256)
DEF SEG
NEXT y

PUT #1, , wavbuff

GOTO 31
END IF

z = thefile(x)

IF z < 32 THEN x = x + 2: regs(z) = thefile(x - 1): GOTO 31
IF z < 64 THEN x = x + 1: countdown = z - 31: GOTO 31
IF z < 96 THEN x = x + 1: keys((z AND 14) / 2) = (z AND 1): GOTO 31
IF z < 128 THEN
x = x + 1
IF (z AND 16) = 0 THEN vibrato(z AND 7) = 0: GOTO 31
IF vibrato(z AND 7) = 0 THEN vibrato(z AND 7) = 1
GOTO 31
END IF
IF z < 160 THEN x = x + 2: regs(30 + ((z AND 28) / 4)) = INT(((z AND 3) * 256 + thefile(x - 1) + 1) / 1.268): GOTO 31
IF z < 192 THEN x = x + 2: panning(z AND 3) = thefile(x - 1): GOTO 31
31 LOOP UNTIL x > length - 1

dword = frames * 2940&
PUT #1, 41, dword
dword = dword + 36
PUT #1, 5, dword
CLOSE #1
PRINT " done"
IF dt2wave = 1 THEN END
GOTO 10
END IF

IF k$ = "s" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Save as"; : INPUT k$
OPEN k$ FOR BINARY AS #1
IF LOF(1) > 1 THEN CLOSE #1: KILL k$: OPEN k$ FOR BINARY AS #1
FOR x = 0 TO 4
byte = CHR$(iassign(x))
PUT #1, , byte
NEXT x
FOR x = 0 TO length - 1
byte = CHR$(thefile(x))
PUT #1, , byte
NEXT x
CLOSE #1
PRINT "Saved."
GOTO 10
END IF

IF k$ = "p" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Append command"
GOSUB 2300
thefile(length) = y
thefile(length + 1) = z
length = length + x
GOSUB 1000
GOSUB 2200
GOTO 10
END IF

IF k$ = "^" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Combining wait commands to compact file..."
commandscroll = 0
DO

redundaits = 0
z = thefile(commandscroll)
IF ((z < 32) OR (z > 63)) THEN GOTO 13
thewait = (z AND 31) + 1
DO
redundaits = redundaits + 1
IF commandscroll + redundaits > length - 1 THEN GOTO 14
z = thefile(commandscroll + redundaits)
IF ((z < 32) OR (z > 63)) THEN GOTO 14
thenewwait = thewait + (z AND 31) + 1
IF thenewwait > 32 THEN GOTO 14
thewait = thenewwait
LOOP
14 IF redundaits < 2 THEN GOTO 13
redundaits = redundaits - 1
' WORK IN PROGRESS!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
thefile(commandscroll) = 31 + thewait
FOR w = commandscroll + 1 TO length - redundaits
thefile(w) = thefile(w + redundaits)
NEXT w
length = length - redundaits
x = 1: GOTO 15
13 GOSUB 2100
15 commandscroll = commandscroll + x
LOOP UNTIL commandscroll > length - 1
12 PRINT "Done."
commandscroll = 0
GOSUB 1000
GOSUB 2200
END IF

IF k$ = "d" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Delete command (y/n/b)"; : INPUT k$
genocide = 1
IF k$ = "b" THEN k$ = "y": PRINT "How many"; : INPUT genocide: IF genocide = 0 THEN GOTO 10
IF k$ <> "y" THEN GOTO 10

FOR y = 1 TO genocide
csold = commandscroll

IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscroll)
GOSUB 2100
commandscroll = commandscroll + x
IF commandscroll > length - 1 THEN commandscroll = csold: GOTO 11
NEXT w
END IF

z = thefile(commandscroll)
GOSUB 2100
FOR w = commandscroll TO length - x
thefile(w) = thefile(w + x)
NEXT w
length = length - x
commandscroll = csold
NEXT y
11 PRINT "Deleted."
GOSUB 1000
GOSUB 2200
END IF

IF k$ = "i" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Insert command"
GOSUB 2300

keys(0) = x
keys(1) = y
keys(2) = z

csold = commandscroll

IF pline > 0 THEN
FOR w = 0 TO pline - 1
z = thefile(commandscroll)
GOSUB 2100
commandscroll = commandscroll + x
IF commandscroll > length - 1 THEN commandscroll = csold: GOTO 10
NEXT w
END IF

length = length + keys(0)

FOR w = length - 1 TO commandscroll + keys(0) STEP -1
thefile(w) = thefile(w - keys(0))
NEXT w

thefile(commandscroll) = keys(1)
IF keys(0) = 2 THEN thefile(commandscroll + 1) = keys(2)
commandscroll = csold
GOSUB 1000
GOSUB 2200
GOTO 10
END IF

IF k$ = "a" THEN
nlines = nlines - 1
IF nlines < 0 THEN nlines = 0
GOSUB 2200
GOTO 10
END IF
IF k$ = "z" THEN
nlines = nlines + 1
GOSUB 2200
GOTO 10
END IF
IF k$ = "A" THEN
nlines = nlines - 8
IF nlines < 0 THEN nlines = 0
GOSUB 2200
GOTO 10
END IF
IF k$ = "Z" THEN
nlines = nlines + 8
GOSUB 2200
GOTO 10
END IF

IF k$ = "f" THEN
fpl = fpl + 1
GOSUB 2200
GOTO 10
END IF

IF k$ = "v" THEN
fpl = fpl - 1
IF fpl < 1 THEN fpl = 1
GOSUB 2200
GOTO 10
END IF

IF k$ = CHR$(0) + CHR$(75) THEN pline = pline - 1: IF pline < 0 THEN pline = 0
IF k$ = CHR$(0) + CHR$(77) THEN pline = pline + 1: IF pline > 15 THEN pline = 15

FOR x = 7 TO 23: LOCATE x, 26, 0: PRINT "  ": NEXT x
LOCATE pline + 7, 26, 0
PRINT "<-"

GOTO 10

1000 'commands window

LOCATE 7, 1
FOR x = 7 TO 23
PRINT "                         "
NEXT x

x = commandscroll
y = 7
LOCATE 7, 1

DO
PRINT hexs(INT((x AND 32767) / 4096));
PRINT hexs(INT((x AND 4095) / 256));
PRINT hexs(INT((x AND 255) / 16));
PRINT hexs(INT((x AND 15))); " ";

z = thefile(x)
x = x + 1

IF z < 32 THEN
channel = (z MOD 5)
reg = INT(z / 5)
z = thefile(x)
x = x + 1
IF reg = 0 THEN PRINT "Set volume "; channel; ","; z
IF reg = 1 THEN PRINT "Set attack "; channel; ","; z
IF reg = 2 THEN PRINT "Set decay1 "; channel; ","; z
IF reg = 3 THEN PRINT "Set decay2 "; channel; ","; z
IF reg = 4 THEN PRINT "Set level  "; channel; ","; z
IF reg = 5 THEN PRINT "Set release"; channel; ","; z
GOTO 20
END IF

IF z < 64 THEN
PRINT "Wait "; (z AND 31) + 1
GOTO 20
END IF

IF z < 96 THEN
channel = (z AND 14) / 2
IF (z AND 1) = 0 THEN PRINT "Key off "; channel
IF (z AND 1) = 1 THEN PRINT "Key on "; channel
GOTO 20
END IF

IF z < 128 THEN
channel = (z AND 7)
IF (z AND 16) = 0 THEN PRINT "Vibrato off "; channel
IF (z AND 16) = 16 THEN PRINT "Vibrato on "; channel
GOTO 20
END IF

IF z < 160 THEN
channel = (z AND 28) / 4
period = (z AND 3) * 256
z = thefile(x)
x = x + 1
period = period + z
PRINT "Set period"; channel; ","; period
GOTO 20
END IF

IF z < 192 THEN
channel = (z AND 7)
z = thefile(x)
x = x + 1
PRINT "Set panning"; channel; ","; z
GOTO 20
END IF

IF z = 255 THEN
x = x + 3
PRINT "Jump "; thefile(x - 3); thefile(x - 2); thefile(x - 1)
GOTO 20
END IF

PRINT "                    "

20 y = y + 1
LOOP UNTIL ((y = 23) OR (x >= length))
RETURN

2000 'clear upper window
LOCATE 2, 1
PRINT SPACE$(80)
PRINT SPACE$(80)
PRINT SPACE$(80)
PRINT SPACE$(80)

RETURN

2100 'parse file 1 command
fcountold = fcount
x = 1
IF z < 32 THEN
x = x + 1
GOTO 21
END IF

IF z < 64 THEN
fcount = fcount + 1 + (z AND 31)
GOTO 21
END IF

IF z < 128 THEN
GOTO 21
END IF

IF z < 192 THEN
x = x + 1
GOTO 21
END IF

IF z = 255 THEN
x = x + 3
GOTO 21
END IF

21 RETURN

2200 'notes window
FOR x = 7 TO 23
LOCATE x, 28, 0
PRINT "                                                     "
NEXT x
PRINT "Frames/line = "; fpl; " Starting at line "; nlines; " Time "; INT(fpl * nlines / 60); "         ";

y = 7
x = 0
countdown = 0
cline = 0
fplcount = fpl
FOR w = 0 TO 4: keys(w) = 0: NEXT w

DO
IF countdown > 0 THEN
countdown = countdown - 1

fplcount = fplcount - 1
IF fplcount > 0 THEN GOTO 23

fplcount = fpl
cline = cline + 1

IF cline > nlines THEN
FOR w = 0 TO 4
LOCATE y, w * 10 + 28, 0
IF keys(w) = 1 THEN PRINT "Key on"
IF keys(w) = -1 THEN PRINT "Key off"
IF keys(w) = 0 THEN PRINT "   -"
NEXT w
y = y + 1
END IF

FOR w = 0 TO 4: keys(w) = 0: NEXT w
GOTO 23
END IF

z = thefile(x)

IF z < 32 THEN x = x + 2: GOTO 23
IF z < 64 THEN x = x + 1: countdown = (z AND 31) + 1: GOTO 23
IF z < 96 THEN
x = x + 1
channel = (z AND 14) / 2
IF (z AND 1) = 0 THEN keys(channel) = -1
IF (z AND 1) = 1 THEN keys(channel) = 1
GOTO 23
END IF
IF z < 128 THEN x = x + 1: GOTO 23
IF z < 192 THEN x = x + 2: GOTO 23
IF z = 255 THEN GOTO 22

GOTO 575

23 IF x > length THEN GOTO 22

LOOP UNTIL y = 24

22 IF y = 7 THEN nlines = nlines - 8: IF nlines < 0 THEN nlines = 0

RETURN

2300 'ask for a command

PRINT "1) set a register  2) wait  3) key on  4) key off  5) vibrato on"
PRINT "6) vibrato off  7) set period  8) set panning  ENTER to cancel :";
INPUT k$

IF k$ = "1" THEN
x = 2
GOSUB 2000
LOCATE 2, 1, 0
PRINT "0-4 main volume  5-9 attack rate  10-14 decay 1"
PRINT "15-19 decay 2    20-24 level vol. 25-29 release"
PRINT "which register"; : INPUT y
IF ((y < 0) OR (y > 29)) THEN RETURN 10
PRINT "value"; : INPUT z
RETURN
END IF

IF k$ = "2" THEN
x = 1
PRINT "how many frames (1-32)"; : INPUT y
IF ((y < 1) OR (y > 32)) THEN RETURN 10
y = y + 31
RETURN
END IF

IF k$ = "3" THEN
x = 1
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN RETURN 10
y = y * 2 + 65
RETURN
END IF

IF k$ = "4" THEN
x = 1
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN RETURN 10
y = y * 2 + 64
RETURN
END IF

IF k$ = "5" THEN
x = 1
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN RETURN 10
y = y + 112
RETURN
END IF

IF k$ = "6" THEN
x = 1
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN RETURN 10
y = y + 96
RETURN
END IF

IF k$ = "7" THEN
x = 2
GOSUB 2000
LOCATE 2, 1, 0
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN RETURN 10
PRINT "period value"; : INPUT z
IF ((z < 0) OR (z > 1023)) THEN RETURN 10
y = y * 4 + 128 + INT(z / 256)
z = (z AND 255)
RETURN
END IF

IF k$ = "8" THEN
x = 2
GOSUB 2000
LOCATE 2, 1, 0
PRINT "which channel (0-4)"; : INPUT y
IF ((y < 0) OR (y > 4)) THEN RETURN 10
PRINT "panning value"; : INPUT z
IF ((z < 0) OR (z > 255)) THEN RETURN 10
y = y + 160
RETURN
END IF

RETURN 10

4000 'notes editor
echannel = 0
eline = 0
GOSUB 2000
LOCATE 2, 1, 0: PRINT "Notes mode, press n to return to normal mode"

GOSUB 4001

4010 DO: k$ = INKEY$: LOOP UNTIL k$ <> ""

IF k$ = "n" THEN
GOSUB 2000
LOCATE 2, 1, 0: PRINT "Normal mode"
GOTO 10
END IF

IF k$ = CHR$(0) + CHR$(59) THEN
GOSUB 2000: LOCATE 2, 1, 0
PRINT "N normal mode   <- cursor left  K key on"
PRINT "Q quit          -> cursor right O key off"
PRINT "A notes up       cursor up     C clear (keys)"
PRINT "Z notes down     cursor down   P set pitch"
GOTO 4010
END IF

IF k$ = "p" THEN
GOSUB 2000
LOCATE 2, 1, 0
PRINT "New pitch eg. f440 or p253 or 2a (2a+ for A#)"
PRINT "or ENTER to cancel"
INPUT lgaim$
IF lgaim$ = "" THEN GOTO 4010
lgaim$ = lgaim$ + "  "
IF MID$(lgaim$, 1, 1) = "f" THEN period = INT(111861 / VAL(MID$(lgaim$, 2))) - 1
IF MID$(lgaim$, 1, 1) = "p" THEN period = VAL(MID$(lgaim$, 2))

IF ((ASC(MID$(lgaim$, 1, 1)) > 48) AND (ASC(MID$(lgaim$, 1, 1)) < 58)) THEN
octave = ASC(MID$(lgaim$, 1, 1)) - 48
halfstep = 66
IF MID$(lgaim$, 2, 1) = "c" THEN halfstep = 0
IF MID$(lgaim$, 2, 1) = "d" THEN halfstep = 2
IF MID$(lgaim$, 2, 1) = "e" THEN halfstep = 4
IF MID$(lgaim$, 2, 1) = "f" THEN halfstep = 5
IF MID$(lgaim$, 2, 1) = "g" THEN halfstep = 7
IF MID$(lgaim$, 2, 1) = "a" THEN halfstep = 9
IF MID$(lgaim$, 2, 1) = "b" THEN halfstep = 11
IF halfstep = 66 THEN GOTO 4010
IF MID$(lgaim$, 3, 1) = "+" THEN halfstep = halfstep + 1
freq = 8363 * 2 ^ (octave + 2 - (120 - halfstep) / 12)
IF freq < 110 THEN PRINT "Outside PCE frequency range": GOTO 4010
period = INT(111861 / freq) - 1
END IF

GOSUB 4004
length = length + 2
FOR w = length TO cl + 2 STEP -1
thefile(w) = thefile(w - 2)
NEXT w
thefile(cl) = echannel * 4 + 128 + INT(period / 256)
thefile(cl + 1) = (period AND 255)
cl = cl + 2
DO
z = thefile(cl)

IF z < 32 THEN cl = cl + 2: GOTO 4014
IF z < 64 THEN cl = length: GOTO 4014
IF z < 96 THEN cl = cl + 1: GOTO 4014
IF z < 128 THEN cl = cl + 1: GOTO 4014
IF z < 160 THEN
IF (z AND 28) / 4 <> echannel THEN cl = cl + 2: GOTO 4014
FOR w = cl TO length - 2
thefile(w) = thefile(w + 2)
NEXT w
length = length - 2: GOTO 4014
END IF
IF z < 192 THEN cl = cl + 2: GOTO 4014

4014 LOOP UNTIL cl >= length

GOSUB 1000
END IF

IF k$ = "k" THEN
GOSUB 4004
length = length + 1
FOR w = length TO cl + 1 STEP -1
thefile(w) = thefile(w - 1)
NEXT w
thefile(cl) = 65 + echannel * 2
GOSUB 1000
END IF

IF k$ = "o" THEN
GOSUB 4004
length = length + 1
FOR w = length TO cl + 1 STEP -1
thefile(w) = thefile(w - 1)
NEXT w
thefile(cl) = 64 + echannel * 2
GOSUB 1000
END IF

IF k$ = "c" THEN
fcount = 0
cl = 0
x = 0
DO
cl = cl + x
z = thefile(cl)
GOSUB 2100
LOOP UNTIL fcount >= frames
IF fcount > frames THEN GOTO 4010
cl = cl + x
DO
z = thefile(cl)

IF z < 32 THEN cl = cl + 2: GOTO 4013
IF z < 64 THEN cl = length: GOTO 4013
IF z < 96 THEN
IF (z AND 14) / 2 = echannel THEN
FOR w = cl TO length - 1
thefile(w) = thefile(w + 1)
NEXT w
length = length - 1: GOTO 4013
END IF
cl = cl + 1: GOTO 4013
END IF
IF z < 128 THEN cl = cl + 1: GOTO 4013
IF z < 160 THEN cl = cl + 2: GOTO 4013
IF z < 192 THEN cl = cl + 2: GOTO 4013

4013 LOOP UNTIL cl >= length
GOSUB 1000
END IF

IF k$ = "q" THEN
GOSUB 2000
LOCATE 2, 1: PRINT "Quit (y/n)"; : INPUT k$
IF k$ = "y" THEN END
GOTO 4010
END IF

IF k$ = "a" THEN
nlines = nlines - 1
IF nlines < 0 THEN nlines = 0
GOSUB 2200
END IF
IF k$ = "z" THEN
nlines = nlines + 1
GOSUB 2200
END IF
IF k$ = "A" THEN
nlines = nlines - 8
IF nlines < 0 THEN nlines = 0
GOSUB 2200
END IF
IF k$ = "Z" THEN
nlines = nlines + 8
GOSUB 2200
END IF

IF k$ = CHR$(0) + CHR$(75) THEN echannel = echannel - 1: IF echannel < 0 THEN echannel = 0
IF k$ = CHR$(0) + CHR$(77) THEN echannel = echannel + 1: IF echannel > 4 THEN echannel = 4
IF k$ = CHR$(0) + CHR$(72) THEN eline = eline - 1: IF eline < 0 THEN eline = 0
IF k$ = CHR$(0) + CHR$(80) THEN eline = eline + 1: IF eline > 16 THEN eline = 16

GOSUB 2200
GOSUB 4001
GOSUB 4002

GOTO 4010

4001 x = echannel * 20 + eline * 160 + 961
FOR y = 27 TO 36
DEF SEG = &HB800
POKE x + (y * 2), 79
DEF SEG
NEXT y
RETURN

4002 'registers status
w = fpl * nlines + eline * fpl + 1

FOR x = 0 TO 34: regs(x) = 0: NEXT x

'RUBBISH
panning(0) = 79
panning(1) = 255
panning(2) = 255
panning(3) = 244
panning(4) = 255

FOR x = 0 TO 4
vibrato(x) = 0
NEXT x

frames = 0
x = 0
countdown = 0
DO
IF countdown > 0 THEN
countdown = countdown - 1
frames = frames + 1

IF frames = w THEN
frames = frames - 1
GOSUB 2000
LOCATE 2, 1, 0
PRINT "Channel "; echannel; "Frame "; frames; "Vibrato "; vibrato(echannel)
PRINT "Volume "; regs(echannel); "Attack "; regs(echannel + 5); "Decay1 "; regs(echannel + 10); "Decay2 "; regs(echannel + 15); "Level "; regs(echannel + 20)
PRINT "Panning "; panning(echannel); "Release "; regs(echannel + 25); "Period "; regs(echannel + 30); "( Frequency "; INT(3579545 / ((regs(echannel + 30) + 1) * 32)); ")"
RETURN
END IF

GOTO 4003
END IF

z = thefile(x)

IF z < 32 THEN x = x + 2: regs(z) = thefile(x - 1): GOTO 4003
IF z < 64 THEN x = x + 1: countdown = z - 31: GOTO 4003
IF z < 96 THEN x = x + 1: keys((z AND 14) / 2) = (z AND 1): GOTO 4003
IF z < 128 THEN x = x + 1: vibrato(z AND 7) = (z AND 16): GOTO 4003
IF z < 160 THEN x = x + 2: regs(30 + ((z AND 28) / 4)) = (z AND 3) * 256 + thefile(x - 1): GOTO 4003
IF z < 192 THEN x = x + 2: panning(z AND 7) = thefile(x - 1): GOTO 4003

4003 IF x > length - 1 THEN IF countdown = 0 THEN RETURN
LOOP

4004 frames = fpl * (nlines + eline)
4005 fcount = 0
cl = 0
x = 0
IF frames = 0 THEN RETURN
DO
cl = cl + x
IF cl >= length THEN RETURN
z = thefile(cl)
GOSUB 2100
LOOP UNTIL fcount >= frames
IF fcount = frames THEN cl = cl + x: RETURN
y = fcount - frames
thefile(cl) = (thefile(cl) AND 31) - y + 32
length = length + 1
cl = cl + 1
FOR w = length TO cl STEP -1
thefile(w) = thefile(w - 1)
NEXT w
thefile(cl) = y + 31
RETURN

575 PRINT "D'oh! bogus data was encountered when parsing the file in memory."
PRINT "I'm going to exit to DOS now but I'll be considerate and save the"
PRINT "file first, as BUGGERED.DT"
OPEN "buggered.dt" FOR BINARY AS #1
IF LOF(1) > 1 THEN CLOSE #1: KILL "buggered.dt": OPEN "buggered.dt" FOR BINARY AS #1
FOR x = 0 TO 4
byte = CHR$(iassign(x))
PUT #1, , byte
NEXT x
FOR x = 0 TO length - 1
byte = CHR$(thefile(x))
PUT #1, , byte
NEXT x
CLOSE #1
END

DATA 27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
DATA 16,19,22,24,27,28,30,31,31,31,30,28,27,24,22,19,16,13,10,8,5,4,2,1,1,1,2,4,5,8,10,13
DATA 4,5,6,6,7,8,9,9,10,11,12,12,13,14,15,15,16,17,18,18,19,20,21,21,22,23,24,24,25,26,27,27
DATA 3,9,14,17,19,21,22,23,23,24,24,24,25,25,25,25,26,26,26,26,26,27,27,27,27,27,27,28,28,28,28,28
DATA 0,3,7,11,16,21,25,28,31,30,28,25,21,18,16,15,17,19,22,26,29,31,30,28,25,21,16,12,8,5,2
DATA 5,10,15,20,25,28,24,21,20,21,22,23,24,25,26,27,28,29,30,20,10,2,0,0,0,0,0,0,0,0,0,2
DATA 5,10,15,20,25,28,24,21,20,21,22,23,24,25,26,27,28,29,30,31,24,18,13,9,6,4,2,15,12,8,4,0
DATA 1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,30,28,26,24,22,20,18,16,14,12,10,8,6,4,2,0

