; Enshoku
;
; a155 is next
;
; TO DO LIST:
;
; SFX
;
; work on level1list and the necessary interpreter CRAP
;
; um... gameplay
;
; have a DISCHARGE meter for enshoku attack so player knows how long it
; will last??
;
; gameover
;
;RAM map
;
;$2000   vblank (cleared at start of vb)
;$2001-2 controller status
;$2003-4 
;$2005-6 16-bit pointer for window drawer (and everything else)
;$2007   misc    (used by windraw and others)
;$2008   unused
;$2009-A scroll h
;$200B-C scroll v
;$200D   used in waitf and atkanimation
;$200E   alt
;$200F   count to 13?
;$2010   count to 4 (inc every frame)
;$2011   dragon X
;$2012   dragon Y
;$2013   weapon cool-down
;$2014   ID of object to add
;$2015   misc used in object processing for attributes
;$2016   misc used in object processing collision detection
;$2017-8 misc used by addobject
;$2019   ... object processing
;$201A   dead countdown
;$201B   number of lives
;$201C   invincibility countdown
;$201D   enshoku attack charge bar
;$201E   enshoku attack active countdown
;
;$2020-2 temp storage for GRB values
;$2023   used within fadepal
;$2024   more misc        (used by fadepal)
;$2025-6 pointer used by fadepal (and misc)
;$2027   more misc        (used by fadepal and windraw)
;$2028   background page (even is left side of map)
;
;$203D   counter for title screen animation
;$203E   power level of main weapon
;$203F   main weapon shots existence
;$2040   dragon X offset        \
;$2041   dragon X size           \
;$2042   dragon Y offset          \   for collision detection
;$2043   dragon Y size             \
;$2044   number of frames we are waiting until reading again from levellist
;$2045-6 pointer into levellist
;$2047   counter for loops
;$2048-B used for calculating object->player vector
;
;$2068   sound effect #
;$2069   length countdown
;$206A   vol countdown
;$206B   freq countdown
;$206C-D vol pointer
;$206E-F freq pointer
;
;$207A   misc
;
;$20A3   old copy of <$01 for controls
;$20A4   old copy of <$02 for controls
;
;$20AF   song bank
;$20B0-1 pointer for music
;
;$20B7-8 output of bintodec
;
;$20BB-F vibrato (music player junk)
;
;$20E1-2 pointer for the new palmod
;
;$2370-AF misc
;
;$23EF-F1 old music bank, high, low
;
;$2540-9  frequencies (emulators don't like it when I read PSG regs)
;$254A-B  music player work RAM
;
;$26C8-C  volume
;$26CD-D1 attack
;$26D2-D6 decay1
;$26D7-DB decay2
;$26DC-E0 T1L
;$26E1-E5 release
;$26E6-EA state
;$26EB-F  active volume high byte
;$26F0-4  active volume low byte
;$26F5-9  panning
;
;$2800-28FF buffer for decompressing sprite stuff
;$2900-2AFF RAM sprite table for battle engine
;
;$3000-3F object attributes - 0 = nonexistant
;                               bit 1 = destructable
;                               bit 2 = green donut
;                               bit 3 = collidable
;                               bit 4 = enemy bullet
;                               bit 5 = carries an item
;                               bit 6 = explosion size, and whether the
;                                        enemy is destroyed also if you
;                                        crash into it
;$3040-7F v offset for hitbox
;$3080-BF h offset for hitbox
;$30C0-FF pointer low byte for object program
;$3100-3F pointer high byte for object program
;$3140-7F v size
;$3180-BF h size
;$31C0-FF HP
;$3200-3F vertical velocity
;$3240-7F horizontal velocity
;$3280-BF # of frames of wait time or whatever (for programs)
;$32C0-FF fraction of v position
;$3300-3F fraction of h position
;$3340-7F object/item to spawn upon destruction
;$3380-BF loop counter for obj programs
;
;$3400-3F the extra lives display (2 planes of 16x16 pixels)
;
;$3600-39FF current correct palette
;$3A00-3BFF lookup table for base 10 conversion
;$3C00-3FFF copy of palette for messing with (fadepal)
;
;
	.bank 0
	.org $FFF6

	.dw null_int    ;IRQ2,  used by the BRK instruction
	.dw vb_int      ;IRQ1,  interrupt from the VDC
	.dw null_int    ;TIMER, not used in this demo
	.dw null_int    ;NMI,   never used (or may be by a HuCard!?)
	.dw reset_int   ;RESET, the most important one :)

	.org $E000


vb_int:
	pha
	phx
	phy
        lda $0000

;        inc <$C4
;        bne a495        ; randoms
;        inc <$B6
;a495:

;        inc <$CC

	lda #1
        eor <$0E        ; alt
	sta <$0E

        lda <$10
        inc a
        and #3
        sta <$10            ; count to 4 fast   

	lda <$02            
	sta <$A4            ; controller status last frame
	lda <$01            ;
	sta <$A3
	lda #1
	sta $1000
	lda #3
	sta $1000
	lda #1
	sta $1000
	pha
	pla
	nop
	lda $1000
	sta <$02              ; inverse L D R U
	lda #0
	sta $1000
	pha
	pla
	nop
	lda $1000
	sta <$01              ; R S I II

; music player !        

	lda <$AF
	bne a322
	jmp a_323i
a322:
;        tma #4
;        pha
;        lda <$AF
;        tam #4
	cly
a315:                         ; big loop for emulating envelope
	tya
	tax
	lda $26E6,y
	bne a316
	lda $26E1,y           ; key off
	jsr subvol
	bra a317
a316:
	cmp #1                ; key on
	bne a_320i
	lda $26CD,y
	lsr a
	bcc a831
	pha
	lda $26F0,y
	adc #127
	sta $26F0,y
	pla
a831:
	adc $26EB,y
	sta $26EB,y
	cmp $26C8,y
	bcc a317
	lda $26C8,y
	sta $26EB,y
	inc $26E6,x
	bra a317
a_320i:
	cmp #2                ; decay 1
	bne a321

	lda $26D2,y
	jsr subvol

	cla
	phy
	ldy $26DC,x
	beq a836
a834:
	clc
	adc $26C8,x
	bcc a835
	inc $254A
a835:
	dey
	bne a834
	lsr $254A
	ror a
	lsr $254A
	ror a
	lsr a
	lsr a
	lsr a
a836:
	ply
	cmp $26EB,y
	bcc a317
	inc $26E6,x
	bra a317
a321:
	lda $26F0,y           ; decay 2
	sec
	sbc $26D7,y
	sta $26F0,y
	bcs a317
	dec $26EB,x
a317:
	iny
	cpy #5
	bne a315
a833:

	cly
a_318i:
	tya
	tax
	lda $26EB,y
	bpl a319              ; check bounds
	stz $26EB,x           ;
a319:
	iny
	cpy #5
	bne a_318i

	cly
a306:
	sty $0800
	lda $26EB,y           ;
	ora #128              ; store volumes
	sta $0804             ;
	lda $26F5,y
	sta $0805
	iny
	cpy #5
	bne a306

	lda <$B2
	beq a307
	dec <$B2
	jmp a314
a307:
	lda [$B0]
	tax
	jsr incbzero
	cmp #255
	bne a326
;        lda #LOW(musrov)
;        sta <$B0
;        lda #HIGH(musrov)
;        sta <$B1
        lda [$B0]
        tay
        jsr incbzero
        lda [$B0]
        sta <$B1
        sty <$B0
;        jsr initmus
        jmp a314
a326:
	and #224
	bne a310
	lda [$B0]             ;
	sta $26C8,x           ; set a register
	jsr incbzero          ;
	bra a308
a310:
	cmp #32
	bne a312              ;
	txa                   ; wait frames
	and #31               ;
	sta <$B2
	bra a314
a312:
	cmp #128
	bne a313
	txa
	and #28               ;
	lsr a                 ; frequency change
	lsr a                 ;
	sta $0800
	tay
	txa
	and #3
	sta $0803
	sta $2545,y
	lda [$B0]
	sta $0802
	sta $2540,y
	jsr incbzero
	bra a307
a313:
	cmp #64
	bne a308
	txa
	and #62               ;
	lsr a                 ; key off/on
	tay                   ;
	txa
	and #1
	sta $26E6,y
	bra a307
a308:
	cmp #96
	bne a395
	txa                   ;
	and #16               ; vibrato on/off
	tay                   ;
	txa
	and #7
	tax
	sty <$BB,x
	bra a307
a395:
	cmp #160
	bne a837
	txa
	and #7
	tax
	lda [$B0]
	ldy $26FA
	beq a838
	lda #255
	sta $26F5,x
	jmp a307
a838:
	sta $26F5,x
a837:
	jmp a307
       
a314:

	clx
a396:
	lda <$BB,x
	beq a397
	inc a
	cmp #26
	bne a398
	lda #16
a398:
	sta <$BB,x
	ldy $2545,x
	bne a399
	ldy $2540,x
	cpy #140
	bcs a399
;        
;        bra a397
;        clc
	adc #10
a399:
	tay
	stx $0800
	lda $2540,x
	clc
	adc (vibpat-16),y
	sta $0802
	sta $2540,x
a397:
	inx
	cpx #5
	bne a396

;        pla
;        tam #4

a_323i:

	ldx <$68
        bne a186              ; sound FX engine (lame)
	jmp a174
a186:
	dex
	tma #4
	pha
	lda #9
	tam #4 
	lda <$69
	bne a175
	stz <$6A
	stz <$6B
	lda soundln,x
	sta <$69
	txa     
	asl a
	tay
	lda voladdr,y
	sta <$6C
	lda voladdr+1,y
	sta <$6D
	lda frqaddr,y
	sta <$6E
	lda frqaddr+1,y
	sta <$6F
	lda soundinst,x
	ldy #5
	sty $0800
	ldx #$FF
	stx $0805
	jsr setwave
a175:
	ldy #5
	sty $0800 
	lda <$6A
	beq a179
	dec <$6A
	bra a178
a179:
	lda [$6C]
	inc <$6C              ; volume table
	bne a176              ;
	inc <$6D
a176:
	tax
	and #128 
	beq a177
	txa
	and #$7F
	sta <$6A
	bra a178
a177:
	txa
	ora #128
	sta $0804
a178:
	lda <$6B
	beq a180              ;
	dec <$6B              ; frequency table
	bra a181
a180:
	cly
	lda [$6E],y
	tax
	iny
	lda [$6E],y
	inc <$6E             
	bne a182             
	inc <$6F
a182:
	inc <$6E             
	bne a183             
	inc <$6F
a183:
	tay
	and #4
	beq a184
	stx <$6B
	bra a181
a184:
	sty $0803 
	stx $0802
a181:        
	dec <$69
	bne a187
	stz <$68
a187:
	pla
	tam #4
a174:
;        lda <$02
;        cmp #12
;        bne a192
;        jsr debugmode
;a192:
	ply
	plx
	pla
	stz <$00
null_int:
	rti

;****************************** end of vb_int ***************************

reset_int:
	sei                   ; disable interrupts 
	csh                   ; select the 7.16 MHz clock
	cld                   ; clear the decimal flag 
	lda #$FF              ; page 0 is i/o
	tam #0
	lda #$F8              ; page 1 is ram
	tam #1
        lda #$01              ; page 2 is rom
	tam #2
        lda #$02              ; page 3 is rom
	tam #3
        lda #$03              ; page 4 is rom
	tam #4
        lda #$04              ; page 5 is rom
	tam #5
        lda #$05              ; page 6 is rom
	tam #6
	stz $C01              ; stop the timer
	stz $2000             ; clear all the RAM
	tii $2000,$2001,$1FFF
	ldx #$FF              ; initialize the stack
	txs
	jsr initvid           ; initialize the video controller

	jsr initpsg           ; and the sound generator
	jsr clearvram         ; duh

        cli

; rubbish

        jsr scrollfrombottom

;        jmp skiptxt

        st0 #0
        st1 #0
        st2 #$10
        st0 #2
        tia thefont,$0002,$1000

	stz $0402
	stz $0403
        stz $0404
        stz $0405
        stz $0404
        stz $0405
;        ldx #15
ughhhh:
        lda #255
        sta $0404
        lda #1
        sta $0405
;        dex
;        bne ughhhh

; intro text

        lda #1
        sta <$05
        lda #9
        sta <$06
        jsr add64andout
        lda #LOW(introtxt)
        sta <$20
        lda #HIGH(introtxt)
        sta <$21
a97:
        jsr waitv
        jsr waitv
        lda [$20]
        beq a98
        bpl a102
        cmp #155
        bne a99
        jsr add64andout
        bra a103
a99:
        and #127
        bra a100
a102:
	cmp #32
	bne a344
        cla
        bra a100
a344:
        cmp #64
        bcs a101
        adc #5
        bra a100
a101:
        cmp #96
	bcc a348
	sbc #6
a348:
	sec
	sbc #64
a100:
	sta $0002
	st2 #1
a103:
        inc <$20
        bne a97
        inc <$21
        bra a97
a98:
        bbs3 <$01,a98


skiptxt:

        lda #LOW(musrov)
        sta <$B0
        lda #HIGH(musrov)
        sta <$B1

	jsr initmus

        tii level1pal,$3600,$0040
        tii level1pal+64,$3800,$0080
        jsr palette1

        st0 #0
        st1 #0
        st2 #0
        st0 #2
        tia level11,$0002,$2000         ; vid $0000-$0FFF is for map
        tia level1set,$0002,$4000       ;     $1000-$2FFF is bg blks
;        tia gamespr,$0002,$4000       ;     $3000-? is spr blks

; title screen time

        lda #LOW(titlespr)
        sta <$05
        lda #HIGH(titlespr)
        sta <$06
        lda #60
        sta <$20
        jsr decompspr

        tii titleatt,$2900,$0038
        stz <$3D
a13:                                    ; title screen loop
        jsr waitv

        jsr scrollbg

        lda <$0B
        bne a26
        lda <$0C
        bne a26
        jmp reset_int
a26:

        lda <$3D
        bne a15
        lda $291A
        cmp #224
        beq a15
        clc                     ;
        sbc #0                  ; move dragon left
        sta $291A               ;
        lda $291B
        sbc #0
        sta $291B
        lda $2922
        sbc #1
        sta $2922
        lda $2923
        sbc #0
        sta $2923
        jmp a16
a15:

        lda <$10
        beq a20
        inc <$3D                ; frame (3/4) counter for animation
        bne a20
        dec <$3D
a20:

        lda <$3D
        cmp #76
        bcs a23
        and #4
        asl a
        asl a
        asl a
        tax
        cly
a18:
        lda titlepal,x
        beq a19                 ; palette swapping
        sta $3840,y
        lda titlepal+1,x
        sta $3841,y
a19:
        inx
        inx
        iny
        iny
        cpy #32
        bne a18
a23:
;        lda <$3D
;        ldx #1
;        jsr delthis

        lda <$3D
        cmp #49
        bcs a17
        and #240
        lsr a                   ; dragon breath animation
        adc #$D0                ;
        sta $291C
a17:

        lda <$3D
        cmp #64
        bcc a21
        lda $2928
        cmp #208
        beq a24
        sec
        sbc #1
        sta $2928
        sta $2930
        lda $2929               ; move enshoku logo up
        sbc #0
        sta $2929
        sta $2931
a24:
        lda <$3D
        cmp #80
        bcs a22
        and #12
        asl a
        adc #16
        sta $3854               ; logo turns red
        adc #16
        sta $3856
        bra a21
a22:
        lda #$D0
        sta $291C
        lda $291A
        cmp #32
        beq a21
        sec
        adc #0
        sta $291A
        lda $291B
        adc #0                  ;
        sta $291B               ; move dragon right
        lda $2922               ;
        adc #1
        sta $2922
        lda $2923
        adc #0
        sta $2923
        lda $2902
        cmp #120
        beq a21
        sbc #1          ; 1 that is
        sta $2902
        lda $290A
        sbc #1                  ; and logo left
        sta $290A
        lda $2912
        sbc #1
        sta $2912
a21:

        jsr palette1

a16:
        st0 #0
        st1 #0
        st2 #$7F
        st0 #2

        tia $2900,$0002,$0200

        bbr3 <$01,startthegame

        jmp a13

;
; sprite map
;
; $2900-F  score perhaps
; $2910    numbergfx
; $2918    charge meter
;
; $2A90    dragon
; $2A98-D7 regular shooting
;
;
startthegame:

        lda #LOW(level1list)
        sta <$45
        lda #HIGH(level1list)
        sta <$46
        stz <$44

        jsr fadepal
        jsr scrollfrombottom

        lda #2          ; extra lives
        sta <$1B

        stz $2900
        tii $2900,$2901,$01FF
        st0 #0
        st1 #0
        st2 #$7F
        st0 #2
        tia $2900,$0002,$0200
        jsr waitv

        st0 #0
        st1 #0
        st2 #$30
        st0 #2
        lda #LOW(gamespr)
        sta <$05
        lda #HIGH(gamespr)
        sta <$06
        lda #128
        sta <$20
        jsr decompspr

        ;setup extra lives display gfx buffer
        tii numspr+272,$3400,48
        stz $3410
        tii $3410,$3411,15
        jsr numbergfx
        lda #8
        sta $2910
        lda #1
        sta $2911
        lda #8
        sta $2912
        lda #1
        sta $2913
        lda #$F0
        sta $2914
        lda #3
        sta $2915
        lda #$86
        sta $2916
        stz $2917

        ;place the meter
        lda #80
        sta $2918
        stz $2919
        lda #20
        sta $291A
        lda #1
        sta $291B
        sta $291D
        lda #$F0
        sta $291C
        lda #$87
        sta $291E
        lda #$10
        sta $291F

        lda #255
        sta <$1D

        lda #$80
        sta $2A94       ;
        lda #$01        ; set dragon spr attrib
        sta $2A95       ;
        lda #$80        
        sta $2A96
        lda #$11
        sta $2A97

        lda #128
        sta <$11
        lda #160
        sta <$12

        tii spritespal,$3840,$00A0
        tii sprites2pal,$3900,$0080
        jsr palette1

;------------> main loop begins here <-----------------------------
a1:
        jsr waitv

        ;meter palette
        stz <$20
        ldy #2
        ldx #8
a112:
        lda <$1D
        cmp <$20
        bcc a113
        lda meterpal,y
        sta $38E0,y
        iny
        lda meterpal,y
        sta $38E0,y
        iny
        bra a114
a113:
        cla
        sta $38E0,y
        iny
        sta $38E0,y
        iny
a114:
        lda <$20
        clc
        adc #31
        sta <$20
        dex
        bne a112

        lda #23
        jsr apalette

        ;more meter stuff
        lda <$1D
        cmp #255
        beq a115
        clc
        adc <$0E
        sta <$1D
a115:

        ;palette swapping
        inc <$0F
        lda <$0F
        cmp #13
        bne a34
        stz <$0F
        bbs0 <$0E,a35
        tii spritespal,$3840,$0020
        bra a36
a35:
        tii spritespal+32,$3840,$0020
a36:
        lda #18
        jsr apalette
;        jsr palette1
a34:

; +++++++++++++++++++++++player movement+++++++++++++++++++++++
        lda <$1C
        bmi a7
        lda <$12
        clc
        bbs0 <$02,a2
        sbc #1          ; subtracting 2
a2:
        bbs2 <$02,a3
        adc #2         
a3:
        cmp #8
        bcc a6
        cmp #216
        bcs a6
        sta <$12
a6:
        lda <$11
        clc
        bbs3 <$02,a4
        sbc #1          ; subtracting 2
a4:
        bbs1 <$02,a5
        adc #2
a5:
        cmp #8
        bcc a7
        cmp #248
        bcs a7
        sta <$11
a7:


        ldy #$11
        lda <$1E        ; enshoku attack
        beq a95
        dec <$1E
        bbs0 <$0E,a95
        lda #$82        
        sta $2A96
        ldx #$E0
        bra a90
a95:
        lda #$80
        sta $2A96
        ldx #$80
        bbs1 <$02,a89
        ldx #$B8        ;
a89:                    ;
        bbs3 <$02,a90   ; dragon frames
        ldx #$B8        ;
        ldy #$19
a90:
        stx $2A94       
        sty $2A97


;D=FUDGE
        lda <$0E
        bne a128
        jsr crap
a128:

;        lda <$44
;        ldx #6
;        jsr delthis

        ; shooting upgrade (debug mode)
        jmp a68
        bbr2 <$A3,a33
        bbs2 <$01,a33
        inc <$3E
        lda <$3E
        cmp #6
        bne a33
        stz <$3E
a33:
        ; the crap has been cut :)
a68:

        ; shooting
        lda <$1A
        bne a27
        bbs1 <$01,a27
        lda <$13
        beq a32
        dec <$13
        bra a27
a32:
        lda #1
        sta <$27
        clx
a28:        
        lda <$3F
        and <$27
        beq a29
        asl <$27
        inx
        cpx #8
        bne a28
        bra a27
a29:
        lda <$3F        ;
        ora <$27        ; add a shot
        sta <$3F        ;
        txa
        asl a
        asl a
        asl a
        tax
        lda <$12
        clc
        adc #48
        sta $2A98,x
        cla
        adc #0
        sta $2A99,x
        lda <$11
        adc #24
        sta $2A9A,x
        cla
        adc #0
        sta $2A9B,x

        lda <$3E
        and #6
        asl a
;        asl a
        adc #$88
        sta $2A9C,x
        lda #1
        sta $2A9D,x
        lda #$82
        sta $2A9E,x
        cla
        sta $2A9F,x

        lda <$3E
        and #1
        eor #1
        clc
        adc #3
        sta <$13
a27:

        lda <$1E
        bne a96
        lda <$1D
        cmp #224
        bcc a96
        bbs0 <$01,a96
        dec <$1E
        stz <$1D
a96:

        jsr scrollbg    ; //////////////////////////////////


;""""""""""""""""""""""" object processing """""""""""""""""""""""
        ldx #4
a42:
        lda $3000,x
        bne a70
        jmp a43
a70:
        sta <$15

        stz <$21
        txa
        asl a           ;
        asl a           ; calculate pointer into sprite table
        asl a           ;
        rol <$21
        sta <$20
        lda <$21
        adc #$29
        sta <$21

        ; vertical coordinate bounds checking
        ldy #1
        lda [$20],y
        bmi a91
        lsr a
        lda [$20]
        ror a
        cmp #160
        bcc a92
a91:
        stz $3000,x
        cla
        sta [$20]
        sta [$20],y
        jmp a43
a92:

        lda #4
        sta <$40
        sta <$42
        dec a
        sta <$41
        sta <$43
        bbr4 <$15,a120
        lda <$1E
        beq a120
        lda #1
        sta <$40
        sta <$42
        lda #7
        sta <$41
        sta <$43
a120:

        lda <$1A
        beq a88
a94:
        jmp a45
a88:
        lda <$1C
        bne a94
        lda <$15
        and #28         ; player vs x collision detection
        beq a94
        ldy #1
        lda [$20],y
        lsr a           ; throw away lowest bit to make things easy
        lda [$20]
        ror a
        clc
        adc $3040,x     ; v
        sta <$26
        ldy #3
        lda [$20],y
        lsr a
        dey
        lda [$20],y
        ror a
        clc
        adc $3080,x     ; h
        sta <$27
        ;
        lda $2A91
        lsr a
        lda $2A90
        ror a
        clc
        adc <$42        ; dragon Y offset
        sta <$16
        adc <$43
        cmp <$26
        bcs a105
        jmp a45
a105:
        lda <$26
        adc $3140,x
        cmp <$16
        bcs a119
        jmp a45
a119:
        ; time for h coord  WIP
        lda $2A93
        lsr a
        lda $2A92
        ror a
        clc
        adc <$40        ; dragon X offset
        sta <$16
        adc <$41
        cmp <$27
        bcc a45
        lda <$27
        adc $3180,x
        cmp <$16
        bcc a45
        ; ATATTA!
        bbr2 <$15,a84
        inc <$3E
        lda <$3E
        cmp #6
        bne a83
        dec <$3E
a83:
        cla
        sta $3000,x
        sta [$20]
        ldy #1
        sta [$20],y
        jmp a43
a84:
        bbr4 <$15,a116  ;
        lda <$1E        ; can absorb a bullet?
        beq a116        ;
        lda <$1D
        cmp #224
        bcs a117        ; was a118
        adc #8
        sta <$1D
a118:
        bra a117
a116:
        phx
        lda #7
        sta <$14
        lda $2A90
        adc #4
        sta $2800
        lda $2A91
        adc #0
        sta $2801
        lda $2A92
        adc #4
        sta $2802
        lda $2A93
        adc #0
        sta $2803
        jsr addobject
        plx
        lda #135
        sta <$1A
        dec <$1B
        bne a104
        ;jmp gameover
a104:
        bbs6 <$15,a45
a117:
        stz $3000,x
        cla
        ldy #1
        sta [$20]
        sta [$20],y
        jmp a43
a45:


        lda <$15
        and #2
        bne a79
        jmp a46
a79:
        lda #$98        ; player shots vs. objects
        sta <$24
        lda #$2A
        sta <$25
        ldy #1
        lda [$20],y
        lsr a           ; throw away lowest bit to make things easy
        lda [$20]
        ror a
        clc
        adc $3040,x     ; v
        sta <$26        
        ldy #3
        lda [$20],y
        lsr a
        dey
        lda [$20],y
        ror a
        clc
        adc $3080,x     ; h
        sta <$27
        lda #254
        sta <$7A
a75:
        ; does shot exist?
        lda <$7A
        eor #255
        and <$3F
        beq a76
        ; now get shot v coord and compare
        ldy #1
        lda [$24],y
        lsr a
        lda [$24]
        ror a
;        cmp #24
;        bcc a76
        inc a
        inc a
        sta <$16
        clc
        adc #3
        cmp <$26
        bcc a76
        lda <$26
        adc $3140,x
        cmp <$16
        bcc a76
        ; time for h coord
        ldy #3
        lda [$24],y
        lsr a
        dey
        lda [$24],y
        ror a
        inc a
        inc a
        sta <$16
        adc #3
        cmp <$27
        bcc a76
        lda <$27
        adc $3180,x
        cmp <$16
        bcc a76
        ; ATATTA!
        phx
        lda #2
        sta <$14
        cly
a80:
        lda [$24],y     ; hmmm
        sta $2800,y
        iny
        cpy #4
        bne a80
        jsr addobject
        plx
        ldy #2
        cla
        sta [$24],y
        iny             ;
     ;   cla             ; move shot off the screen
        sta [$24],y     ;
        lda <$3F
        and <$7A
        sta <$3F
        lda <$3E
        lsr a
        inc a
        inc a
        sta <$16
        sec
        lda $31C0,x
        sbc <$16
        sta $31C0,x
        cmp #250
        bcc a76
        jmp a93
a76:
        sec
        rol <$7A
        lda <$24
        clc
        adc #8
        sta <$24
        cmp #$D8
        beq a46
        jmp a75
a93:
        ; YARARECHATTA!
        stz $3000,x
        cly
a77:
        lda [$20],y
        sta $2800,y
        cla
        sta [$20],y
        iny
        cpy #4
        bne a77
        bbr5 <$15,a78
        lda $3340,x
        sta <$14
        phx
        jsr addobjectl
        plx
        jmp a43
a78:
        phx
        bbs6 <$15,a111        
        lda #7          ; small explosion
        sta <$14
        jsr addobject
        plx
        jmp a43
a111:
        lda #12         ; big explosion
        sta <$14
        jsr addobject
        plx
        jmp a43
a46:

        jsr vobjmove
        jsr hobjmove

        lda $3280,x     ; countdown
        beq a44
        dec $3280,x
        jmp a43
a44:
        ; execute program @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
        lda $30C0,x
        sta <$24
        lda $3100,x
        sta <$25
        cly
a74:
        lda [$24],y
        bmi a51
        sta $3280,x
        iny
        jmp a52
a51:
        iny
        cmp #128        ; move vertically
        bne a53
        stz <$22
        lda [$24],y
        bpl a54
        dec <$22
a54:
        phy
        jsr a49
        ply
        iny
        bra a74
a53:
        cmp #129        ; move horizontally
        bne a55
        stz <$22
        lda [$24],y
        bpl a56
        dec <$22
a56:
        phy
        jsr a47
        ply
        iny
        bra a74
a55:
        cmp #130        ; set v velocity
        bne a58
        lda [$24],y
        sta $3200,x
        iny
        bra a74
a58:
        cmp #131        ; set h velocity
        bne a59
        lda [$24],y
        sta $3240,x
        iny
        bra a74
a59:
        cmp #132        ; spawn an object (most likely a bullet!)
        bne a60
        lda [$24],y
        sta <$14
        iny
        stz $2801
        stz $2803
        lda [$24],y
        bpl a106
        dec $2801
a106:
        sta $2800
        iny
        lda [$24],y
        bpl a107
        dec $2803
a107:
        sta $2802
        phx
        phy
        cly
        lda [$20],y
        clc
        adc $2800
        sta $2800
        iny
        lda [$20],y
        adc $2801
        sta $2801
        iny
        lda [$20],y
        clc
        adc $2802
        sta $2802
        iny
        lda [$20],y
        adc $2803
        sta $2803
        jsr addobject
        ply
        plx
        iny
        jmp a74
a60:
        cmp #134        ; change gfx
        bne a81
        lda [$24],y
        phy
        ldy #4
        stz <$19
        asl a
        rol <$19
        asl a
        rol <$19
        sta [$20],y
        iny
        lda <$19
        sta [$20],y
        ply
        iny
        jmp a74
a81:
        cmp #135        ; change SAT last low byte
        bne a109
        lda [$24],y
        phy
        ldy #6
        sta [$20],y
        ply
        iny
        jmp a74
a109:
        cmp #136        ; change SAT last high byte
        bne a110
        lda [$24],y
        phy
        ldy #7
        sta [$20],y
        ply
        iny
        jmp a74
a110:
        cmp #137        ; loop
        bne a135
        lda $3380,x
        cmp #1
        bne a136
        cla
        sta $3380,x
        iny
        iny
        iny
        jmp a74
a136:
        lda [$24],y
        iny
        pha
        lda [$24],y
        iny
        pha
        lda $3380,x
        bne a137
        lda [$24],y
a137:
        dec a
        sta $3380,x
        pla
        sta <$25
        pla
        sta <$24
        cly
        jmp a74
a135:
        cmp #138        ; aim at the player
        beq a149
        jmp a142
a149:
        lda [$24],y
        iny
        phy
        pha

        lda <$42
        clc
        adc $2A90               ;
        sta <$48                ; dragon y coordinate
        lda $2A91               ;
        adc #0
        sta <$49
        ldy #1
        lda [$20]               ;
        sec                     ; object y
        sbc <$48                ;
        sta <$48
        lda [$20],y
        sbc <$49
        sta <$49

        lda <$40
        clc
        adc $2A92               ;
        sta <$4A                ; dragon x coordinate
        lda $2A93               ;
        adc #0
        sta <$4B
        ldy #2
        lda [$20],y             ;
        sec                     ; object x
        sbc <$4A                ;
        sta <$4A
        iny
        lda [$20],y
        sbc <$4B
        sta <$4B

        lda <$49
        lsr a
        ror <$48
        lsr a
        ror <$48        ; shift right twice 
        lda <$4B        ;  to get signed 8-bit vectors
        lsr a
        ror <$4A
        lsr a
        ror <$4A

        cla
        sec
        sbc <$48        
        sta <$49        ;
        cla             ; take two's compliment
        sec             ;
        sbc <$4A
        sta <$4B

        ply             ; adjust the speed 
a145:
        lda <$48
        bpl a146
        cpy <$49
        bcc a143
        bra a147
a146:
        cpy <$48
        bcc a143
a147:
        lda <$4A
        bpl a148
        cpy <$4B
        bcc a143
        bra a144
a148:
        cpy <$4A
        bcc a143
        bra a144
a143:
        phx
        ldx #4
a150:
        lda <$47,x
        clc
        bpl a151
        sec
a151:
        ror <$47,x
        dex
        bne a150
        plx
        bra a145
a144:
        lda <$49
        sta $3200,x
        lda <$4B
        sta $3240,x
        ply
        jmp a74
a142:

        cmp #133        ; jump
        bne a61
        lda [$24],y
        pha
        iny
        lda [$24],y
        sta <$25
        pla
        sta <$24
        cly
        jmp a74
a61:
        cmp #255        ; implode
        bne a52
        cla
        sta $3000,x
        sta [$20]
        ldy #1
        sta [$20],y
        bra a43
a52:
        tya
        clc
        adc <$24
        sta $30C0,x
        cla
        adc <$25
        sta $3100,x
a43:
        inx
        cpx #50
        beq a71
        jmp a42
a71:
        
        

        lda <$12
        clc
        adc #48
        sta $2A90       ;
        cla             ; set dragon's position
        adc #0          ;
        sta $2A91
        lda <$11
        adc #16
        sta $2A92
        cla
        adc #0
        sta $2A93
        lda <$1A
        beq a85
        stz $2A90       ; are you dead?
        stz $2A91       ;
        dec <$1A
        bne a85
        jsr numbergfx
        lda #210
        sta <$1C
        lda #255
        sta <$12
        lda #128
        sta <$11
        stz <$1E
a85:
        lda <$1C
        beq a86
        dec <$1C
        lda <$1C
        bpl a87
        dec <$12
a87:
        bbr0 <$0E,a86
        stz $2A90
        stz $2A91
a86:

        ; move shots up
        clx
        lda #254
        sta <$27
a30:
        sec
        lda $2A98,x
        sbc #5
        sta $2A98,x
        lda $2A99,x
        sbc #0
        sta $2A99,x
        bne a31
;        lda $2A00,x
;        cmp #49
;        bcs a31
        lda #48
        cmp $2A98,x
        bcc a31
        sta $2A98,x
        lda <$3F
        and <$27
        sta <$3F
a31:
        clc
        txa
        adc #8
        tax
        sec
        rol <$27
        cpx #64
        bne a30

        st0 #0
        st1 #0
        st2 #$7F
        st0 #2

        tia $2900,$0002,$0200

;        jsr waitv
;        jmp a13

        jmp a1

vobjmove:
        stz <$22
        lda $3200,x     ; v velocity
        bpl a49
        dec <$22
a49:
        stz <$23        
        lsr a
        ror <$23
        lsr a
        ror <$23
        lsr a
        ror <$23
        bbr0 <$22,a50
        ora #224
a50:
        pha
        lda $32C0,x     ; v fraction
        clc
        adc <$23
        sta $32C0,x
        cly
        pla
        adc [$20],y
        sta [$20],y
        iny
        lda <$22
        adc [$20],y
        sta [$20],y
        rts

hobjmove:
        stz <$22
        lda $3240,x     ; h velocity
        bpl a47
        dec <$22
a47:
        stz <$23        
        lsr a
        ror <$23
        lsr a
        ror <$23
        lsr a
        ror <$23
        bbr0 <$22,a48
        ora #224
a48:
        pha
        lda $3300,x     ; h fraction
        clc
        adc <$23
        sta $3300,x
        ldy #2
        pla
        adc [$20],y
        sta [$20],y
        iny
        lda <$22
        adc [$20],y
        sta [$20],y
        rts

initpsg:
	clx
a170:
	stx $0800
	stz $0804
	inx
	cpx #6
	bne a170
	ldx #$FF
	stx $0801
	rts

initvid:
        clx
a841:
        cly
a848:
        lda vidregs,x
        sta $0000,y
        inx
        iny
        cpy #4
        bne a848
        cpx #44
        bne a841

        ldx #4
	stx $0400             ; color clock 
	rts

setwave:
	asl a
	asl a
	asl a
	asl a
	asl a
	sty $0800
	ldy #64
	sty $0804
	cly
	sty $0804
	tay
	ldx #32
a171:
	lda instruments,y
	sta $0806
	iny
	dex
	bne a171
	rts

fadepal:
        lda #21
        tam #5

        stz <$20
        stz <$21
        stz <$22

        ldy #8
a67:
        phy

        dec <$20
        dec <$21
        dec <$22

        jsr palmod
	jsr waitt
	jsr a72

        ply

        dey
	bne a67
	rts

palette1:
	tii $3600,$3C00,$0400

a72:
	stz $0402
	stz $0403
	clx
a10:
	lda $3C00,x
	sta $0404
	inx
	lda $3C00,x
	sta $0405
	inx
        bne a10
a11:
	lda $3D00,x
	sta $0404
	inx
	lda $3D00,x
	sta $0405
	inx
        bne a11
a66:
	lda $3E00,x
	sta $0404
	inx
	lda $3E00,x
	sta $0405
	inx
        bne a66
a69:
	lda $3F00,x
	sta $0404
	inx
	lda $3F00,x
	sta $0405
	inx
        bne a69

	rts

apalette:
        stz <$21
        asl a
        asl a
        asl a
        asl a
        rol <$21
        sta $0402
        ldx <$21
        stx $0403
        asl a
        rol <$21
        sta <$20
        lda <$21
        clc
        adc #$36
        sta <$21
        cly
a37:
        lda [$20],y
	sta $0404
        iny
        lda [$20],y
	sta $0405
        iny
        cpy #32
        bne a37

	rts

clearmap:
	st0 #0
	st1 #0
	st2 #0
	st0 #2

	clx
	ldy #8
a12:
	st1 #0
	st2 #1
	dex
        bne a12
	dey
        bne a12

	rts

clearvram:
	st0 #0
	st1 #0
	st2 #0
	st0 #2

	clx
	ldy #128
a8:
	st1 #0
	st2 #0
	dex
        bne a8
	dey
        bne a8

	rts

waitv:
	phy
	ldy #1
	sty <$00
a9:
	ldy <$00
        bne a9
	ply
	rts

waitt:
	ldx #4
a14:
	jsr waitv
	dex
	bne a14
	rts

gentable:
	stz <$07
	cly
	clx
	clc
a63:
	lda <$07
	clc
	adc #53
	sta $3A00,y
	txa
	adc #53
	sta $3B00,y
	iny
	cpy #100
	beq a65
	inx
	cpx #10
	bne a64
	clx
	inc <$07
a64:
	jmp a63
a65:
	rts

add64andout:
	jsr add64
andout:        
	st0 #0
	lda <$05
	sta $0002
	lda <$06
	sta $0003
	st0 #2
	rts
add64:
	lda <$05
	clc
	adc #64
	sta <$05
	lda <$06
	adc #0
	sta <$06
	rts

subvol:
	stz $254B
	asl a
	rol $254B
	asl a
;        rol $254B
;        asl a
;        rol $254B
;        asl a
	rol $254B
	sta $254A
	lda $26F0,y
	sec
	sbc $254A
	sta $26F0,y
	lda $26EB,y
	sbc $254B
	sta $26EB,y
	rts

decompspr:
        ;<$20 has number of sprite blocks to decompress
        stz <$E2
decompspr2:
        stz $237D
	clx
a405:
	lda [$05]
	inc <$05
	bne a406
	inc <$06
a406:
	tay
	and #15
	say
	iny
a407:
	sta $2800,x
	inx
	beq a408
a415:
	dey
	bne a407
	bra a405
a408:
	pha
	phy
        ; SUPERIMPS!!!!11!!!!1!!!1
        lda <$E2
        beq a872
        tma #4
        sta <$35
        tma #5
        sta <$36
        lda $2388
        tam #4
        inc a
        tam #5
        lda $237D
        beq a879
        lda $237B
        ldy $237C
        jmp a877
a879:
        inc $237D
a873:
        lda [$E1]
        inc <$E1
        bne a874
        inc <$E2
a874:
	tay
	and #15
	say
	iny
        sta $2100
a875:
;        cmp #16
;        bcc a878
        lda $2800,x
        and #240
        bne a878
        lda $2100
	sta $2800,x
a878: 
	inx
        beq a876
a877:
	dey
        bne a875
        bra a873
a876:
        sta $237B
        sty $237C
        lda <$35
        tam #4
        lda <$36
        tam #5
a872:
	; copy buffer to VRAM
	ldy #16
;        ldy #1
	sty <$7A
a411:
	ldy #16
a410:
	stz <$22
a409:
	asl <$22
	rol <$23
	lda $2800,x
	and <$7A
	beq a413
	inc <$22
a413:
	inx
	txa
	and #15
	bne a409
	lda <$22
	sta $0002
	lda <$23
	sta $0003
	dey
	bne a410

	clx
	lda <$7A
	asl a
;        cmp #16
	beq a414
	sta <$7A
	bra a411
a414:
	ply
	pla
	dec <$20
        beq a4150
        jmp a415
a4150:
	rts

initmus:        
	stz <$AF
	stz <$BB
	stz <$BC
	stz <$BD
	stz <$BE
	stz <$BF
	stz $26C8
	tii $26C8,$26C9,$002C
	lda #238
	sta $26F5
	tii $26F5,$26F6,$0004

	lda $26FA
	bne a386

	lda #47
	sta $26F6
	sta $26F8
	lda #244
	sta $26F7
	sta $26F9
a386:

	cly
a324:
	lda [$B0]
	jsr incbzero
	phy
	phx
	jsr setwave
	plx
	ply
	iny
	cpy #5
	bne a324
	
        inc <$AF        ; rubbishified
	rts

palmod:

        stz <$24
        lda #$36
        sta <$25

        stz <$E1
        lda #$3C
        sta <$E2

        lda #2
        sta <$27

        stz <$23
        cly
a859:
        lda [$24],y
        sta <$26
        tax
        iny
        lda [$24],y
        asl <$26
        rol a
        asl <$26
        rol a
        clc
        adc <$20
        bpl a860
        cla
a860:
        cmp #8
        bcc a861
        lda #7
a861:
        stz <$26
        lsr a
        ror <$26
        lsr a
        ror <$26
        pha
        txa
        iny
a862:
        and #7
        clc
        adc $2020,y
        bpl a863
        cla
a863:
        cmp #8
        bcc a864
        lda #7
a864:
        dey
        beq a865
        ora <$26
        sta <$26
        txa
        lsr a
        lsr a
        lsr a
        bra a862
a865:
        asl a
        asl a
        asl a
        ora <$26
        sta [$E1]
        inc <$E1
        pla
        sta [$E1]
        inc <$E1
        bne a866
        inc <$25
        inc <$E2
a866:
        lda <$E1
        sta <$24

        dec <$23
        bne a859

        dec <$27
        bne a859

        rts

incbzero:
;        pha
	inc <$B0
	bne a390
	inc <$B1
;        lda <$B1
;        cmp #$A0
;        bne a390
;        lda #$80
;        sta <$B1
;        inc <$AF
;        lda <$AF
;        tam #4
a390:
;        pla
	rts

delthis:
	st0 #0
	st1 #4
	stx $0003
	st0 #2
	sta $0002
        st2 #2
	rts

scrollbg:
        ; currently ghetto
        lda <$10
        bne a25
        lda <$0B
        sec
        sbc #1
        sta <$0B
        lda <$0C
        sbc #0
        sta <$0C
        st0 #7
        lda <$09        ; scroll x register
        sta $0002
        lda <$0A
        sta $0003
        st0 #8
        lda <$0B        ; scroll y register
        sta $0002
        lda <$0C
        sta $0003
a25:
        rts

addobjectl:
        ldx #49
a82:
        lda $3000,x
        beq a39
        dex
        cpx #3
        bne a82
        rts             ; out of sprites?

addobject:
        ; $2800-03 has v and h position
        ldx #4
a38:
        lda $3000,x
        beq a39
        inx
        cpx #50
        bne a38
        rts             ; out of sprites?
a39:
        ; start shuffling data
        lda <$14
        stz <$06
        asl a
        rol <$06        ; some rol's might not be needed 
        asl a
        rol <$06        ; depending on # of oprofiles that exist
        asl a
        rol <$06
        asl a
        rol <$06
        adc #LOW(oprofiles)
        sta <$05
        lda <$06
        adc #HIGH(oprofiles)
        sta <$06
        cly
        lda [$05],y
        sta $3040,x     ; v offset
        iny
        lda [$05],y
        sta $3080,x     ; h offset
        iny
        lda [$05],y
        sta $3140,x     ; v size
        iny
        lda [$05],y
        sta $3180,x     ; h size
        iny
        lda [$05],y
        sta $3000,x     ; attributes
        iny
        lda [$05],y
        sta $31C0,x     ; HP
        iny
        lda [$05],y
        sta $30C0,x     ; program low byte
        iny
        lda [$05],y
        sta $3100,x     ; program high byte
        iny
        lda [$05],y
        sta $3340,x     ; object/item to spawn upon destruction
        iny
        iny             ; unused doodads
        iny             ;
        iny
        stz $3200,x     ; v velocity
        stz $3240,x     ; h velocity
        stz $3280,x     ; countdown
        stz <$18
        txa
        asl a
        asl a
        asl a
        rol <$18
        sta <$17
        lda <$18
        adc #$29
        sta <$18
        clx
a41:
        lda $2800,x
        sta [$17]
        inx
        inc <$17
        cpx #4
        bne a41
a40:
        lda [$05],y
        sta [$17]
        iny
        inc <$17
        dex
        bne a40
        rts

numbergfx:
        ; look at <$1B and then copy numeral gfx to $3400
        lda #LOW(numspr)
        sta <$22
        lda #HIGH(numspr)
        sta <$23
        lda <$1B
        stz <$21
        lsr a
        bcs a124
        inc <$21
a124:
        stz <$20
        lsr a
        bcc a125
        ldx #32
        stx <$20
a125:
        lsr a
        ror <$20
        pha
        lda <$20
        adc <$21
        adc <$22
        sta <$22
        pla
        adc <$23
        sta <$23
        cly
a126:
        lda [$22],y
        sta $3400,y
        iny
        iny
        tya
        and #15
        bne a126
        cpy #48
        beq a127
        tya
        clc
        adc #16
        tay
        bra a126
a127:
        st0 #0
        st1 #8
        st2 #$7E
        st0 #2
        tia $3400,$0002,48      ; send to vram
        rts

scrollfrombottom:
        stz <$09
        stz <$0A
        lda #$20
        sta <$0B
        lda #$01
        sta <$0C
        st0 #7
        lda <$09        ; scroll x register
        sta $0002
        lda <$0A
        sta $0003
        st0 #8
        lda <$0B        ; scroll y register
        sta $0002
        lda <$0C
        sta $0003
        rts

crap:
        lda <$44
        beq a129
        dec <$44
        rts
a129:
        cly
a130:
        lda [$45],y
        bpl a131
        cmp #128                ; add object (low priority)
        bne a132
        iny
        lda [$45],y
        iny
        sta <$14
        clx
a133:
        lda [$45],y
        iny
        sta $2800,x
        inx
        cpx #4
        bne a133
        phy
        jsr addobjectl
        ply
        bra a130
a132:
        cmp #129        ; loop
        bne a138
        iny
        lda <$47
        cmp #1
        bne a139
        stz <$47
        iny
        iny
        iny
        bra a130
a139:
        lda [$45],y
        iny
        pha
        lda [$45],y
        iny
        pha
        lda <$47
        bne a140
        lda [$45],y
a140:
        dec a
        sta <$47
        pla
        sta <$46
        pla
        sta <$45
        cly
        jmp a130
a138:
        cmp #254                ; jump
        bne a134
        iny
        lda [$45],y
        iny
        tax
        lda [$45],y
        sta <$46
        stx <$45
        rts
a134:
        jmp (reset_int)
        bra a130        ; time to CRY
a131:
        inc a
        sta <$44
        iny
        sty $2800
        clc
        lda <$45
        adc $2800
        sta <$45
        lda <$46
        adc #0
        sta <$46
        rts

vidregs:
        .db 5,0,200,0
        .db 7,0,0,0
        .db 8,0,0,0
        .db 9,0,208,0
        .db 10,0,2,3
        .db 11,0,31,6
        .db 12,0,2,23
        .db 13,0,223,0
        .db 14,0,3,0
        .db 15,0,16,0
        .db 19,0,0,127

	.bank 1
        .org $4000

level11:
        .incbin "..\level1-1.map"

        .bank 2
        .org $6000

titleatt:
        .dw 128,128,$0180,$3182
        .dw 128,160,$0190,$3182
        .dw 128,192,$01A0,$3182
        .dw 136,296,$01B0,$1182
        .dw 136,328,$01C0,$3182
        .dw 320,136,$01F0,$0182
        .dw 320,168,$01F4,$0182

shotspr:
        .dw 0,0,$0188,$0082

oprofiles:
; voffset/2, hoffset/2, vsize/2-1, hsize/2-1 
; attributes, hp-1 (max 250)
; program
; object to spawn when destroyed by player, ?, ?, ?
; sprite data
        .db 1,1,5,5
        .db 4,0
        .dw greendonutprg
        .db 0,0,0,0             ; green donut
        .dw $0198,$0082

        .db 0,0,6,6
        .db 42,7
        .dw dshipprg
        .db 0,0,0,0             ; dship
        .dw $01B0,$0084

        .db 0,0,0,0
        .db 1,0
        .dw hitprg  
        .db 0,0,0,0             ; hit animation
        .dw $01A0,$0082

        .db 0,0,6,6
        .db 10,0
        .dw enemy1prg
        .db 0,0,0,0             ; enemy1-1
        .dw $01C8,$0084

        .db 0,0,6,6
        .db 10,0
        .dw enemy1prg2
        .db 0,0,0,0             ; enemy1-2
        .dw $01C8,$0884

        .db 0,0,6,6
        .db 10,0
        .dw enemy1prg3
        .db 0,0,0,0             ; enemy1-3
        .dw $01C8,$0084

        .db 0,0,6,6
        .db 10,0
        .dw enemy1prg4
        .db 0,0,0,0             ; enemy1-4
        .dw $01C8,$0884

        .db 0,0,0,0
        .db 1,0
        .dw explodesprg  
        .db 0,0,0,0             ; small explosion
        .dw $01AC,$0085

        .db 0,1,13,12
        .db 74,35
        .dw bigenemyprg
        .db 0,0,0,0             ; enemy2
        .dw $01D0,$1184

        .db 0,0,1,1
        .db 16,0
        .dw bullet1prg
        .db 0,0,0,0             ; a bullet 
        .dw $0194,$0082

        .db 0,0,1,1
        .db 16,0
        .dw bullet2prg
        .db 0,0,0,0             ; a bullet
        .dw $0194,$0082

        .db 0,0,1,1
        .db 16,0
        .dw bullet3prg
        .db 0,0,0,0             ; a bullet
        .dw $0194,$0082

        .db 0,0,0,0
        .db 1,0
        .dw explodebprg  
        .db 0,0,0,0             ; big explosion
        .dw $01E8,$1185
;13\
        .db 1,1,5,5
        .db 10,7
        .dw enemy3prg
        .db 0,0,0,0             ; enemy3
        .dw $01B4,$0084
;14\
        .db 0,0,7,0
        .db 16,0
        .dw laserprg
        .db 0,0,0,0             ; a laser
        .dw $019C,$0082
;15\        
        .db 1,1,5,5
        .db 10,0
        .dw biplaneprg
        .db 0,0,0,0             ; biplane
        .dw $01CC,$0085
;16\
        .db 0,0,1,1
        .db 16,0
        .dw bullet4prg
        .db 0,0,0,0             ; a bullet
        .dw $0194,$0082
;17\
        .db 2,2,3,3
        .db 10,0
        .dw cutterprg
        .db 0,0,0,0             ; cutter
        .dw $0208,$0088

; object program workings
; 0-127 = do nothing for n+1 frames
; 128 = move in vertical direction (next byte has signed value)
; 129 = move in horizontical direction (...)
; 130 = set vertical movement velocity (...)
; 131 = set horizontal movement velocity (...)
;               7=sign bit, 6~3=magnitude, 2~0=fraction
; 132 = spawn another object - three bytes follow
;                               which object
;                               vertical offset
;                               horizontal offset
; 133 = jump (next two bytes have address)
; 134 = change gfx (address that goes in SAT shifted right twice)
; 135 = change SAT last low byte (the one with the palette) (...)
; 136 = change SAT last high byte (size, orientation, etc.) (...)
; 137 = loop - three bytes follow:      low address byte
;                                       high address byte
;                                       number of times to loop
; 138 = aim at the enemy (followed by a velocity byte?)
;
; 255 = cease to exist

greendonutprg:
        .db 130,2,131,8,15,131,4,15,131,252,15,131,248,31,131,252,15
        .db 131,4,15,131,8,15,133
        .dw greendonutprg
dshipprg:
        .db 130,3,127,133
        .dw dshipprg
hitprg:
        .db 134,$68,4,134,$69,4,134,$6A,4,255
enemy1prg:
        .db 131,238,36,131,0,130,237,134,$70,80,255
enemy1prg2:
        .db 131,18,36,131,0,130,237,134,$70,80,255
enemy1prg3:
        .db 131,238,55,131,0,130,19,134,$71,82,255
enemy1prg4:
        .db 131,18,55,131,0,130,19,134,$71,82,255
explodesprg:
        .db 5,134,$76,5,134,$77,5,255
bigenemyprg:
        .db 130,5,60,130,1,132,9,8,8,40,130,0
a108:
        .db 132,9,8,8,1,132,10,8,8,1,132,11,8,8,40
        .db 137
        .dw a108
        .db 15
        .db 131,252
a152:
        .db 27,132,16,8,8,137
        .dw a152
        .db 9,127,255
bullet1prg:
        .db 130,24,127,133
        .dw bullet1prg
bullet2prg:
        .db 130,22,131,246,127,133
        .dw bullet2prg
bullet3prg:
        .db 130,22,131,10,127,133
        .dw bullet3prg
bullet4prg:
        .db 138,22
ugher:
        .db 127,137
        .dw ugher
        .db 4
        .db 255
explodebprg:
        .db 0,135,$05,0,135,$85,0,135,$05,0,135,$85,0,135,$05,0,135,$85
        .db 0,135,$05,0,135,$85,0,135,$05,0,135,$85,0,135,$05,0,135,$85
        .db 0,135,$05,0,135,$85,0,135,$05,0,135,$85,0,135,$05,0,135,$85
        .db 255
enemy3prg:
        .db 130,8,100,130,0
a123:
        .db 132,14,2,0,17,137
        .dw a123
        .db 20
        .db 130,6,133
        .dw a123
laserprg:
        .db 130,30,127,133
        .dw laserprg
biplaneprg:
        .db 130,12,26,129,248,3,129,248,1,131,246,134,$80,24
        .db 132,10,2,2,24
        .db 130,6,16,130,0,134,$7F,16,130,250,131,251,134,$81,136,8,16
        .db 130,244,131,0,134,$7E,16,130,250,131,5,134,$81,136,0,16
        .db 130,0,131,16,134,$7F,136,8,16,130,6,16,130,12,134,$80,1
        .db 132,11,2,2,127
cutterprg:
        .db 138,6,134,$82,29,134,$83,29,137
        .dw cutterprg
        .db 13
        .db 130,6
a154:
        .db 1,133
        .dw a154

titlespr:
        .incbin "..\title1.ce"
        .incbin "..\title2.ce"
        .incbin "..\title3.ce"
        .incbin "..\title4.ce"
        .incbin "..\title5.ce"
        .incbin "..\title6.ce"
        .incbin "..\dragontl.ce"
        .incbin "..\blank.ce"
        .incbin "..\dragontr.ce"
        .incbin "..\dragonbr.ce"
        .incbin "..\dragonf0.ce"
        .incbin "..\dragonf1.ce"
        .incbin "..\dragonf2.ce"
        .incbin "..\dragonf3.ce"
        .incbin "..\enshoku.ce"

gamespr:
        .incbin "..\dragon.ce"
        .incbin "..\shots1.ce"
        .incbin "..\shots2.ce"
        .incbin "..\donutl.ce"
        .incbin "..\hit12.ce"
        .incbin "..\hit3.ce"
        .incbin "..\dship.ce"
; dragon2 is $1B8 and a 32x32 sprite is 8
        .incbin "..\dragon2.ce"
        .incbin "..\enemy1.ce"
        .incbin "..\enemy1b.ce"
        .incbin "..\enemy2.ce"
; explodes $1D8
        .incbin "..\explodes.ce"
        .incbin "..\denshoku.ce"
        .incbin "..\explodeb.ce"
        .incbin "..\meter.ce"
; $1F8
        .incbin "..\biplane2.ce"
; $200
        .incbin "..\biplane3.ce"
        .incbin "..\cutter.ce"

numspr:
        .incbin "..\num0123.t"
        .incbin "..\num4567.t"
        .incbin "..\num89d.t"

spritespal:
        .incbin "..\sprites.pal"
numpal:
        .incbin "..\num.pal"
sprites2pal:
        .incbin "..\sprites2.pal"

; level program workings
; 0-127 = do nothing for (n+1)*2 frames
; 128 = place an object... followed by object number, V, H
; 129 = loop - address follows... and then loop count
;
; 254 = jump (address follows)

level1list:
        .db 127

        .db 128
        .db 15          ; biplane from top right/center
        .dw 48
        .dw 196

        .db 25

        .db 128
        .db 15          ; biplane from top right/center
        .dw 48
        .dw 196

        .db 25

        .db 128
        .db 15          ; biplane from top right/center
        .dw 48
        .dw 196

        .db 1

        .db 128
        .db 13          ; blue doodad (enemy3?) from top left/center
        .dw 48
        .dw 114

        .db 23

        .db 128
        .db 15          ; biplane from top right/center
        .dw 48
        .dw 196

        .db 3

        .db 128
        .db 13          ; blue doodad (enemy3?) from top right
        .dw 28
        .dw 224

        .db 13

        .db 128
        .db 13          ; blue doodad (enemy3?) from top left
        .dw 10
        .dw 80

        .db 95
a141:
        .db 128
        .db 3           ; enemy1 from bottom right
        .dw 232
        .dw 288

        .db 128
        .db 4           ; enemy1 from bottom left
        .dw 232
        .dw 16

        .db 31

        .db 129
        .dw a141
        .db 5


        .db 128
        .db 8           ; big enemy at top center
        .dw 32
        .dw 144

        .db 111

        .db 40

        .db 128
        .db 1           ; dship
        .dw 48
        .dw 180

        .db 40

        .db 128
        .db 17          ; cutter
        .dw 48
        .dw 192

        .db 1

        .db 128
        .db 17          ; cutter
        .dw 48
        .dw 142

        .db 1

        .db 128
        .db 17          ; cutter
        .dw 48
        .dw 92

        .db 1

        .db 254
        .dw level1list

        .db 127,127,127,127,127,127,127,127,127,127,127,127
        .db 127,127,127,127,127,127,127,127,127,127,127,127
        .db 127,127,127,127,127,127,127,127,127,127,127,127
        .db 127,127,127,127,127,127,127,127,127,127,127,127
        .db 127,127,127,127,127,127,127,127,127,127,127,127
        .db 127,127,127,127,127,127,127,127,127,127,127,127
        .db 127,127,127,127,127,127,127,127,127,127,127,127
        .db 127,127,127,127,127,127,127,127,127,127,127,127

; doodadsssssssssssssssssssssssssssssssssssssssssssss

        .db 128
        .db 1           ; dship
        .dw 64
        .dw 64

        .db 128
        .db 3           ; enemy1 from bottom right
        .dw 232
        .dw 288

        .db 128
        .db 4           ; enemy1 from bottom left
        .dw 232
        .dw 16

        .db 128
        .db 5           ; enemy1 from top right
        .dw 96
        .dw 288

        .db 128
        .db 6           ; enemy1 from top left
        .dw 88
        .dw 16

        .db 128
        .db 8           ; big enemy at top center
        .dw 32
        .dw 144

        .db 128
        .db 13          ; blue doodad (enemy3?) from top left/center
        .dw 48
        .dw 96

        .db 128
        .db 15          ; biplane from top right/center
        .dw 48
        .dw 196


        .bank 3
        .org $8000

vibpat:
	.db 1,1,0,255,255,255,255,0,1,1
	.db 0,1,0,0,255,0,255,0,0,1

instruments:
	.db 30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
	.db 16,22,25,27,28,29,30,31,31,30,29,28,27,25,22,16,16,10,7,5,4,3,2,1,0,1,2,3,4,7,10,16
	.db 2,2,3,4,5,6,7,7,8,9,10,11,12,12,13,14,15,16,17,17,18,19,20,21,22,22,23,24,25,26,27,27
	.db 2,9,14,17,19,21,22,23,23,24,24,24,25,25,25,25,26,26,26,26,26,27,27,27,27,27,27,28,28,28,28,28
	
;        .db 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31
;        .db 0,8,14,19,22,24,25,26,26,27,27,27,28,28,28,28,29,29,29,29,29,30,30,30,30,30,30,31,31,31,31,31
;sin     .db 16,22,25,27,28,29,30,31,31,30,29,28,27,25,22,16,16,10,7,5,4,3,2,1,0,1,2,3,4,7,10,16

soundln:
	.db 6,7
soundinst:
	.db 0,0
voladdr:
	.dw soundvol1,soundvol2
frqaddr:
	.dw soundfrq1,soundfrq2

soundvol1:
	.db 10,20,129,10,0
soundfrq1:
	.dw 220,1028
soundvol2:
	.db 24,20,16,12,8,4,0
soundfrq2:
	.dw 180,1029


introtxt:
        .db "Enshoku V0",192,"91",155
        .db "2005",196,"6",197,"27",198,155
        .db 155
;        .db "PDRoms Coding Competition",155
;        .db "sponsored by",155
;        .db "       www",192,"consolefever",192,"com",155
        .db 155
        .db 155
        .db 155
        .db 155
        .db 155
        .db 155
        .db "damage",199,"x",200,"hyakushiki",192,"net",155
        .db 155
        .db 155
        .db "PRESS RUN",0

meterpal:
        .incbin "..\meter.pal"
level1pal:
        .incbin "..\1.pal"
titlepal:
        .incbin "..\title.pal"
        .incbin "..\title2.pal"
thefont:
        .incbin "..\thefont.set"

musrov:
        .incbin "junk.dt"

; 255 is a 'jump' command, the bank-low-high address bytes follow

	.db 255
	.dw musrov+5

level1set:
        .incbin "..\level1-1.set"

