
	SECTION "Startup",HOME[0]

RST_00: jp      Main
	DS      5
RST_08: jp      Main
	DS      5
RST_10: jp      Main
	DS      5
RST_18: jp      Main
	DS      5
RST_20: jp      Main
	DS      5
RST_28: jp      Main
	DS      5
RST_30: jp      Main
	DS      5
RST_38: jp      Main
	DS      5
	jp      irq_vblank
	DS      5
	jp      irq_lcdc
	DS      5
	jp      irq_timer
	DS      5
	jp      irq_serial
	DS      5
	jp      irq_hilo
	DS      5

	DS      $100-$68

	nop
	jp      Main

	DB      $CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83,$00,$0C,$00,$0D
	DB      $00,$08,$11,$1F,$88,$89,$00,$0E,$DC,$CC,$6E,$E6,$DD,$DD,$D9,$99
	DB      $BB,$BB,$67,$63,$6E,$0E,$EC,$CC,$DD,$DC,$99,$9F,$BB,$B9,$33,$3E

				       
	DB      "JET FIGHTER Z  "
	DB      $80,0,0,0
	DB      0       ;CARTTYPE
			;--------
			;0 - ROM ONLY
			;1 - ROM+MBC1
			;2 - ROM+MBC1+RAM
			;3 - ROM+MBC1+RAM+BATTERY
			;5 - ROM+MBC2
			;6 - ROM+MBC2+BATTERY

	DB      0       ;ROMSIZE
			;-------
			;0 - 256 kBit ( 32 kByte,  2 banks)
			;1 - 512 kBit ( 64 kByte,  4 banks)
			;2 -   1 MBit (128 kByte,  8 banks)
			;3 -   2 MBit (256 kByte, 16 banks)
			;3 -   4 MBit (512 kByte, 32 banks)

	DB      0       ;RAMSIZE
			;-------
			;0 - NONE
			;1 -  16 kBit ( 2 kByte, 1 bank )
			;2 -  64 kBit ( 8 kByte, 1 bank )
			;3 - 256 kBit (32 kByte, 4 banks)

	DW      $0000   ;Manufacturer

	DB      0       ;Version
	DB      0       ;Complement check
	DW      0       ;Checksum

; RAM map
;
; $C000 
; $C001 scroll V
; $C002 goes to one at vblank
; $C003-6 shot existence
; $C007 jet existence (graphically)
; $C008 flashing countdown
; $C009 that thing where the jet comes on flashing
; $C00A ALT
; $C00B jet can't move
; $C00C slower ALT
; $C00D level of your shooting
;
; $FF80 controller status  S s B A
; $FF81 controller status  D U L R
; $FF82-3 pointer in to level
;
; $D000-$D0FF sprite table
;

Main::
	; disable interrupts

	di

	; we want a stack

	ld hl,$DFFF
	ld sp,hl

	; initialize the rest of the RAM to zero

	ld hl,$C000
	xor a,a
	ld bc,$2000
	ld [$FF40],a
aa:
	ldi [hl],a
	dec c
	jr nz,aa
	dec b
	jr nz,aa

	call copything
	call clearmap
	call initvid
	call copyblocks
	call clearspr
	call setpal

	ei

	ld a,96
	ld [$FF43],a
	ld de,$9864
	ld hl,words4
	call print
	ld de,$98A4
	call print

	ld c,96
bk:
	call waitv
	ld a,c
	ld [$FF43],a
	dec c
	jr nz,bk
	ld a,c
	ld [$FF43],a

	ld hl,$D000
	ld de,zdata
	ld c,36
bf:
	ld a,[de]
	ldi [hl],a
	inc de
	dec c
	jr nz,bf

	ld c,48
bi:
	call waitv
	ld hl,$D000
	ld b,9
bj:
	inc [hl]
	inc hl
	inc hl
	inc hl
	inc hl
	dec b
	jr nz,bj
	dec c
	jr nz,bi

	ld de,$99A4
	ld hl,words6
	call print

	ld c,8
	call waitkey
	call clearmap
	call clearspr
	ld a,135
	ld [$FF40],a       ; make sprites 8*16
	call copyblocks2

	ld a,2
	ld [$C00D],a       ; shooting level 1 (double it)

	ld a,240
	ld [$D000],a
	ld [$D004],a
	ld a,80
	ld [$D001],a       ;
	ld a,88            ;  init your jet
	ld [$D005],a       ;
	ld a,2
	ld [$D002],a
	ld [$D006],a
	dec a
	ld [$D003],a
	ld [$C009],a
	ld a,33
	ld [$D007],a
	ld a,240
	ld [$C008],a

	ld a,1
	ld [$9888],a

; Start of main game loop thing
a8:
	call waitv

	ld a,[$C00A]
	dec a              ;
	jr nz,a9           ; scroll a pixel every other frame
	ld hl,$C001        ;
	inc [hl]
a9:

	ld a,[$C009]
	sub 0
	jr z,dh
	ld [$C00B],a
	ld a,[$D000]
	sub 2
	ld [$D000],a
	ld [$D004],a
	cp 100
	jr nc,dh
	ld a,0
	ld [$C009],a
dh:

	ld a,[$C008]
	sub 0
	jr z,df
	ld a,[$C00C]         ;  is your jet flashing?
	ld [$C007],a         ;
	ld a,[$C008]
	dec a
	jr nz,dg
	inc a
	ld [$C007],a
dg:
	ld [$C008],a
df:

	ld c,2
	ld a,[$C007]
	dec a
	jr z,da              ;
	ld c,0               ;  is your jet there?
da:                          ;
	ld a,c               ;
	ld [$D002],a
	ld [$D006],a

	call controls

	ld hl,$D008
	ld c,4
cj:
	ld a,[hl]
	sub 6
	cp 160
	jr c,ck
	ld a,7
	sub c
	ld e,a
	ld d,$C0
	ld a,0
	ld [de],a
ck:
	ld [hl],a
	ld a,l
	add 4
	ld l,a
	dec c
	jr nz,cj

	jr a8

controls:
	ld a,[$D001]
	ld c,a
	ld a,[$D000]
	ld d,a
	ld a,[$FF81]     ; D U L R
	ld b,a
	and a,8
	jr nz,ca
	inc d
	inc d
ca:
	ld a,b
	and a,4
	jr nz,cb
	dec d
	dec d
cb:
	ld a,b
	and a,2
	jr nz,cc
	dec c
	dec c
cc:
	ld a,b
	and a,1
	jr nz,cd
	inc c
	inc c
cd:
	ld a,c
	ld [$D001],a
	add 8
	ld [$D005],a
	ld a,d
	ld [$D000],a
	ld [$D004],a
	
	ld a,[$FF80]     ; S s B A
	ld b,a
	and 8
	jr nz,ce
   ;     call pause
ce:        
	ld a,b
	and 1
	jr nz,cg
	ld a,[$C00A]
	dec a
	jr nz,cg
	call addshot
cg:
	ret

addshot:
	ld c,0
	ld hl,$C003
ch:
	ld a,[hl]
	inc hl
	inc c
	sub 0
	jr z,ci
	ld a,c
	sub 4
	jr nz,ch
	ret
ci:
	ld a,c
	inc a
	sla a
	sla a
	ld l,a
	ld h,$D0
	ld a,[$D000]
	ldi [hl],a
	ld a,[$D001]
	add 4
	ldi [hl],a
	ld a,[$C00D]
	add 2
	ldi [hl],a
	ld a,2
	ldi [hl],a
	ld a,c
	add 2
	ld l,a
	ld h,$C0
	ld a,1
	ld [hl],a
	ret

pause:
	call waitv
	ld c,8
	call waitkey
	ret

irq_vblank:
	push af
	push bc
	push de
	push hl

	call scroller
	call $FFF0
	
	ld a,1
	ld [$C002],a          ; its vblank
	ld hl,$C00A           
	sub [hl]              ; ALT
	jr nz,cf
	inc hl
	inc hl
	ld b,a
	ld a,1
	sub [hl]
	ld [hl],a
	ld a,b
	dec hl
	dec hl
cf:
	ld [hl],a

	ld a,$10
	ld [$FF00],a
	ld a,[$FF00]
	ld a,[$FF00]
	ld a,[$FF00]
	ld a,[$FF00]
	ld a,[$FF00]          ; get controller status
	ld a,[$FF00]
	ld [$FF80],a
	ld a,$20
	ld [$FF00],a
	ld a,[$FF00]
	ld a,[$FF00]
	ld [$FF81],a

	pop hl
	pop de
	pop bc
	pop af
irq_lcdc:
irq_timer:
irq_serial:
irq_hilo:
	reti

scroller:
	ld a,[$C001]
	cp 8
	jr z,a10
	ld [$FF42],a
	cp 3
	jr z,a11
	cp 5
	jr z,a12
	ret
a10:     
a11:
a12:
	ret

waitv:
	ld a,0
	ld [$C002],a
bh:
	ld a,[$C002]
	dec a
	jr nz,bh
	ret

initvid:
	ld a,131
	ld [$FF40],a
	ld a,0
	ld [$FF42],a
	ld [$FF43],a
	ld a,228
	ld [$FF47],a
	ld a,1
	ld [$FFFF],a
	ret

copything:
	ld de,thestinkysubthatneedstogoinhiram
	ld hl,$FFF0
	ld c,15
bn:
	ld a,[de]
	ldi [hl],a
	inc de
	dec c
	jr nz,bn
	ret

copyblocks2:
	ld de,blocks4
	ld hl,$8000
	ld bc,$0800
bl:
	ld a,[de]
	ldi [hl],a
	inc de
	dec c
	jr nz,bl
	dec b
	jr nz,bl
	ld de,blocks3
	ld hl,$9000
	ld bc,$0800
ea:
	ld a,[de]
	ldi [hl],a
	inc de
	dec c
	jr nz,ea
	dec b
	jr nz,ea
	ret

copyblocks:
	ld de,blocks1
	ld hl,$8010
	ld bc,$0800
be:
	ld a,[de]
	ldi [hl],a
	inc de
	dec c
	jr nz,be
	dec b
	jr nz,be
	ld de,blocks2
	ld hl,$8800
	ld bc,$0800
ba:
	ld a,[de]
	ldi [hl],a
	inc de
	dec c
	jr nz,ba
	dec b
	jr nz,ba
	ret

print:
	ld b,[hl]           ; print sub
	inc hl              ;
bb:                         ; put vram adr in de
	ld a,[hl]           ; put text adr in hl
	inc hl              ;
	add a,63            ;
	ld [de],a           ; length should be at start of text
	inc de              ;
	dec b               ;
	jr nz,bb
	ret

setpal:
	ld hl,palette
	ld c,0
bo:
	ld b,0
	ld d,4
bq:
	ld a,c
	sla a
	sla a
	sla a
	add b
	add b
	ld e,a
	ld [$FF68],a
	ld a,[hl]
	ld [$FF69],a
	ld a,e
	inc a
	inc hl
	ld [$FF68],a
	ld a,[hl]
	ld [$FF69],a
	inc hl
	inc b
	dec d
	jr nz,bq
	inc c
	ld a,c
	sub 8
	jr nz,bo
	ld c,0
br:
	ld b,0
	ld d,4
bs:
	ld a,c
	sla a
	sla a
	sla a
	add b
	add b
	ld e,a
	ld [$FF6A],a
	ld a,[hl]
	ld [$FF6B],a
	ld a,e
	inc a
	inc hl
	ld [$FF6A],a
	ld a,[hl]
	ld [$FF6B],a
	inc hl
	inc b
	dec d
	jr nz,bs
	inc c
	ld a,c
	sub 8
	jr nz,br

	ret

clearmap:
	ld hl,$9800
	ld bc,$0400
	ld a,c
	ld [$FF4F],a
bd:
	ldi [hl],a
	dec c
	jr nz,bd
	dec b
	jr nz,bd

	ld hl,$9800
	ld bc,$0400
	ld a,1
	ld [$FF4F],a
	ld a,c
bp:
	ldi [hl],a
	dec c
	jr nz,bp
	dec b
	jr nz,bp

	ld a,0
	ld [$FF4F],a
	ret

clearspr:
	ld hl,$D000
	ld bc,$0100
	ld a,c
bm:
	ldi [hl],a
	dec c
	jr nz,bm
	dec b
	jr nz,bm
	ret

waitkey:
	ld a,[$FF80]
	and a,c
	jr nz,waitkey
	ret

words4:
	db 3,"JET"
words5:
	db 7,"FIGHTER"
words6:
	db 12,"PRESS  START"
zdata:
	db -9,104,1,0
	db -9,112,2,0
	db -9,120,3,0
	db -1,104,4,0
	db -1,112,5,0
	db -1,120,6,0
	db 7,104,7,0
	db 7,112,8,0
	db 7,120,9,0
blocks1:
	incbin "gbspr"
blocks2:
	incbin "gbfont"
blocks3:
	incbin "gbback"
blocks4:
	dw 0,0,0,0,0,0,0,0
	dw 0,0,0,0,0,0,0,0
	incbin "gbspr2"

thestinkysubthatneedstogoinhiram:

	ld a,$D0
	ld [$FF46],a
	ld a,$28
bg:                           ; sprite DMA
	dec a
	jr nz,bg
	ret

palette:
	dw $0000,$0000,$0000,$7FFF
	dw $0000,$0200,$02E0,$0000
	dw $0000,$0000,$0000,$0000
	dw $0000,$0000,$0000,$0000
	dw $0000,$0000,$0000,$0000
	dw $0000,$0000,$0000,$0000
	dw $0000,$0000,$0000,$0000
	dw $0000,$0000,$0000,$0000

	dw $0000,$0000,$0200,$4000
	dw $0000,$4210,$2108,$1084
	dw $0000,$01FF,$0110,$0000
	dw $0000,$0000,$0000,$0000
	dw $0000,$0000,$0000,$0000
	dw $0000,$0000,$0000,$0000
	dw $0000,$0000,$0000,$0000
	dw $0000,$0000,$0000,$0000

level1:
;        incbin "level1"

	SECTION "linedata",DATA[$6000],BANK[1]
;        incbin "lines1"
