; STRANGE GAME
;
; RCR... the RCR register value -64 is when the IRQ happens
; the written vscroll value is the line that gets displayed??
;
;
;RAM map
;
;$2000   vblank (cleared at during vbint)
;$2001-2 controller status
;$2003   current position in vertical scroll lookup table
;$2004   beginning position for lineints
;$2005-6 stuff
;$2007-8 STUFF
;$2009-A scroll h
;$200B-C scroll v
;$200D   current lineint position
;
;$2020-2 temp storage for GRB values
;$2023   used within fadepal
;$2024   more misc        (used by fadepal)
;$2025-6 pointer used by fadepal (and misc)
;$2027   more misc        (used by fadepal and windraw)
;
;$2030-2 low/high/bank pointer to wav data
;$2033   next sample to be written (MONO, or LEFT channel)
;$2034-6 low/high/bank pointer to end of wav
;$2037   zero if sample should loop, otherwise play only once
;$2038-A backup copy of $30-32 for looping
;$203B   next sample to be written (RIGHT channel)
;$203C   zero for 8-bit WAV, else 4-bit
;$203D   zero for MONO, else stereo
;$203E   bytes per interrupt
;$203F   zeroed when sample finishes playing
;
;$2040-C  zooming stuff
;$204D   loop countdown
;$204E-F scene script pointer
;$2050-3 scaling factors 1
;$2054-7 scaling factors 2
;$2058-9 H offset (in blocks) and V offset
;$205A-B misc
;$205C-D offsets for plane 2
;$205E   nonzero when snake game begins
;$205F   nonzero when snake game ends and palette fade begins
;
;$2060-2 low, high, bank pointing to snake game replay data
;$2063   snake game replay SCORE
;
;$2070-1 pointer to string for str2spr
;$2072-4 misc used by str2spr
;$2075-7 used by end credits text
;
;$20A3   old copy of <$01 for controls
;$20A4   old copy of <$02 for controls
;
;$20AF   song bank
;$20B0-1 pointer for music
;$20B2   countdown until registers change
;$20B3   zeroed when music loops
;$20B4-6 music player work RAM
;
;$20BB-F vibrato (music player junk)
;
;$20EB-C controls stuff
;
;$2200-3F 64 zeros (for zoom renderer)
;$2240-7F 64 $FFs
;
;$2300-24FF sprite table
;
;$2540-9  frequencies (emulators don't like it when I read PSG regs)
;
;$25F8-FA music loop address (bank, low, high)
;
;$26C8-C  volume
;$26CD-D1 attack
;$26D2-D6 decay1
;$26D7-DB decay2
;$26DC-E0 T1L
;$26E1-E5 release
;$26E6-EA state
;$26EB-F  active volume high byte
;$26F0-4  active volume low byte
;$26F5-9  panning
;
;$2700-27FF decompspr/str2spr buffer
;$2800-2FFF 2KB buffer for data decompression
;$3000 copy of zoomrender routine
;
;$3600-39FF current correct palette
;$3A00-3AFF lookup table for zoomrender
;
;$3C00-3FFF copy of palette for messing with (fadepal)
;

	.bank 0
	.org $FFF6

        .dw null_int    ; IRQ2 (BRK)
        .dw vb_int      ; IRQ1 (VDC)
        .dw timer_int   ; TIMER
        .dw null_int    ; NMI (not used)
        .dw reset_int   ; RESET

	.org $E000

        .db "created by DamageX 2012/02/18"
timer_int:
        pha
;        phx
        phy

        ldy #5
        sty $0800
        lda <$33
        sta $0806
        lda <$3D
        beq a172
        dey
        sta $0800
        lda <$3B
        sta $0806
a172:

        tma #2
        pha

        lda <$3E
        clc
        adc <$30
        sta <$30
        bcc a200
        inc <$31
        lda #$60
        cmp <$31
        bne a200
        inc <$32
        lda #$40
        sta <$31
a200:

        ; check for the end of data
        lda <$34
        cmp <$30
        bne a201
        lda <$35
        cmp <$31
        bne a201
        lda <$36
        cmp <$32
        bne a201
        lda <$37
        beq a202
        ; stop timer
        stz $0C01
        stz <$3F
a202:
        ; reload sample address
        lda <$38
        sta <$30
        lda <$39
        sta <$31
        lda <$3A
        sta <$32
a201:

        lda <$32
        tam #2

        lda <$3C        
        beq a169
        lda [$30]       ; assume 4-bit wavs are also stereo
        tay
        lsr a
        lsr a
        lsr a
        and #30
        sta <$3B
        tya
        asl a
        and #30
        sta <$33
        bra a168
a169:

        lda [$30]       ; wav is 8-bit
        lsr a
        lsr a
        lsr a
        sta <$33
        lda <$3D
        beq a168
        ldy #1
        lda [$30],y
        lsr a
        lsr a
        lsr a
        sta <$3B
a168:


        pla
        tam #2

        ply
 ;       plx
        pla
        stz $1403
        rti

lineint:
        lda <$04
        beq a149

        ldx <$03
        cpx #32
        bne a151
a282:
        st0 #5
        st1 #$4C        ; turn off BG
        st2 #0
        jmp a147
a151:
        inc <$0D
        beq a282
        st0 #6
        lda <$0D
        sta $0002
        st2 #0
        inc <$03
        st0 #8
        clc
        adc vsraml,x
        cmp #223
        bcc a285
        cla
a285:
        sta $0002
        st2 #0
a149:
        jmp a147

vb_int:
	pha
	phx
	phy

	lda $0000
        and #4
        bne lineint

        ldy <$04
        beq a150
        clx
        cpy #64
        bcs a283
        lda #65
        sbc <$04
        tax
        ldy #64
a283:
        stx <$03        ; reset lookup table index
        st0 #6
        sty $0002       ;
        st2 #0          ; set lineints beginning position
        sty <$0D        ; 
        st0 #8
        st1 #0
        st2 #0
        st0 #5
        st1 #$CC        ; enable RCR and stuff
        st2 #0
a150:

	lda <$02            
	sta <$A4            ; controller status last frame
	lda <$01            ;
	sta <$A3
	lda #1
	sta $1000
	lda #3
	sta $1000
	lda #1
	sta $1000
	pha
	pla
	nop
	lda $1000
	sta <$02              ; inverse L D R U
        eor #255
        and <$A4
        sta <$EC
	lda #0
	sta $1000
	pha
	pla
	nop
	lda $1000
	sta <$01              ; R S I II
        eor #255
        and <$A3
        sta <$EB

; music player !        

	lda <$AF
	bne a322
	jmp a_323i
a322:
	tma #4
	pha
	lda <$AF
	tam #4
	cly
a315:                         ; big loop for emulating envelope
	tya
	tax
	lda $26E6,y
	bne a316
	lda $26E1,y           ; key off
	jsr subvol
	bra a317
a316:
	cmp #1                ; key on
	bne a_320i
	lda $26CD,y
	lsr a
	bcc a831
	pha
	lda $26F0,y
	adc #127
	sta $26F0,y
	pla
a831:
	adc $26EB,y
	sta $26EB,y
	cmp $26C8,y
	bcc a317
	lda $26C8,y
	sta $26EB,y
	inc $26E6,x
	bra a317
a_320i:
	cmp #2                ; decay 1
	bne a321

	lda $26D2,y
	jsr subvol

        stz <$B4
	cla
        phy
	ldy $26DC,x
	beq a836
a834:
	clc
	adc $26C8,x
	bcc a835
        inc <$B4
a835:
	dey
	bne a834
        lsr <$B4
	ror a
        lsr <$B4
	ror a
	lsr a
	lsr a
	lsr a
a836:
        ply
	cmp $26EB,y
	bcc a317
	inc $26E6,x
	bra a317
a321:
	lda $26F0,y           ; decay 2
	sec
	sbc $26D7,y
	sta $26F0,y
	bcs a317
	dec $26EB,x
a317:
	iny
	cpy #5
        beq a833
        jmp a315
a833:

        ldx #4
a_318i:
        lda $26EB,x
	bpl a319              ; check bounds
        stz $26EB,x           ;
        cla
a319:
        stx $0800
	ora #128              ; store volumes
	sta $0804             ;
        lda $26F5,x
	sta $0805
        dex
        bpl a_318i

	lda <$B2
	beq a307
	dec <$B2
	jmp a314
a307:
	lda [$B0]
	tax
	jsr incbzero
        cmp #253
        bne a1061
        lda <$AF
        sta $25F8
        lda <$B0              ; store address for
        sta $25F9             ; beginning of loop
        lda <$B1
        sta $25FA
        bra a307
a1061:
        cmp #254
	bne a326
        lda $25F9
        sta <$B0
        lda $25FA             ; LOOP
        sta <$B1              ;
        lda $25F8
        sta <$AF
	tam #4
        stz <$B3
	bra a307
a326:
	and #224
	bne a310
	lda [$B0]             ;
	sta $26C8,x           ; set a register
	jsr incbzero          ;
        bra a307
a310:
	cmp #32
	bne a312              ;
	txa                   ; wait frames
	and #31               ;
	sta <$B2
	bra a314
a312:
	cmp #64
	bne a308
	txa
        and #14               ;
	lsr a                 ; key off/on
	tay                   ;
	txa
	and #1
	sta $26E6,y
        bra a307
a308:
	cmp #96
	bne a395
	txa                   ;
	and #16               ; vibrato on/off
	tay                   ;
	txa
	and #7
	tax
	sty <$BB,x
        jmp a307
a395:
        cmp #192                
	bne a837
	txa
	and #7
	tax
        lda [$B0]             ; panning
        jsr incbzero
;        ldy $26FA
;        beq a838
;        lda #255
;a838:
	sta $26F5,x
	jmp a307
a837:
;        cmp #128
 ;       bne a313
	txa
        and #56               ;
	lsr a                 ; frequency change
	lsr a                 ;
        lsr a
	sta $0800
	tay
	txa
        and #7
	sta $2545,y
	sta $0803
	lda [$B0]
	sta $0802
	sta $2540,y
	jsr incbzero
        cla
        sta $20BB,y             ; automatically turn off vibrato
;        bra a307
a313:
	jmp a307
       
a314:

        ldx #4
a396:
	lda <$BB,x
	beq a397
	inc a
	cmp #26
	bne a398
	lda #16
a398:
	sta <$BB,x
	ldy $2545,x
	bne a399
	ldy $2540,x
	cpy #140
	bcs a399
;        clc
	adc #10
a399:
	tay
	stx $0800
        lda (vibpat-16),y
        sta <$B6
        cmp #255
        beq a880
        cla
a880:
        pha
        lda $2540,x
	clc
        adc <$B6
	sta $2540,x
	sta $0802
        pla
        adc $2545,x
        sta $0803
        sta $2545,x
a397:
        dex
        bpl a396

	pla
	tam #4

a_323i:
	stz <$00

a147:
	ply
	plx
	pla
null_int:
	rti

incbzero:
	inc <$B0
	bne a390
	pha
	inc <$B1
	lda <$B1
	cmp #$A0
        bne a881
	lda #$80
	sta <$B1
	inc <$AF
	lda <$AF
	tam #4
a881:
        pla
a390:
	rts

reset_int:
	sei                   ; disable interrupts 
	csh                   ; select the 7.16 MHz clock
	cld                   ; clear the decimal flag 
	lda #$FF              ; page 0 is i/o
	tam #0
        lda #$F8              ; page 1 is internal ram
	tam #1
        stz $0C01             ; stop the timer
	stz $2000             ; clear all the RAM
	tii $2000,$2001,$1FFF
	ldx #$FF              ; initialize the stack
	txs

	jsr initpsg           ; and the sound generator

        jsr clearvram
        jsr clearpal
        jsr initvid512

        cli

; Title Screen START

        st0 #0
        st1 #0
        st2 #$10
        st0 #2
;        tia logoset,$0002,$6000

        lda #LOW(logoset)
        sta <$05
        lda #HIGH(logoset)
        sta <$06
        lda #BANK(logoset)
	tam #2
        inc a
        tam #3
        jsr decomplzm

        lda #LOW(logomap)
        sta <$05
        lda #HIGH(logomap)
        sta <$06
        lda #BANK(logomap)
        tam #4

        jsr loadmap

        ; title screen sprites
        st0 #0
        st1 #0
        st2 #$60
        st0 #2
        lda #LOW(titlespr)
        sta <$05
        lda #HIGH(titlespr)
        sta <$06
;        lda #BANK(titlespr)
 ;       tam #4
        lda #24
        sta <$20
        jsr decompspr
        tii fishpal,$3800,$0080
        jsr palette1

        ; title screen palette
        tii logopal,$3600,$0200
        jsr waitv
	stz $0402
	stz $0403
        lda $3600
	sta $0404
        lda $3601
	sta $0405
        lda #120
a244:
        bbs0 <$01,a254
        jsr palette1
        jmp scene1end
a254:
        jsr waitv
        dec a
        bne a244

        ; 16-tile fade-in effect

        stz <$05
        lda #$36
        sta <$06
        lda #16
        sta <$5A
a240:
        lda #7
        sta <$20
        sta <$21
        sta <$22
        inc a
        sta <$5B
a241:
        jsr palmod1
        jsr waitv
        jsr waitv
        jsr a72
        dec <$20
        dec <$21
        dec <$22
        dec <$5B
        bne a241

        lda <$05
        clc
        adc #$20
        sta <$05
        bcc a242
        inc <$06
a242:
        dec <$5A
        bne a240
        

        jsr initwav
        inc <$37

        inc <$3F
a234:
        lda <$3F
        bne a234

        tii fishspr,$2300,$0028

        ldx #BANK(strangetro)
        lda #LOW(strangetro)
        sta <$B0
        lda #HIGH(strangetro)
        sta <$B1
	jsr initmus

        inc <$B3
a235:
        jsr waitv
        jsr copyspr2vid

        inc <$5A        ; frame counter for animations

        ; bolt animation
        lda <$5A
        and #16
        lsr a
        ora #32
        sta $2314
        lda $2312
        sec
        sbc #1
        sta $2312
        bcs a269
        dec $2313
a269:        
        ; fish animation
        lda <$5A
        and #16
        sta $2304
        ora #8
        sta $230C
        inc $2302
        bne a248
        inc $2303
a248:
        inc $230A
        bne a249
        inc $230B
a249:

        ; fish2 animation
        lda <$5A
        asl a
        and #16
        sta $231C
        ora #8
        sta $2324
        lda $231B
        cmp #3
        beq a298
        ldx #2
a297:
        inc $231A
        bne a295
        inc $231B
a295:
        inc $2322
        bne a296
        inc $2323
a296:
        dex
        bne a297
a298:

        lda <$B3
        bne a235

scene1end:
        stz <$AF
        jsr initpsg

        ; roll-up effect
        lda #255
a280:
        sta <$04
        jsr waitv
        jsr waitv
        dec a
        cmp #33
        bne a280

        stz <$04
        st0 #5
        st1 #$C8        ; disable RCR
        st2 #0

; Scene 2 START

        stz <$62
        stz <$5E
        stz <$5F
	jsr clearvram         ; duh

        jsr initvid256        ; initialize the video controller

        jsr initscaler

        tii zoompal1,$3600,$0020
	jsr palette1          ; set palette

        ldx #BANK(dance)
        lda #LOW(dance)
        sta <$B0
        lda #HIGH(dance)
        and #$1F
        ora #$80
        sta <$B1
	jsr initmus

        stz <$4D

        lda #LOW(scene2s)
        sta <$4E
        lda #HIGH(scene2s)
        sta <$4F

        ldy #255
a218:
        iny
a214:
        lda [$4E],y
        bmi a215
a216:
        jsr waitv       ; wait for _ frames
        dec a
        bpl a216
        bra a218
a215:
        iny
        cmp #128        ; swap buffers
        bne a217
        bbs0 <$01,a286
        jsr fadepal
        jmp scene2end
a286:
        lda <$5F
        cmp #136
        bne a271
        jmp scene2end
a271:
        jsr waitv
        lda <$5E
        beq a258
        phy
        jsr snakereplay
        ply
a258:
        lda <$44
        eor #1
        sta <$44
        beq a122
        st0 #7
        st1 #0
        st2 #0
        bra a214
a122:
	st0 #7
        st1 #0
        st2 #1
        bra a214
a217:
        cmp #129
        bne a219
        phy
        jsr clearplane
        ply
        bra a214
a219:
        cmp #130
        bne a233
        phy
        jsr clearplane2
        ply
        bra a214
a233:
        cmp #131
        bne a220
        phy
        jsr zoomrender
        ply
        bra a214
a220:
        cmp #132
        bne a222
        phy
        jsr zoomrender2
        ply
        bra a214
a222:
        cmp #133        ; loop
        bne a229
        lda <$4D
        beq a230
        dec <$4D
        bne a231
        jmp a218
a230:
        lda [$4E],y
        sta <$4D
a231:
        cly
        jmp a214
a229:
        cmp #134
        bne a243
        tii zoompal1+32,$3600,$0060
	jsr palette1          ; set palette
        jmp a214
a243:
        cmp #135
        bne a255                ; bah humbug
        tya
        clc
        adc <$4E
        sta <$4E
        bcc a256
        inc <$4F
a256:
        cly
        jmp a214
a255:
        cmp #136
        bne a257                ; jump
        lda [$4E],y
        tax
        iny
        lda [$4E],y
        stx <$4E
        sta <$4F
        cly
        jmp a214
a257:

        pha
        and #15
        tax
        pla
        and #$F0
        cmp #$90        ; set a byte in scaling data
        bne a228
        lda [$4E],y
        sta <$50,x
        jmp a218
a228:
        cmp #$A0        ; set a word in scaling data
        bne a223
        lda [$4E],y
        sta <$50,x
        iny
        inx
        lda [$4E],y
        sta <$50,x
        jmp a218
a223:
        cmp #$B0        ; add a byte to a word
        bne a224
        lda [$4E],y
        clc
        adc <$50,x
        sta <$50,x
        bcc a225
        inc <$51,x
a225:
        jmp a218
a224:
;        cmp #$C0        ; subtract a byte from a word
 ;       bne a226
        lda <$50,x
        sec
        sbc [$4E],y
        sta <$50,x
        bcs a227
        dec <$51,x
a227:
        jmp a218
;a226:

scene2end:

        ; SCENE 3 START

        jsr initvid512
        jsr clearvram

        stz <$AF
        jsr initpsg

        st0 #0
        st1 #0
        st2 #$10
        st0 #2

        lda #BANK(turboset)
        tam #2
        inc a
        tam #3
        inc a
        tam #4
        inc a
        tam #5
        inc a
        tam #6

        lda #LOW(turboset)
        sta <$05
        lda #HIGH(turboset)
        sta <$06
        jsr decomplzm

        lda #LOW(turbomap)
        sta <$05
        lda #HIGH(turbomap)
        sta <$06
        lda #BANK(turbomap)
        tam #2

        tii turbopal,$3600,$0200
        tii tankpal,$3820,$0020

        lda #$C7
        sta $3802
        lda #1
        sta $3803

        jsr loadmap

        ; fade back
        lda #6
a272:
        sta <$20
        sta <$21
        sta <$22
        pha
        jsr palmod
        jsr waitt
        jsr a72
        pla
        dec a
        bpl a272

        stz $2300
        tii $2300,$2301,$01FF

        ldx #BANK(creds)
        lda #LOW(creds)
        sta <$B0
        lda #HIGH(creds)
        and #$1F
        ora #$80
        sta <$B1
	jsr initmus

        ; end credits
        st0 #0
        st1 #0
        st2 #$7D
        st0 #2
        lda #LOW(blastgfx)
        sta <$05
        lda #HIGH(blastgfx)
        sta <$06
        lda #12
        sta <$20
        jsr decompspr
        tii tankspr,$2340,$0010

        ; tank entrance
        ldx #136
a302:
        jsr waitv
        lda $2342
        sec
        sbc #1
        sta $2342
        bcs a303
        dec $2343
a303:
        lda $234A
        sec
        sbc #1
        sta $234A
        bcs a304
        dec $234B
a304:
        jsr copyspr2vid
        dex
        bne a302

        ; text address
        lda #LOW(string1)
        sta <$70
        lda #HIGH(string1)
        sta <$71

        ; credits text display loop
        lda #12
        sta <$77
a291:
        ldx #100
        jsr a14

        jsr str2spr

        lda <$70
        clc             ;
        adc #28         ; advance to next string
        sta <$70        ;
        cla
        adc <$71
        sta <$71

        tii blastspr,$2300,$0008
        jsr waitv
        jsr copyspr2vid
        jsr waitt

        tii stringspr,$2308,$0038

        ; text sprites movement
        lda #LOW(sprpos)
        sta <$72
        lda #HIGH(sprpos)
        sta <$73
        lda #60
        sta <$75
a289:
        jsr waitv
        jsr copyspr2vid

        dec <$75
        beq a301

        ; blast animation
        lda <$75
        lsr a
        lsr a
        lsr a
        cmp #4
        bcs a305
        stz $2300       ; disappear it
        stz $2301
a305:
        eor #7
        asl a
        adc #$E8
        sta $2304

        ; text trajectory
        cly
a290:
        tya
        asl a
        asl a
        asl a
        tax
        lda $2308,x
        sec
        sbc #1
        sta $2308,x
        bcs a292
        dec $2309,x
a292:
        lda [$72]
        inc <$72
        bne a293
        inc <$73
a293:
        sta $230A,x
        lda [$72]
        inc <$72
        bne a294
        inc <$73
a294:
        sta $230B,x
        iny
        cpy #7
        bne a290
        bra a289

a301:
        ldx #230
        jsr a14

        ; falling text
        lda #26
        sta <$75
        stz <$76
        stz <$78
        lda $2308
        sta <$7A
        lda $2309
        sta <$7B
a299:
        jsr waitv

        lda <$76
        lsr a
        clc
        adc <$78
        sta <$78
        sta <$79

        cly
a300:
        tya
        asl a
        asl a
        asl a
        tax

        lda <$79
        bmi a306
        sec
        sbc #5
        bpl a309
        cla
a309:
        sta <$79
a306:

        lda <$7A
        clc
        adc <$79
        sta $2308,x
        cla
        adc <$7B
        sta $2309,x

        iny
        cpy #7
        bne a300

        jsr copyspr2vid
        inc <$76
        dec <$75
        bne a299

        dec <$77
        bne a288
        jsr fadepal
        jmp reset_int
a288:
        jmp a291


tankspr:
        .dw $00DB,$0220,$03F0,$1181
        .dw $00DB,$0240,$03F8,$1181

; 123-132 numbers
; 148 period
; 149 question mark
; 150 comma
; 151 exclamation point
; 152 apostrophe
; 153 @

string1:
        .db "       STRANGE GAME         "
        .db "  Presented at ",153,"party ",125,123,124,125,"  "
        .db "     Program by DamageX     "
        .db "   Photography by DamageX   "
        .db " Image conversion by DamageX"
        .db " Data compression by DamageX"
        .db "   Lame music by DamageX    "
        .db "      Thanks go to",148,148,148,"       "
        .db "   PCE emulation pioneers   "
        .db "          ic",125,123,123,128,"            "
        .db "            NEC             "
        .db "          THE END           "

;        .db "                            "

blastspr:
        .dw $00D3,$0190,$03E8,$0081
stringspr:
        .dw $00CB,$0190,$0040,$0180
        .dw $00CB,$0190,$0044,$0180
        .dw $00CB,$0190,$0048,$0180
        .dw $00CB,$0190,$004C,$0180
        .dw $00CB,$0190,$0050,$0180
        .dw $00CB,$0190,$0054,$0180
        .dw $00CB,$0190,$0058,$0180

initscaler:
        stz $2200
        tii $2200,$2201,$0040
        dec $2240
        tii $2240,$2241,$003F

        lda #BANK(zoomrender)
        tam #4
        tii $9000,$3000,(renderend-zoomrender)

        st0 #0
        st1 #0
        st2 #0
        st0 #2

        ; build a fixed map
        ldy #27
        sty <$05
        lda #0
        ldy #1
a100:

        ; use even character addresses for left buffer
        pha
        phy
        ldx #32
a101:
        sta $0002
        sty $0003
        clc
        adc #2
        bcc a102
        iny
a102:
        dex
        bne a101

        ; use odd character addresses for right buffer
        ply
        pla
        inc a
        ldx #32
a103:
        sta $0002
        sty $0003
        clc
        adc #2
        bcc a104
        iny
a104:
        dex
        bne a103

        dec a

        dec <$05
        bne a100

        stz <$44        ; current buffer
        
        st0 #5
;        st1 #$CC        ; enable RCR
        st1 #$C8
        st2 #8          ; switch to +32 increment for writes

        rts


initwav:
        stz <$37        ; loop sample

        lda #LOW(wav+44)
        sta <$30
        sta <$38
        lda #HIGH(wav+44)
        sta <$31
        sta <$39
        lda #BANK(wav+44)
        sta <$32
        sta <$3A

        tam #2

        lda #LOW(wavend)
        sta <$34
        lda #HIGH(wavend)
        sta <$35
        lda #BANK(wavend)
        sta <$36

        lda #5
        sta $0800       ; channel 5
        ldx #$DF
        stx $0804
        lda #$FF
        sta $0805

        lda wav+22      ; number of channels in wav
        dec a
        sta <$3D
        beq a203
        lda #$F0
        sta $0805
        lda #4
        sta $0800       ; channel 4
        stx $0804
        lda #$0F
        sta $0805
        lda #1
a203:
        inc a

        stz <$3C        ; bits/sample
        ldy wav+34
        cpy #4
        bne a236
        sty <$3C
        lsr a
a236:
        sta <$3E        ; bytes/interrupt

        lda #0
        sta $0C00       ; timer period
        lda #1
        sta $0C01       ; timer enable (bit 0)
        rts

initpsg:
	clx
a170:
	stx $0800
	stz $0804
        stz $0807
	inx
	cpx #6
	bne a170
        stz $0809
	ldx #$FF
	stx $0801
	rts

initvid256:
        lda #LOW(vidregs256)
        sta <$05
        lda #HIGH(vidregs256)
        sta <$06
        bra a161

initvid352:
        lda #LOW(vidregs352)
        sta <$05
        lda #HIGH(vidregs352)
        sta <$06
        bra a161

initvid512:
        lda #LOW(vidregs512)
        sta <$05
        lda #HIGH(vidregs512)
        sta <$06

a161:
        cly
a148:
        lda [$05],y
        bmi a141
        iny
        sta $0000
        lda [$05],y
        iny
        sta $0002
        lda [$05],y
        iny
        sta $0003
        bra a148
a141:
        iny
        lda [$05],y
        sta $0400             ; color clock 
	rts

clearpal:
        stz $3C00
        tii $3600,$3601,$03FF
        bra a72

palette1:
	tii $3600,$3C00,$0400

        jsr waitv

a72:
	stz $0402
	stz $0403
	clx
a3:
	lda $3C00,x
	sta $0404
	inx
	lda $3C00,x
	sta $0405
	inx
	bne a3
a4:
	lda $3D00,x
	sta $0404
	inx
	lda $3D00,x
	sta $0405
	inx
	bne a4
a40:
	lda $3E00,x
	sta $0404
	inx
	lda $3E00,x
	sta $0405
	inx
	bne a40
a41:
	lda $3F00,x
	sta $0404
	inx
	lda $3F00,x
	sta $0405
	inx
	bne a41

	rts

fadepal:
        stz <$20
        stz <$21
        stz <$22

        ldy #8
a67:
        phy

        dec <$20
        dec <$21
        dec <$22

        jsr palmod
	jsr waitt
	jsr a72

        ply

        dey
	bne a67
	rts

palmod1:
        ; do one palette (in $05-6) instead of the entire thing
        lda #1
        sta <$27
        lda #16
        sta <$23

        lda <$05
        sta <$24
        sta <$E1
        lda <$06
        sta <$25
        clc
        adc #6
        sta <$E2

        bra a867
palmod:

        stz <$24
        lda #$36
        sta <$25

        stz <$E1
        lda #$3C
        sta <$E2

        lda #2
        sta <$27

        stz <$23
a867:
        cly
a859:
        lda [$24],y
        sta <$26
        tax
        iny
        lda [$24],y
        asl <$26
        rol a
        asl <$26
        rol a
        clc
        adc <$20
        bpl a860
        cla
a860:
        cmp #8
        bcc a861
        lda #7
a861:
        stz <$26
        lsr a
        ror <$26
        lsr a
        ror <$26
        pha
        txa
        iny
a862:
        and #7
        clc
        adc $2020,y
        bpl a863
        cla
a863:
        cmp #8
        bcc a864
        lda #7
a864:
        dey
        beq a865
        ora <$26
        sta <$26
        txa
        lsr a
        lsr a
        lsr a
        bra a862
a865:
        asl a
        asl a
        asl a
        ora <$26
        sta [$E1]
        inc <$E1
        pla
        sta [$E1]
        inc <$E1
        bne a866
        inc <$25
        inc <$E2
a866:
        lda <$E1
        sta <$24

        dec <$23
        bne a859

        dec <$27
        bne a859

        rts

clearplane:
        clx
        bra a211
clearplane2:
        ldx #4
a211:
        lda <$44
        beq a212
        lda #16
a212:
        cpx #4
        beq a213
        clc
        adc #8
a213:
        sta <$07        ;
        lda #$10        ; vram write address
        sta <$08        ;

        ldy #215        ; number of lines to clear
a145:
        st0 #0
        lda <$07
        sta $0002
        lda <$08
        sta $0003
        st0 #2

        ; fill line with transparent/background pixels
        cpx #4
        beq a250
        tia $2200,$0002,$0040
        bra a251
a250:
        tia $2240,$0002,$0040
a251:

        inc <$07
;        bne a143
;        inc <$08
;a143:
        tya
        and #7
        bne a144
        lda <$07
        clc
        adc #$F8
        sta <$07
        lda <$08
        adc #3
        sta <$08
a144:

        dey
        bne a145
        rts

clearvram:
	st0 #0
	st1 #0
	st2 #0
	st0 #2

	clx
	ldy #128
a2:
	st1 #0
	st2 #0
	dex
	bne a2
	dey
	bne a2

	rts

waitt:
	ldx #4
a14:
	jsr waitv
	dex
	bne a14
	rts

waitv:
	phy
	ldy #1
	sty <$00
a6:
	ldy <$00
	bne a6
	ply
	rts


vidregs256:
        .db 5,$C8,0
        .db 7,0,0
        .db 8,0,0
        .db 9,$D0,0
        .db 10,3,2
        .db 11,31,6
        .db 12,2,$17
        .db 13,215,0
        .db 14,3,0
        .db 15,$10,0
        .db 19,0,15
        .db 128,4

vidregs352:
        .db 5,$C8,0
        .db 7,0,0
        .db 8,0,0
        .db 9,$D0,0
        .db 10,3,3
        .db 11,43,6
        .db 12,2,$17
        .db 13,223,0
        .db 14,3,0
        .db 15,$10,0
        .db 19,0,127
        .db 128,5

vidregs512:
        .db 5,$C8,0
        .db 7,0,0
        .db 8,0,0
        .db 9,$D0,0
        .db 10,3,11
        .db 11,63,6
        .db 12,2,$17
        .db 13,223,0
        .db 14,3,0
        .db 15,$10,0
        .db 19,0,15
        .db 128,6

loadmap:
        st0 #0
        st1 #0
        st2 #0
        st0 #2
        lda [$05]
        sta <$08        ; map wdith
        ldy #1
        lda [$05],y
        sta <$07        ; map height

        lda <$05
        clc
        adc #2
        sta <$05
        bcc lm24
        inc <$06
lm24:

        cly
lm26:
        ldx <$08
lm25:
        lda [$05],y
        iny
        sta $0002
        lda [$05],y
        sta $0003
        iny
        bne lm29
        inc <$06
lm29:
        dex
        bne lm25
        lda #64
        sec
        sbc <$08
        beq lm28
        tax
lm27:
        st1 #0
        st2 #0
        dex
        bne lm27
lm28:
        dec <$07
        bne lm26
        rts

copyspr2vid:
        st0 #0
        st1 #0
        st2 #$0F
        st0 #2
        tia $2300,$0002,$0200
        rts

decompspr3:
        st0 #5
        st1 #$C8
        st2 #0          ; switch to +1 increment for writes

        st0 #0
        st1 #0
        st2 #8
        st0 #2

decompspr:
        ;<$20 has number of sprite blocks to decompress
        ;$05-$06 has the source address
;        stz <$E2        
;decompspr2:
        stz $239D               ; was 237D
	clx
a405:
	lda [$05]
	inc <$05
	bne a406
	inc <$06
a406:
	tay
	and #15
	say
a407:
        sta $2700,x
	inx
	beq a408
a415:
        dey
        bpl a407
	bra a405
a408:
	pha
	phy

	; copy buffer to VRAM
	ldy #16
;        ldy #1
	sty <$7A
a411:
	ldy #16
a410:
;        stz <$22
a409:
	asl <$22
	rol <$23
        lda $2700,x
	and <$7A
	beq a413
	inc <$22
a413:
	inx
	txa
	and #15
	bne a409
	lda <$22
	sta $0002
	lda <$23
	sta $0003
	dey
	bne a410

	clx
	lda <$7A
	asl a
;        cmp #16
	beq a414
	sta <$7A
	bra a411
a414:
	ply
	pla
	dec <$20
        beq a643
        jmp a415
a643:
        rts

a648:
        tia $2800,$0002,$0800
        
decomplzm:
;        lda <$07        ; $07 and $08 contain destination address
 ;       sta <$10
  ;      lda <$08
   ;     sta <$11
        stz <$07
        stz <$10
        lda #$28
        sta <$08
        sta <$11

        cly    
        lda [$05]       ; $05 and $06 contain source address
        sta <$12
        inc <$05
        bne a640
        inc <$06
        bra a640

a657:
        inc <$06
        bra a639
a640:
        lda [$05]       ; get a byte
        inc <$05
        beq a657
a639:
        cmp <$12        ; is it the doodad?
        bne a641
        lda [$05]       ; if yes, get another byte
        inc <$05
        bne a642
        inc <$06
a642:
        cmp #0          ; next byte was 0, end of block
        beq a648
        cmp #1          ; next byte was 1, output the doodad
        bne a647
        lda <$12
        sta [$07]  
        inc <$07
        bne a640
        inc <$08
        bra a640
a647:
        cmp #2          ; next byte was 2, end of file
        bne a644
        tia $2800,$0002,$0800
        rts
a644:
        tax             ; next byte was count for a copy
        lda [$05]  
        clc
        adc <$10
        sta <$25
        inc <$05
        bne a645
        inc <$06
a645:
        lda [$05]  
        adc <$11
        sta <$26
        inc <$05
        bne a646
        inc <$06
a646:
        ; copy the crap
        lda [$25],y
        sta [$07],y
        iny
        dex
        bne a646

        ; update dest. address
        tya
        cly
        clc
        adc <$07
        sta <$07
        bcc a640
        inc <$08
        bra a640

a641:
        sta [$07]               ; put a byte
        inc <$07
        bne a640
        inc <$08
        jmp a640

snakereplay:
        lda <$5F
        bmi a273
        bne a274
        ; step 1 - put up READY sprite
        lda #LOW(ready)
        sta <$05
        lda #HIGH(ready)
        sta <$06
        lda #BANK(ready)
        tam #4
        lda #4
        sta <$20
        jsr decompspr3
        st0 #0
        st1 #0
        st2 #$0F
        st0 #2
        tia readyspr,$0002,$0010
        st0 #5
        st1 #$C8
        st2 #8          ; switch to +32 increment for writes
a276:
        inc <$5F
        rts
a274:
        inc a           ; step 2 - wait
        cmp #21
        bcc a276
        bne a270
        ; step 3 - take down READY
        st0 #0
        st1 #0
        st2 #$0F
        st0 #2
        st1 #0
        st2 #0
        st0 #0
        st1 #4
        st2 #$0F
        st0 #2
        st1 #0
        st2 #0
        ; and initialize replay pointer
        lda #255
        sta <$63
        lda #LOW(sreplay)
        sta <$60
        lda #HIGH(sreplay)
        sta <$61
;        lda #BANK(sreplay)
 ;       sta <$62
        bra a276
a273:
        ; ending palette fade
        inc <$5F
        and #127
        sta <$20
        sta <$21
        sta <$22
        jsr palmod
        jsr waitv
        jsr a72
        rts
a270:
        cmp #22
        bne a277
        sta <$5F
        ; step 4 - put up SCORE
        lda #LOW(score)
        sta <$05
        lda #HIGH(score)
        sta <$06
        lda #BANK(score)
        tam #4
        lda #24
        sta <$20
        jsr decompspr3
        st0 #0
        st1 #0
        st2 #$0F
        st0 #2
        tia scorespr,$0002,$0020
        st0 #5
        st1 #$C8
        st2 #8          ; switch to +32 increment for writes

a277:

        ; draw snake game graphics by changing BG palette assignments
        ; on BOTH screens
        lda #BANK(sreplay)
        tam #2
a260:
        lda [$60]
        bpl a259
        ; SPLODE!
;        lda #128
        sta <$5F
a262:
        rts
a259:
        inc <$60
        bne a261
        inc <$61
a261:
        cmp #0
        beq a262
        tax             ; calculate VRAM address for "plotting"
        lda [$60]
        inc <$60
        bne a264
        inc <$61
a264:
        sta <$20
        lda [$60]
        inc <$60
        bne a265
        inc <$61
a265:
        sta <$21
        cla
        lsr <$21
        ror a
        lsr <$21
        ror a
        adc <$20
        sta <$20
        jsr palplot
        lda <$20
        clc
        adc #$20
        sta <$20
        jsr palplot
        cpx #3
        bne a260
        ; updatescore
        inc <$63
        ldx #$6E
        cly
        lda <$63
a279:
        cmp #10
        bcc a278
        sbc #10
        ldx scorelut+1,y
        iny
        bra a279
a278:
        st0 #0
        st1 #$0A
        st2 #$0F
        st0 #2
        stx $0002
        st2 #0
        tay
        ldx scorelut,y
        st0 #0
        st1 #$0E
        st2 #$0F
        st0 #2
        stx $0002
        st2 #0
        jmp a260

palplot:
        st0 #1
        lda <$20
        sta $0002
        lda <$21
        sta $0003
        st0 #2
        ldy $0002               ; read
        lda $0003
        sta <$23

        st0 #0
        lda <$20
        sta $0002
        lda <$21
        sta $0003
        st0 #2
        lda <$23
        and #15                 ; modify
        cpx #1
        beq a268
        cpx #2
        bne a267
        ora #16
        bra a268
a267:
        ora #32
a268:
        sty $0002               ; write
        sta $0003
        rts


initmus:        
	stz <$AF
	stz <$BB
	stz <$BC
	stz <$BD
	stz <$BE
	stz <$BF
	stz $26C8
	tii $26C8,$26C9,$002C
	lda #238
	sta $26F5
	tii $26F5,$26F6,$0004

	tma #4
	pha

        stx <$AF
	txa
	tam #4

        ; read instrument assignments from beginning of DT
	cly
a324:
	lda [$B0]
        pha
	jsr incbzero
        iny
        cpy #5
        bne a324

        lda <$AF
        sta $25F8
        lda <$B0              ; store address for
        sta $25F9             ; beginning of loop
        lda <$B1              ; (default is beginning of song)
        sta $25FA

        ; write instrument data to PSG

a1055:
        dey
        pla
        phy
        jsr setwave
        ply
        cpy #0
        bne a1055

	pla
	tam #4
	rts

setwave:
	asl a
	asl a
	asl a
	asl a
	asl a
	sty $0800
	ldy #64
	sty $0804
        stz $0804
	tay
	ldx #32
a171:
	lda instruments,y
	sta $0806
	iny
	dex
	bne a171
	rts

subvol:
        stz <$B5
	asl a
        rol <$B5
	asl a
        rol <$B5
        sta <$B4
	lda $26F0,y
	sec
        sbc <$B4
	sta $26F0,y
	lda $26EB,y
        sbc <$B5
	sta $26EB,y
	rts

str2spr:
        lda #1
        tam #4
        ; font is at $8000

        st0 #0
        st1 #0
        st2 #8
        st0 #2

        lda #28
        sta <$74        ; number of characters

        cly
a345:
        lda [$70],y
        iny
        cmp #96                 ; check CaSe
	bcc a348
	sec
	sbc #6
a348:
        cmp #32                 ; space
        beq a344
	sec
	sbc #64
        ; calculate character address
        stz <$73
        asl a
        rol <$73
        asl a
        rol <$73
        asl a
        rol <$73
        sta <$72
        lda <$73
        ora #$80
        sta <$73
        ; copy character gfx to buffer
        lda <$74
        and #1
        eor #1
        tax
        phy
        cly
a349:
        lda [$72],y
        sta $2700,x
        inx
        inx
        iny
        cpy #8
        bne a349
        ply
        bra a352
a344:
        ; write transparent pixels
        lda <$74
        and #1
        eor #1
        tax
        cla
a353:
        sta $2700,x
        inx
        inx
        cpx #16
        bcc a353
a352:
        bbr0 <$74,a346
        ; write spr gfx data to vram
        ldx #8
a350:
        st1 #0
        st2 #0
        dex
        bne a350
        tia $2700,$0002,$0010
        ldx #48
a351:
        st1 #0
        st2 #0
        dex
        bne a351
a346:
        dec <$74
        bne a345
        rts

instruments:
        .db 27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
        .db 1,1,2,4,5,8,10,13,16,19,22,24,27,28,30,31,31,31,30,28,27,24,22,19,16,13,10,8,5,4,2,1
        .db 4,5,6,6,7,8,9,9,10,11,12,12,13,14,15,15,16,17,18,18,19,20,21,21,22,23,24,24,25,26,27,27
        .db 3,9,14,17,19,21,22,23,23,24,24,24,25,25,25,25,26,26,26,26,26,27,27,27,27,27,27,28,28,28,28,28
        .db 0,3,7,11,16,21,25,28,31,30,28,25,21,18,16,15,17,19,22,26,29,31,30,28,25,21,16,12,8,5,2
        .db 5,10,15,20,25,28,24,21,20,21,22,23,24,25,26,27,28,29,30,20,10,2,0,0,0,0,0,0,0,0,0,2
        .db 5,10,15,20,25,28,24,21,20,21,22,23,24,25,26,27,28,29,30,31,24,18,13,9,6,4,2,15,12,8,4,0
        .db 1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,30,28,26,24,22,20,18,16,14,12,10,8,6,4,2,0

vibpat:
	.db 1,1,0,255,255,255,255,0,1,1
	.db 0,1,0,0,255,0,255,0,0,1

zoompal1:
        .incbin "scene2.pal"


;$2050-3 scaling factors 1
;$2054-7 scaling factors 2
;$2058-9 H offset (in blocks) and V offset
;$205C-D offsets for plane 2

        ; scene 2 script code
        ; 0-127 wait
        ; 128   swap buffers
        ; 129   clear plane 1
        ; 130   clear plane 2
        ; 131   render plane 1
        ; 132   render plane 2
        ; 133   loop (followed by count)
        ; 134   change palettes
        ; 135   bah humbug, marks the beginning of a loop
        ; 136   jump (followed by address)
        ; $9x   set a byte in zero page ($50 + x)
        ; $Ax   set a word in zero page ($50 + x)
        ; $Bx   add a byte to a word in zero page ($50 + x)
        ; $Cx   subtract a byte from a word in zero page ($50 + x)

scene2s:

        ; TURBO GRAFX logo appears
        .db 129,130,128,129,130
        .db $A8,8,16
        .db $A0,$20,0,$A2,$80,0,131,128

        .db 135,$B0,8,131,128,133,27

        .db 131,128,120,100

        ; CHOUKOUSOKU appears
        .db $AC,1,0,$A6,0,6

        .db $94,128,132,128
        .db $9C,1,132,128

        .db 135,$C6,9,132,128
        .db $C6,9,$BD,1,132,128,133,70

        .db 132
        .db 120,70,134,120

snakescr:
        .incbin "snake.scr"

        ; start SNAKE GAME replay
        .db $9E,1

        .db 136
        .dw snakescr


fishspr:
        .dw 74,0,$300,$1180
        .dw 74,32,$308,$1180
        .dw 229,640,$310,$1180
        .dw 114,$FF00,$300,$1180
        .dw 114,$FF20,$308,$1180

readyspr:
        .dw 160,128,$0040,$0180
        .dw 160,160,$0044,$0180

scorespr:
        .dw 264,114,$0040,$0180
        .dw 264,146,$0044,$0180
        .dw 264,178,$006E,$0080
        .dw 264,190,$006C,$0080

scorelut:
        .db $6C,$48,$4C,$50,$54,$58,$5C,$60,$64,$68

vsraml:
        .db 0,-3,-6,-9
        .db -11,-13,-15,-17,-19,-21,-23,-25
        .db -26,-28,-29,-31,-32,-34,-35,-37
        .db -38,-40,-42,-44,-46,-48,-50,-52
        .db -54,-57,-60,-63

logopal:
        .incbin "logo2.pal"

tankpal:
        .incbin "tank.pal"

sprpos:
        .incbin "sprpos.bin"

blastgfx:
        .incbin "blast.ce"
tankgfx:
        .incbin "tank1.ce"
        .incbin "tank2.ce"

        .bank 1
        .org $2000

        .incbin "font.1b"

        .org $3000
        
zoomrender:
        clx
        bra a166

zoomrender2:
        ldx #4
a166:

        lda #215
        sta <$45        ; rendering line count

        lda <$44
        beq a124
        lda #16
a124:
        cpx #4
        beq a167
        clc
        adc #8
a167:
        sta <$07        ;
        lda #$10        ; vram write address
        sta <$08        ;

        cla
        cpx #4
        bne a205
        lda #128
a205:
        stz <$46        ; x
        sta <$47

        clc
        adc #120
        sta modedge+1
        sta modedge2+1

        cla
        cpx #4
        bne a252
        dec a
a252:
        sta modbg1+1
        sta modbg1+3
        sta modbg2+1
        sta modbg2+3

        stz <$49        ; y
        lda #128
        sta <$4B

        ; write constants to the code
        lda <$50,x
        sta mod40a+1
        lda <$51,x
        sta mod41a+1

        lda <$52,x
        sta <$42
        lda <$53,x
        sta <$43

        lda <$58,x      
        sta <$4C        ; H offset

        lda <$59,x      ; V offset
        beq a207
        tay
        ldx <$45
a208:
        inc <$07        ; modify starting address to skip lines
        bne a209
        inc <$08
a209:
        txa
        and #7
        bne a210
        lda <$07
        clc
        adc #$F8
        sta <$07
        lda <$08
        adc #3
        sta <$08
a210:
        dex
        dey
        bne a208
        stx <$45
a207:

        lda #BANK(texture)
        tam #4
        inc a
        tam #5
        inc a
        tam #6

        ; build x-scaling lookup table

        lda #32
        sec
        sbc <$4C
        sta <$5A
        clx
        
        lda <$46
        sta <$48
        lda <$47
        sta <$4A

a238:
        ldy #8
a237:
        lda <$48
        clc
mod40a:
        adc #0
        sta <$48
        lda <$4A
mod41a:
        adc #1
        sta <$4A
        sta $3A00,x
modedge2:
        cmp #120
        bcs a245
        inx
        dey
        bne a237
        bra a246

a247:
        sta $3A00,x             ; pad end of block if it is outside texture
a245:
        inx
        dey
        bne a247
        bra a253

a246:
        dec <$5A
        bne a238
a253:

        stz <$4A

        ; begin loop that does actual rendering
a110:
        st0 #0
        lda <$07
        sta $0002
        lda <$08
        sta $0003
        st0 #2

        ldy #32
        lda <$4C        ; skip some blocks if needed
        beq a239
a206:
modbg1:
        st1 #0
        st2 #0
        dey
        dec a
        bne a206
a239:
        sty <$5B

        ldy <$47
        clx
a111:
        stz <$21

        ; load a pixel from texture (1/8)
        lda [$4A],y
        lsr a
        rol <$20
        lsr a
        rol <$21

        ; update source coordinates (advancing one pixel)
        ldy $3A00,x

        ; load a pixel from texture (2/8)
        lda [$4A],y
        lsr a
        rol <$20
        lsr a
        rol <$21

        ; update source coordinates (advancing one pixel)
        ldy $3A01,x

        ; load a pixel from texture (3/8)
        lda [$4A],y
        lsr a
        rol <$20
        lsr a
        rol <$21

        ; update source coordinates (advancing one pixel)
        ldy $3A02,x

        ; load a pixel from texture (4/8)
        lda [$4A],y
        lsr a
        rol <$20
        lsr a
        rol <$21

        ; update source coordinates (advancing one pixel)
        ldy $3A03,x

        ; load a pixel from texture (5/8)
        lda [$4A],y
        lsr a
        rol <$20
        lsr a
        rol <$21

        ; update source coordinates (advancing one pixel)
        ldy $3A04,x

        ; load a pixel from texture (6/8)
        lda [$4A],y
        lsr a
        rol <$20
        lsr a
        rol <$21

        ; update source coordinates (advancing one pixel)
        ldy $3A05,x

        ; load a pixel from texture (7/8)
        lda [$4A],y
        lsr a
        rol <$20
        lsr a
        rol <$21

        ; update source coordinates (advancing one pixel)
        ldy $3A06,x

        ; load a pixel from texture (8/8)
        lda [$4A],y
        lsr a
        rol <$20
        lsr a
        rol <$21

        lda <$20
        sta $0002
        lda <$21
        sta $0003

        dec <$5B
        beq a132

        ; update source coordinates (advancing one pixel)
        ldy $3A07,x
modedge:
        cpy #120
        bcs a204        ; edge of image within texture

        txa
        clc
        adc #8
        tax
a131:
        jmp a111


a204:
        ; fill the rest of this line with transparent/background pixels
modbg2:
        st1 #0
        st2 #0
        dec <$5B
        bne a204

        ; update source coordinates (advancing one line)
a132:

        lda <$49
        clc
        adc <$42
        sta <$49
        lda <$4B
        adc <$43
        ora #128
        cmp #224        ; bottom line
        bcs a112
        sta <$4B

        inc <$07
        bne a113
        inc <$08
a113:
        lda <$45
        and #7
        bne a114
        lda <$07
        clc
        adc #$F8
        sta <$07
        lda <$08
        adc #3
        sta <$08
a114:

        dec <$45
        beq a112
        jmp a110
a112:
        rts
renderend:
        .db 0

        .bank 2
        .org $4000

logoset:
        .incbin "logo2.lzm"

        .bank 4
        .org $8000
texture:
        .incbin "texture4.bin"


        .bank 7
        .org $4000

wav:
        .incbin "strange9.wav"
wavend:

        .bank 9
        .org $8000
fishpal:
        .incbin "fish.pal"
titlespr:
        .incbin "fish1.ce"
        .incbin "fish2.ce"
        .incbin "fish3.ce"
        .incbin "fish4.ce"
        .incbin "bolt1.ce"
        .incbin "bolt2.ce"

ready:
        .incbin "ready.ce"
score:
        .incbin "score.ce"
        .incbin "num12.ce"
        .incbin "num34.ce"
        .incbin "num56.ce"
        .incbin "num78.ce"
        .incbin "num90.ce"

dance:
        .incbin "s27.dt3"
        .db 254

strangetro:
        .incbin "str2.dt3"
        .db 254

creds:
        .incbin "cred5.dt3"
        .db 254

logomap:
        .incbin "logo2.map"

        .bank 10
        .org $4000
sreplay:
        .incbin "sreplay"

turbopal:
        .incbin "turbopad.pal"
turbomap:
        .incbin "turbopad.map"
        
        .bank 11
        .org $4000

turboset:
        .incbin "turbopad.lzm"

